/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.connect.ControlMessage;
import org.apache.hudi.connect.kafka.KafkaControlAgent;
import org.apache.hudi.connect.transaction.TransactionCoordinator;
import org.apache.hudi.connect.transaction.TransactionParticipant;
import org.apache.hudi.exception.HoodieException;

public class MockKafkaControlAgent
implements KafkaControlAgent {
    private final Map<String, TransactionCoordinator> coordinators = new HashMap<String, TransactionCoordinator>();
    private final Map<String, List<TransactionParticipant>> participants = new HashMap<String, List<TransactionParticipant>>();

    public void registerTransactionCoordinator(TransactionCoordinator coordinator) {
        this.coordinators.put(coordinator.getPartition().topic(), coordinator);
    }

    public void registerTransactionParticipant(TransactionParticipant participant) {
        if (!this.participants.containsKey(participant.getPartition().topic())) {
            this.participants.put(participant.getPartition().topic(), new ArrayList());
        }
        this.participants.get(participant.getPartition().topic()).add(participant);
    }

    public void deregisterTransactionCoordinator(TransactionCoordinator coordinator) {
        this.coordinators.remove(coordinator.getPartition().topic());
    }

    public void deregisterTransactionParticipant(TransactionParticipant worker) {
        if (this.participants.containsKey(worker.getPartition().topic())) {
            this.participants.get(worker.getPartition().topic()).remove(worker);
        }
    }

    public void publishMessage(ControlMessage message) {
        try {
            String topic = message.getTopicName();
            if (message.getSenderType().equals((Object)ControlMessage.EntityType.COORDINATOR)) {
                for (TransactionParticipant participant : this.participants.get(topic)) {
                    participant.processControlEvent(message);
                }
            } else {
                this.coordinators.get(topic).processControlEvent(message);
            }
        }
        catch (Exception exception) {
            throw new HoodieException("Fatal error trying to relay Kafka Control Messages for Testing.");
        }
    }
}

