/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.connect;

import java.nio.file.Path;
import java.util.List;
import org.apache.hudi.connect.utils.KafkaConnectUtils;
import org.apache.hudi.connect.writers.KafkaConnectConfigs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHdfsConfiguration {
    private boolean checkFiles(List<Path> paths) {
        paths.removeIf(p -> {
            String fileName = p.toFile().getName();
            return fileName.equals("core-site.xml") || fileName.equals("hdfs-site.xml");
        });
        return paths.isEmpty();
    }

    @Test
    public void testHadoopConfigEnvs() throws Exception {
        List paths = KafkaConnectUtils.getHadoopConfigFiles((String)"src/test/resources/hadoop_conf", (String)"");
        Assertions.assertEquals((int)paths.size(), (int)2);
        Assertions.assertTrue((boolean)this.checkFiles(paths));
    }

    @Test
    public void testHadoopHomeEnvs() throws Exception {
        List paths = KafkaConnectUtils.getHadoopConfigFiles((String)"", (String)"src/test/resources/hadoop_home");
        Assertions.assertEquals((int)paths.size(), (int)2);
        Assertions.assertTrue((boolean)this.checkFiles(paths));
    }

    @Test
    public void testKafkaConfig() throws Exception {
        KafkaConnectConfigs connectConfigs = KafkaConnectConfigs.newBuilder().withHadoopHome("src/test/resources/hadoop_home").build();
        List paths = KafkaConnectUtils.getHadoopConfigFiles((String)connectConfigs.getHadoopConfDir(), (String)connectConfigs.getHadoopConfHome());
        Assertions.assertEquals((int)paths.size(), (int)2);
        Assertions.assertTrue((boolean)this.checkFiles(paths));
    }
}

