/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.helper;

import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.connect.writers.ConnectWriter;
import org.apache.hudi.connect.writers.ConnectWriterProvider;
import org.apache.kafka.connect.sink.SinkRecord;

public class TestHudiWriterProvider
implements ConnectWriterProvider<WriteStatus> {
    private TestHudiWriter currentWriter;

    public int getLatestNumberWrites() {
        return this.currentWriter != null ? this.currentWriter.numberRecords : 0;
    }

    public boolean isClosed() {
        return this.currentWriter == null || this.currentWriter.isClosed;
    }

    public ConnectWriter<WriteStatus> getWriter(String commitTime) {
        this.currentWriter = new TestHudiWriter();
        return this.currentWriter;
    }

    private static class TestHudiWriter
    implements ConnectWriter<WriteStatus> {
        private int numberRecords = 0;
        private boolean isClosed = false;

        public int getNumberRecords() {
            return this.numberRecords;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public void writeRecord(SinkRecord record) {
            ++this.numberRecords;
        }

        public List<WriteStatus> close() {
            this.isClosed = false;
            return null;
        }
    }
}

