/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.writers;

import java.util.Comparator;
import java.util.List;
import org.apache.hudi.client.HoodieJavaWriteClient;
import org.apache.hudi.client.common.HoodieJavaEngineContext;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.connect.writers.BufferedConnectWriter;
import org.apache.hudi.connect.writers.KafkaConnectConfigs;
import org.apache.hudi.schema.SchemaProvider;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.writers.TestAbstractConnectWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestBufferedConnectWriter {
    private static final int NUM_RECORDS = 10;
    private static final String COMMIT_TIME = "101";
    private HoodieJavaWriteClient mockHoodieJavaWriteClient;
    private HoodieJavaEngineContext javaEngineContext;
    private KafkaConnectConfigs configs;
    private HoodieWriteConfig writeConfig;
    private SchemaProvider schemaProvider;

    @BeforeEach
    public void setUp() throws Exception {
        this.mockHoodieJavaWriteClient = (HoodieJavaWriteClient)Mockito.mock(HoodieJavaWriteClient.class);
        StorageConfiguration storageConf = HoodieTestUtils.getDefaultStorageConf();
        this.javaEngineContext = new HoodieJavaEngineContext(storageConf);
        this.configs = KafkaConnectConfigs.newBuilder().build();
        this.schemaProvider = new TestAbstractConnectWriter.TestSchemaProvider();
        this.writeConfig = HoodieWriteConfig.newBuilder().withEngineType(EngineType.JAVA).withPath("/tmp").withSchema(this.schemaProvider.getSourceSchema().toString()).build();
    }

    @Test
    public void testSimpleWriteAndFlush() throws Exception {
        String partitionPath = HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS[0];
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(new String[]{partitionPath});
        List records = dataGen.generateInserts(COMMIT_TIME, Integer.valueOf(10));
        BufferedConnectWriter writer = new BufferedConnectWriter((HoodieEngineContext)this.javaEngineContext, this.mockHoodieJavaWriteClient, COMMIT_TIME, this.configs, this.writeConfig, null, this.schemaProvider);
        for (int i = 0; i < 10; ++i) {
            writer.writeHudiRecord((HoodieRecord)records.get(i));
        }
        ((HoodieJavaWriteClient)Mockito.verify((Object)this.mockHoodieJavaWriteClient, (VerificationMode)Mockito.times((int)0))).bulkInsertPreppedRecords(ArgumentMatchers.anyList(), (String)ArgumentMatchers.eq((Object)COMMIT_TIME), (Option)ArgumentMatchers.eq((Object)Option.empty()));
        writer.flushRecords();
        ArgumentCaptor actualRecords = ArgumentCaptor.forClass(List.class);
        ((HoodieJavaWriteClient)Mockito.verify((Object)this.mockHoodieJavaWriteClient, (VerificationMode)Mockito.times((int)1))).bulkInsertPreppedRecords((List)actualRecords.capture(), (String)ArgumentMatchers.eq((Object)COMMIT_TIME), (Option)ArgumentMatchers.eq((Object)Option.empty()));
        ((List)actualRecords.getValue()).sort(Comparator.comparing(HoodieRecord::getRecordKey));
        records.sort(Comparator.comparing(HoodieRecord::getRecordKey));
        Assertions.assertEquals((Object)records, (Object)actualRecords.getValue());
    }
}

