/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.writers;

import java.nio.file.Path;
import java.util.Properties;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.connect.writers.KafkaConnectConfigs;
import org.apache.hudi.connect.writers.KafkaConnectTransactionServices;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestKafkaConnectTransactionServices {
    @TempDir
    Path path;

    @Test
    public void testTableCreation() {
        Properties props = new Properties();
        props.put("hoodie.table.name", "test");
        props.put("hoodie.base.path", this.path);
        props.put(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "partition_path");
        props.put(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "key");
        props.put("hoodie.table.version", "6");
        KafkaConnectConfigs configs = KafkaConnectConfigs.newBuilder().withProperties(props).build();
        new KafkaConnectTransactionServices(configs);
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((String)this.path.toFile().getPath());
        Assertions.assertEquals((Object)HoodieTableVersion.SIX, (Object)metaClient.getTableConfig().getTableVersion());
        Assertions.assertEquals((Object)HoodieTableType.COPY_ON_WRITE, (Object)metaClient.getTableConfig().getTableType());
    }
}

