/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.connect;

import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.connect.utils.KafkaConnectUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.FileIdPrefixProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConnectFileIdPrefixProvider
extends FileIdPrefixProvider {
    public static final String KAFKA_CONNECT_PARTITION_ID = "hudi.kafka.connect.partition";
    private static final Logger LOG = LoggerFactory.getLogger(KafkaConnectFileIdPrefixProvider.class);
    private final String kafkaPartition;

    public KafkaConnectFileIdPrefixProvider(TypedProperties props) {
        super(props);
        if (!props.containsKey((Object)KAFKA_CONNECT_PARTITION_ID)) {
            LOG.error("Fatal error due to Kafka Connect Partition Id is not set");
            throw new HoodieException("Kafka Connect Partition Key hudi.kafka.connect.partition not provided");
        }
        this.kafkaPartition = props.getProperty(KAFKA_CONNECT_PARTITION_ID);
    }

    public String createFilePrefix(String partitionPath) {
        String rawFileIdPrefix = this.kafkaPartition + partitionPath;
        String hashedPrefix = KafkaConnectUtils.hashDigest(rawFileIdPrefix);
        LOG.info("CreateFileId for Kafka Partition " + this.kafkaPartition + " : " + partitionPath + " = " + rawFileIdPrefix + " === " + hashedPrefix);
        return hashedPrefix;
    }
}

