/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Cancellable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.NeedUnmanagedConnectionException;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultBoundedCompletionService;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hudi.com.google.protobuf.ServiceException;

@InterfaceAudience.Private
public class RpcRetryingCallerWithReadReplicas {
    private static final Log LOG = LogFactory.getLog(RpcRetryingCallerWithReadReplicas.class);
    protected final ExecutorService pool;
    protected final ClusterConnection cConnection;
    protected final Configuration conf;
    protected final Get get;
    protected final TableName tableName;
    protected final int timeBeforeReplicas;
    private final int callTimeout;
    private final int retries;
    private final RpcControllerFactory rpcControllerFactory;
    private final RpcRetryingCallerFactory rpcRetryingCallerFactory;

    public RpcRetryingCallerWithReadReplicas(RpcControllerFactory rpcControllerFactory, TableName tableName, ClusterConnection cConnection, Get get, ExecutorService pool, int retries, int callTimeout, int timeBeforeReplicas) {
        this.rpcControllerFactory = rpcControllerFactory;
        this.tableName = tableName;
        this.cConnection = cConnection;
        this.conf = cConnection.getConfiguration();
        this.get = get;
        this.pool = pool;
        this.retries = retries;
        this.callTimeout = callTimeout;
        this.timeBeforeReplicas = timeBeforeReplicas;
        this.rpcRetryingCallerFactory = new RpcRetryingCallerFactory(this.conf);
    }

    public synchronized Result call() throws DoNotRetryIOException, InterruptedIOException, RetriesExhaustedException {
        ResultBoundedCompletionService.QueueingFuture<Result> f;
        boolean isTargetReplicaSpecified = this.get.getReplicaId() >= 0;
        RegionLocations rl = RpcRetryingCallerWithReadReplicas.getRegionLocations(true, isTargetReplicaSpecified ? this.get.getReplicaId() : 0, this.cConnection, this.tableName, this.get.getRow());
        ResultBoundedCompletionService<Result> cs = new ResultBoundedCompletionService<Result>(this.rpcRetryingCallerFactory, this.pool, rl.size());
        if (isTargetReplicaSpecified) {
            this.addCallsForReplica(cs, rl, this.get.getReplicaId(), this.get.getReplicaId());
        } else {
            this.addCallsForReplica(cs, rl, 0, 0);
            try {
                f = cs.poll(this.timeBeforeReplicas, TimeUnit.MICROSECONDS);
                if (f != null) {
                    return (Result)f.get();
                }
            }
            catch (ExecutionException e) {
                RpcRetryingCallerWithReadReplicas.throwEnrichedException(e, this.retries);
            }
            catch (CancellationException e) {
                throw new InterruptedIOException();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            this.addCallsForReplica(cs, rl, 1, rl.size() - 1);
        }
        try {
            f = cs.take();
            Result result = (Result)f.get();
            return result;
        }
        catch (ExecutionException e) {
            RpcRetryingCallerWithReadReplicas.throwEnrichedException(e, this.retries);
        }
        catch (CancellationException e) {
            throw new InterruptedIOException();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            cs.cancelAll();
        }
        return null;
    }

    static void throwEnrichedException(ExecutionException e, int retries) throws RetriesExhaustedException, DoNotRetryIOException {
        Throwable t = e.getCause();
        assert (t != null);
        if (t instanceof RetriesExhaustedException) {
            throw (RetriesExhaustedException)t;
        }
        if (t instanceof DoNotRetryIOException) {
            throw (DoNotRetryIOException)t;
        }
        if (t instanceof NeedUnmanagedConnectionException) {
            throw new DoNotRetryIOException(t);
        }
        RetriesExhaustedException.ThrowableWithExtraContext qt = new RetriesExhaustedException.ThrowableWithExtraContext(t, EnvironmentEdgeManager.currentTime(), null);
        List<RetriesExhaustedException.ThrowableWithExtraContext> exceptions = Collections.singletonList(qt);
        throw new RetriesExhaustedException(retries, exceptions);
    }

    private void addCallsForReplica(ResultBoundedCompletionService<Result> cs, RegionLocations rl, int min, int max) {
        for (int id = min; id <= max; ++id) {
            HRegionLocation hrl = rl.getRegionLocation(id);
            ReplicaRegionServerCallable callOnReplica = new ReplicaRegionServerCallable(id, hrl);
            cs.submit(callOnReplica, this.callTimeout, id);
        }
    }

    static RegionLocations getRegionLocations(boolean useCache, int replicaId, ClusterConnection cConnection, TableName tableName, byte[] row) throws RetriesExhaustedException, DoNotRetryIOException, InterruptedIOException {
        RegionLocations rl;
        try {
            rl = !useCache ? cConnection.relocateRegion(tableName, row, replicaId) : cConnection.locateRegion(tableName, row, useCache, true, replicaId);
        }
        catch (DoNotRetryIOException e) {
            throw e;
        }
        catch (NeedUnmanagedConnectionException e) {
            throw new DoNotRetryIOException(e);
        }
        catch (RetriesExhaustedException e) {
            throw e;
        }
        catch (InterruptedIOException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RetriesExhaustedException("Can't get the location", e);
        }
        if (rl == null) {
            throw new RetriesExhaustedException("Can't get the locations");
        }
        return rl;
    }

    class ReplicaRegionServerCallable
    extends RegionServerCallable<Result>
    implements Cancellable {
        final int id;
        private final PayloadCarryingRpcController controller;

        public ReplicaRegionServerCallable(int id, HRegionLocation location) {
            super(RpcRetryingCallerWithReadReplicas.this.cConnection, RpcRetryingCallerWithReadReplicas.this.tableName, RpcRetryingCallerWithReadReplicas.this.get.getRow());
            this.id = id;
            this.location = location;
            this.controller = RpcRetryingCallerWithReadReplicas.this.rpcControllerFactory.newController();
            this.controller.setPriority(this.tableName);
        }

        @Override
        public void cancel() {
            this.controller.startCancel();
        }

        @Override
        public void prepare(boolean reload) throws IOException {
            if (this.controller.isCanceled()) {
                return;
            }
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            if (reload || this.location == null) {
                RegionLocations rl = RpcRetryingCallerWithReadReplicas.getRegionLocations(false, this.id, RpcRetryingCallerWithReadReplicas.this.cConnection, this.tableName, RpcRetryingCallerWithReadReplicas.this.get.getRow());
                HRegionLocation hRegionLocation = this.location = this.id < rl.size() ? rl.getRegionLocation(this.id) : null;
            }
            if (this.location == null || this.location.getServerName() == null) {
                throw new HBaseIOException("There is no location for replica id #" + this.id);
            }
            ServerName dest = this.location.getServerName();
            this.setStub(RpcRetryingCallerWithReadReplicas.this.cConnection.getClient(dest));
        }

        @Override
        public Result call(int callTimeout) throws Exception {
            if (this.controller.isCanceled()) {
                return null;
            }
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            byte[] reg = this.location.getRegionInfo().getRegionName();
            ClientProtos.GetRequest request = RequestConverter.buildGetRequest(reg, RpcRetryingCallerWithReadReplicas.this.get);
            this.controller.setCallTimeout(callTimeout);
            try {
                ClientProtos.GetResponse response = this.getStub().get(this.controller, request);
                if (response == null) {
                    return null;
                }
                return ProtobufUtil.toResult(response.getResult());
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
        }

        @Override
        public boolean isCancelled() {
            return this.controller.isCanceled();
        }
    }
}

