/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.KeyValueCodec;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.com.google.common.io.CountingInputStream;
import org.apache.hudi.com.google.common.io.CountingOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestKeyValueCodec {
    @Test
    public void testEmptyWorks() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream(baos);
        DataOutputStream dos = new DataOutputStream(cos);
        KeyValueCodec kvc = new KeyValueCodec();
        Codec.Encoder encoder = kvc.getEncoder(dos);
        encoder.flush();
        dos.close();
        long offset = cos.getCount();
        Assert.assertEquals((long)0L, (long)offset);
        CountingInputStream cis = new CountingInputStream(new ByteArrayInputStream(baos.toByteArray()));
        DataInputStream dis = new DataInputStream(cis);
        Codec.Decoder decoder = kvc.getDecoder(dis);
        Assert.assertFalse((boolean)decoder.advance());
        dis.close();
        Assert.assertEquals((long)0L, (long)cis.getCount());
    }

    @Test
    public void testOne() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream(baos);
        DataOutputStream dos = new DataOutputStream(cos);
        KeyValueCodec kvc = new KeyValueCodec();
        Codec.Encoder encoder = kvc.getEncoder(dos);
        KeyValue kv = new KeyValue(Bytes.toBytes("r"), Bytes.toBytes("f"), Bytes.toBytes("q"), Bytes.toBytes("v"));
        long length = kv.getLength() + 4;
        encoder.write(kv);
        encoder.flush();
        dos.close();
        long offset = cos.getCount();
        Assert.assertEquals((long)length, (long)offset);
        CountingInputStream cis = new CountingInputStream(new ByteArrayInputStream(baos.toByteArray()));
        DataInputStream dis = new DataInputStream(cis);
        Codec.Decoder decoder = kvc.getDecoder(dis);
        Assert.assertTrue((boolean)decoder.advance());
        Assert.assertFalse((boolean)decoder.advance());
        dis.close();
        Assert.assertEquals((long)length, (long)cis.getCount());
    }

    @Test
    public void testThree() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream(baos);
        DataOutputStream dos = new DataOutputStream(cos);
        KeyValueCodec kvc = new KeyValueCodec();
        Codec.Encoder encoder = kvc.getEncoder(dos);
        KeyValue kv1 = new KeyValue(Bytes.toBytes("r"), Bytes.toBytes("f"), Bytes.toBytes("1"), Bytes.toBytes("1"));
        KeyValue kv2 = new KeyValue(Bytes.toBytes("r"), Bytes.toBytes("f"), Bytes.toBytes("2"), Bytes.toBytes("2"));
        KeyValue kv3 = new KeyValue(Bytes.toBytes("r"), Bytes.toBytes("f"), Bytes.toBytes("3"), Bytes.toBytes("3"));
        long length = kv1.getLength() + 4;
        encoder.write(kv1);
        encoder.write(kv2);
        encoder.write(kv3);
        encoder.flush();
        dos.close();
        long offset = cos.getCount();
        Assert.assertEquals((long)(length * 3L), (long)offset);
        CountingInputStream cis = new CountingInputStream(new ByteArrayInputStream(baos.toByteArray()));
        DataInputStream dis = new DataInputStream(cis);
        Codec.Decoder decoder = kvc.getDecoder(dis);
        Assert.assertTrue((boolean)decoder.advance());
        KeyValue kv = (KeyValue)decoder.current();
        Assert.assertTrue((boolean)kv1.equals(kv));
        Assert.assertTrue((boolean)decoder.advance());
        kv = (KeyValue)decoder.current();
        Assert.assertTrue((boolean)kv2.equals(kv));
        Assert.assertTrue((boolean)decoder.advance());
        kv = (KeyValue)decoder.current();
        Assert.assertTrue((boolean)kv3.equals(kv));
        Assert.assertFalse((boolean)decoder.advance());
        dis.close();
        Assert.assertEquals((long)(length * 3L), (long)cis.getCount());
    }
}

