/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.com.google.protobuf.RpcCallback;
import org.apache.hudi.com.google.protobuf.RpcController;
import org.apache.hudi.com.google.protobuf.Service;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public class MultiRowMutationEndpoint
extends MultiRowMutationProtos.MultiRowMutationService
implements CoprocessorService,
Coprocessor {
    private RegionCoprocessorEnvironment env;

    @Override
    public void mutateRows(RpcController controller, MultiRowMutationProtos.MutateRowsRequest request, RpcCallback<MultiRowMutationProtos.MutateRowsResponse> done) {
        MultiRowMutationProtos.MutateRowsResponse response = MultiRowMutationProtos.MutateRowsResponse.getDefaultInstance();
        try {
            TreeSet<byte[]> rowsToLock = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            List<ClientProtos.MutationProto> mutateRequestList = request.getMutationRequestList();
            ArrayList<Mutation> mutations = new ArrayList<Mutation>(mutateRequestList.size());
            for (ClientProtos.MutationProto m : mutateRequestList) {
                mutations.add(ProtobufUtil.toMutation(m));
            }
            HRegionInfo regionInfo = this.env.getRegion().getRegionInfo();
            for (Mutation m : mutations) {
                if (!HRegion.rowIsInRange(regionInfo, m.getRow())) {
                    String msg = "Requested row out of range '" + Bytes.toStringBinary(m.getRow()) + "'";
                    if (rowsToLock.isEmpty()) {
                        throw new WrongRegionException(msg);
                    }
                    throw new DoNotRetryIOException(msg);
                }
                rowsToLock.add(m.getRow());
            }
            long nonceGroup = request.hasNonceGroup() ? request.getNonceGroup() : 0L;
            long nonce = request.hasNonce() ? request.getNonce() : 0L;
            this.env.getRegion().mutateRowsWithLocks(mutations, rowsToLock, nonceGroup, nonce);
        }
        catch (IOException e) {
            ResponseConverter.setControllerException(controller, e);
        }
        done.run(response);
    }

    @Override
    public Service getService() {
        return this;
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
    }
}

