/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto;

import java.security.Key;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.apache.hudi.com.google.common.base.Preconditions;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Context
implements Configurable {
    private Configuration conf;
    private Cipher cipher;
    private Key key;
    private String keyHash;

    Context(Configuration conf) {
        this.conf = conf;
    }

    Context() {
        this(HBaseConfiguration.create());
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public String toString() {
        return "cipher=" + (this.cipher != null ? this.cipher.getName() : "NONE") + " keyHash=" + (this.keyHash != null ? this.keyHash.substring(0, 8) + "..." : "NONE");
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public Context setCipher(Cipher cipher) {
        this.cipher = cipher;
        return this;
    }

    public byte[] getKeyBytes() {
        return this.key.getEncoded();
    }

    public String getKeyBytesHash() {
        return this.keyHash;
    }

    public String getKeyFormat() {
        return this.key.getFormat();
    }

    public Key getKey() {
        return this.key;
    }

    public Context setKey(Key key) {
        Preconditions.checkNotNull(this.cipher, "Context does not have a cipher");
        byte[] encoded = key.getEncoded();
        if (encoded.length != this.cipher.getKeyLength()) {
            throw new RuntimeException("Illegal key length, have=" + encoded.length + ", want=" + this.cipher.getKeyLength());
        }
        this.key = key;
        this.keyHash = MD5Hash.getMD5AsHex(encoded);
        return this;
    }
}

