/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hudi.com.google.protobuf.BlockingRpcChannel;
import org.apache.hudi.com.google.protobuf.Descriptors;
import org.apache.hudi.com.google.protobuf.Message;
import org.apache.hudi.com.google.protobuf.RpcCallback;
import org.apache.hudi.com.google.protobuf.RpcChannel;
import org.apache.hudi.com.google.protobuf.RpcController;
import org.apache.hudi.com.google.protobuf.ServiceException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class CoprocessorRpcChannel
implements RpcChannel,
BlockingRpcChannel {
    private static final Log LOG = LogFactory.getLog(CoprocessorRpcChannel.class);

    @Override
    @InterfaceAudience.Private
    public void callMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype, RpcCallback<Message> callback) {
        Message response = null;
        try {
            response = this.callExecService(controller, method, request, responsePrototype);
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Call failed on IOException", (Throwable)ioe);
            ResponseConverter.setControllerException(controller, ioe);
        }
        if (callback != null) {
            callback.run(response);
        }
    }

    @Override
    @InterfaceAudience.Private
    public Message callBlockingMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype) throws ServiceException {
        try {
            return this.callExecService(controller, method, request, responsePrototype);
        }
        catch (IOException ioe) {
            throw new ServiceException("Error calling method " + method.getFullName(), ioe);
        }
    }

    protected abstract Message callExecService(RpcController var1, Descriptors.MethodDescriptor var2, Message var3, Message var4) throws IOException;
}

