/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.BulkReOpen;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.com.google.common.collect.Lists;
import org.apache.hudi.com.google.common.collect.Maps;

@InterfaceAudience.Private
public final class MasterDDLOperationHelper {
    private static final Log LOG = LogFactory.getLog(MasterDDLOperationHelper.class);

    private MasterDDLOperationHelper() {
    }

    public static boolean isOnlineSchemaChangeAllowed(MasterProcedureEnv env) {
        return env.getMasterServices().getConfiguration().getBoolean("hbase.online.schema.update.enable", false);
    }

    public static void checkTableModifiable(MasterProcedureEnv env, TableName tableName) throws IOException {
        if (!MetaTableAccessor.tableExists(env.getMasterServices().getConnection(), tableName)) {
            throw new TableNotFoundException(tableName);
        }
        if (!env.getMasterServices().getAssignmentManager().getTableStateManager().isTableState(tableName, ZooKeeperProtos.Table.State.DISABLED) && !MasterDDLOperationHelper.isOnlineSchemaChangeAllowed(env)) {
            throw new TableNotDisabledException(tableName);
        }
    }

    public static void deleteColumnFamilyFromFileSystem(MasterProcedureEnv env, TableName tableName, List<HRegionInfo> regionInfoList, byte[] familyName) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing family=" + Bytes.toString(familyName) + " from table=" + tableName));
        }
        if (regionInfoList == null) {
            regionInfoList = ProcedureSyncWait.getRegionsFromMeta(env, tableName);
        }
        for (HRegionInfo hri : regionInfoList) {
            mfs.deleteFamilyFromFS(hri, familyName);
        }
    }

    public static boolean reOpenAllRegions(MasterProcedureEnv env, TableName tableName, List<HRegionInfo> regionInfoList) throws IOException {
        boolean done = false;
        LOG.info((Object)"Bucketing regions by region server...");
        List<HRegionLocation> regionLocations = null;
        ClusterConnection connection = env.getMasterServices().getConnection();
        try (RegionLocator locator = connection.getRegionLocator(tableName);){
            regionLocations = locator.getAllRegionLocations();
        }
        TreeMap<HRegionInfo, ServerName> hri2Sn = new TreeMap<HRegionInfo, ServerName>();
        for (HRegionLocation location : regionLocations) {
            hri2Sn.put(location.getRegionInfo(), location.getServerName());
        }
        TreeMap<ServerName, List<HRegionInfo>> serverToRegions = Maps.newTreeMap();
        ArrayList<HRegionInfo> reRegions = new ArrayList<HRegionInfo>();
        for (HRegionInfo hri : regionInfoList) {
            ServerName sn = (ServerName)hri2Sn.get(hri);
            if (null == sn) {
                LOG.info((Object)("Skip " + hri));
                continue;
            }
            if (!serverToRegions.containsKey(sn)) {
                LinkedList hriList = Lists.newLinkedList();
                serverToRegions.put(sn, hriList);
            }
            reRegions.add(hri);
            ((List)serverToRegions.get(sn)).add(hri);
        }
        LOG.info((Object)("Reopening " + reRegions.size() + " regions on " + serverToRegions.size() + " region servers."));
        AssignmentManager am = env.getMasterServices().getAssignmentManager();
        am.setRegionsToReopen(reRegions);
        BulkReOpen bulkReopen = new BulkReOpen(env.getMasterServices(), serverToRegions, am);
        try {
            while (true) {
                if (bulkReopen.bulkReOpen()) {
                    done = true;
                    break;
                }
                LOG.warn((Object)"Timeout before reopening all regions");
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Reopen was interrupted");
            Thread.currentThread().interrupt();
        }
        return done;
    }
}

