/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hudi.com.google.common.util.concurrent.Service;

@InterfaceAudience.LimitedPrivate(value={"Replication"})
public interface ReplicationEndpoint
extends Service {
    public void init(Context var1) throws IOException;

    public boolean canReplicateToSameCluster();

    public UUID getPeerUUID();

    public WALEntryFilter getWALEntryfilter();

    public boolean replicate(ReplicateContext var1);

    @InterfaceAudience.LimitedPrivate(value={"Replication"})
    public static class ReplicateContext {
        List<WAL.Entry> entries;
        int size;
        String walGroupId;

        @InterfaceAudience.Private
        public ReplicateContext() {
        }

        public ReplicateContext setEntries(List<WAL.Entry> entries) {
            this.entries = entries;
            return this;
        }

        public ReplicateContext setSize(int size) {
            this.size = size;
            return this;
        }

        public ReplicateContext setWalGroupId(String walGroupId) {
            this.walGroupId = walGroupId;
            return this;
        }

        public List<WAL.Entry> getEntries() {
            return this.entries;
        }

        public int getSize() {
            return this.size;
        }

        public String getWalGroupId() {
            return this.walGroupId;
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"Replication"})
    public static class Context {
        private final Configuration conf;
        private final FileSystem fs;
        private final TableDescriptors tableDescriptors;
        private final ReplicationPeerConfig peerConfig;
        private final ReplicationPeer replicationPeer;
        private final String peerId;
        private final UUID clusterId;
        private final MetricsSource metrics;

        @InterfaceAudience.Private
        public Context(Configuration conf, FileSystem fs, ReplicationPeerConfig peerConfig, String peerId, UUID clusterId, ReplicationPeer replicationPeer, MetricsSource metrics, TableDescriptors tableDescriptors) {
            this.peerConfig = peerConfig;
            this.conf = conf;
            this.fs = fs;
            this.clusterId = clusterId;
            this.peerId = peerId;
            this.replicationPeer = replicationPeer;
            this.metrics = metrics;
            this.tableDescriptors = tableDescriptors;
        }

        public Configuration getConfiguration() {
            return this.conf;
        }

        public FileSystem getFilesystem() {
            return this.fs;
        }

        public UUID getClusterId() {
            return this.clusterId;
        }

        public String getPeerId() {
            return this.peerId;
        }

        public ReplicationPeerConfig getPeerConfig() {
            return this.peerConfig;
        }

        public ReplicationPeer getReplicationPeer() {
            return this.replicationPeer;
        }

        public MetricsSource getMetrics() {
            return this.metrics;
        }

        public TableDescriptors getTableDescriptors() {
            return this.tableDescriptors;
        }
    }
}

