/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSecretManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hudi.com.google.protobuf.RpcCallback;
import org.apache.hudi.com.google.protobuf.RpcController;
import org.apache.hudi.com.google.protobuf.Service;

@InterfaceAudience.Private
public class TokenProvider
implements AuthenticationProtos.AuthenticationService.Interface,
Coprocessor,
CoprocessorService {
    private static final Log LOG = LogFactory.getLog(TokenProvider.class);
    private AuthenticationTokenSecretManager secretManager;

    @Override
    public void start(CoprocessorEnvironment env) {
        RegionCoprocessorEnvironment regionEnv;
        RpcServerInterface server;
        SecretManager<? extends TokenIdentifier> mgr;
        if (env instanceof RegionCoprocessorEnvironment && (mgr = ((RpcServer)(server = (regionEnv = (RegionCoprocessorEnvironment)env).getRegionServerServices().getRpcServer())).getSecretManager()) instanceof AuthenticationTokenSecretManager) {
            this.secretManager = (AuthenticationTokenSecretManager)mgr;
        }
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    private boolean isAllowedDelegationTokenOp(UserGroupInformation ugi) throws IOException {
        UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS_SSL || authMethod == UserGroupInformation.AuthenticationMethod.CERTIFICATE;
    }

    @Override
    public Service getService() {
        return AuthenticationProtos.AuthenticationService.newReflectiveService(this);
    }

    @Override
    public void getAuthenticationToken(RpcController controller, AuthenticationProtos.GetAuthenticationTokenRequest request, RpcCallback<AuthenticationProtos.GetAuthenticationTokenResponse> done) {
        AuthenticationProtos.GetAuthenticationTokenResponse.Builder response = AuthenticationProtos.GetAuthenticationTokenResponse.newBuilder();
        try {
            if (this.secretManager == null) {
                throw new IOException("No secret manager configured for token authentication");
            }
            User currentUser = RpcServer.getRequestUser();
            UserGroupInformation ugi = null;
            if (currentUser != null) {
                ugi = currentUser.getUGI();
            }
            if (currentUser == null) {
                throw new AccessDeniedException("No authenticated user for request!");
            }
            if (!this.isAllowedDelegationTokenOp(ugi)) {
                LOG.warn((Object)("Token generation denied for user=" + currentUser.getName() + ", authMethod=" + ugi.getAuthenticationMethod()));
                throw new AccessDeniedException("Token generation only allowed for Kerberos authenticated clients");
            }
            Token<AuthenticationTokenIdentifier> token = this.secretManager.generateToken(currentUser.getName());
            response.setToken(ProtobufUtil.toToken(token)).build();
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException(controller, ioe);
        }
        done.run(response.build());
    }

    @Override
    public void whoAmI(RpcController controller, AuthenticationProtos.WhoAmIRequest request, RpcCallback<AuthenticationProtos.WhoAmIResponse> done) {
        User requestUser = RpcServer.getRequestUser();
        AuthenticationProtos.WhoAmIResponse.Builder response = AuthenticationProtos.WhoAmIResponse.newBuilder();
        if (requestUser != null) {
            response.setUsername(requestUser.getShortName());
            UserGroupInformation.AuthenticationMethod method = requestUser.getUGI().getAuthenticationMethod();
            if (method != null) {
                response.setAuthMethod(method.name());
            }
        }
        done.run(response.build());
    }
}

