/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.esotericsoftware.kryo.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hudi.com.esotericsoftware.kryo.KryoException;

public class Input
extends InputStream {
    protected byte[] buffer;
    protected int position;
    protected int capacity;
    protected int limit;
    protected long total;
    protected char[] chars = new char[32];
    protected InputStream inputStream;

    public Input() {
    }

    public Input(int bufferSize) {
        this.capacity = bufferSize;
        this.buffer = new byte[bufferSize];
    }

    public Input(byte[] buffer) {
        this.setBuffer(buffer, 0, buffer.length);
    }

    public Input(byte[] buffer, int offset, int count) {
        this.setBuffer(buffer, offset, count);
    }

    public Input(InputStream inputStream) {
        this(4096);
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null.");
        }
        this.inputStream = inputStream;
    }

    public Input(InputStream inputStream, int bufferSize) {
        this(bufferSize);
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null.");
        }
        this.inputStream = inputStream;
    }

    public void setBuffer(byte[] bytes) {
        this.setBuffer(bytes, 0, bytes.length);
    }

    public void setBuffer(byte[] bytes, int offset, int count) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.buffer = bytes;
        this.position = offset;
        this.limit = offset + count;
        this.capacity = bytes.length;
        this.total = 0L;
        this.inputStream = null;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.limit = 0;
        this.rewind();
    }

    public long total() {
        return this.total + (long)this.position;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int position() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int limit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void rewind() {
        this.position = 0;
        this.total = 0L;
    }

    public void skip(int count) throws KryoException {
        int skipCount = Math.min(this.limit - this.position, count);
        while (true) {
            this.position += skipCount;
            if ((count -= skipCount) == 0) break;
            skipCount = Math.min(count, this.capacity);
            this.require(skipCount);
        }
    }

    protected int fill(byte[] buffer, int offset, int count) throws KryoException {
        if (this.inputStream == null) {
            return -1;
        }
        try {
            return this.inputStream.read(buffer, offset, count);
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
    }

    protected int require(int required) throws KryoException {
        int count;
        int remaining = this.limit - this.position;
        if (remaining >= required) {
            return remaining;
        }
        if (required > this.capacity) {
            throw new KryoException("Buffer too small: capacity: " + this.capacity + ", required: " + required);
        }
        if (remaining > 0) {
            count = this.fill(this.buffer, this.limit, this.capacity - this.limit);
            if (count == -1) {
                throw new KryoException("Buffer underflow.");
            }
            if ((remaining += count) >= required) {
                this.limit += count;
                return remaining;
            }
        }
        System.arraycopy(this.buffer, this.position, this.buffer, 0, remaining);
        this.total += (long)this.position;
        this.position = 0;
        do {
            if ((count = this.fill(this.buffer, remaining, this.capacity - remaining)) != -1) continue;
            if (remaining >= required) break;
            throw new KryoException("Buffer underflow.");
        } while ((remaining += count) < required);
        this.limit = remaining;
        return remaining;
    }

    private int optional(int optional) throws KryoException {
        int remaining = this.limit - this.position;
        if (remaining >= optional) {
            return optional;
        }
        optional = Math.min(optional, this.capacity);
        int count = this.fill(this.buffer, this.limit, this.capacity - this.limit);
        if (count == -1) {
            return remaining == 0 ? -1 : Math.min(remaining, optional);
        }
        if ((remaining += count) >= optional) {
            this.limit += count;
            return optional;
        }
        System.arraycopy(this.buffer, this.position, this.buffer, 0, remaining);
        this.total += (long)this.position;
        this.position = 0;
        while ((count = this.fill(this.buffer, remaining, this.capacity - remaining)) != -1 && (remaining += count) < optional) {
        }
        this.limit = remaining;
        return remaining == 0 ? -1 : Math.min(remaining, optional);
    }

    public boolean eof() {
        return this.optional(1) <= 0;
    }

    @Override
    public int available() throws IOException {
        return this.limit - this.position + (null != this.inputStream ? this.inputStream.available() : 0);
    }

    @Override
    public int read() throws KryoException {
        if (this.optional(1) <= 0) {
            return -1;
        }
        return this.buffer[this.position++] & 0xFF;
    }

    @Override
    public int read(byte[] bytes) throws KryoException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int offset, int count) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int startingCount = count;
        int copyCount = Math.min(this.limit - this.position, count);
        do {
            System.arraycopy(this.buffer, this.position, bytes, offset, copyCount);
            this.position += copyCount;
            if ((count -= copyCount) == 0) break;
            offset += copyCount;
            copyCount = this.optional(count);
            if (copyCount != -1) continue;
            if (startingCount == count) {
                return -1;
            }
            break;
        } while (this.position != this.limit);
        return startingCount - count;
    }

    @Override
    public long skip(long count) throws KryoException {
        int skip;
        for (long remaining = count; remaining > 0L; remaining -= (long)skip) {
            skip = (int)Math.min(0x7FFFFFF7L, remaining);
            this.skip(skip);
        }
        return count;
    }

    @Override
    public void close() throws KryoException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public byte readByte() throws KryoException {
        this.require(1);
        return this.buffer[this.position++];
    }

    public int readByteUnsigned() throws KryoException {
        this.require(1);
        return this.buffer[this.position++] & 0xFF;
    }

    public byte[] readBytes(int length) throws KryoException {
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return bytes;
    }

    public void readBytes(byte[] bytes) throws KryoException {
        this.readBytes(bytes, 0, bytes.length);
    }

    public void readBytes(byte[] bytes, int offset, int count) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int copyCount = Math.min(this.limit - this.position, count);
        while (true) {
            System.arraycopy(this.buffer, this.position, bytes, offset, copyCount);
            this.position += copyCount;
            if ((count -= copyCount) == 0) break;
            offset += copyCount;
            copyCount = Math.min(count, this.capacity);
            this.require(copyCount);
        }
    }

    public int readInt() throws KryoException {
        this.require(4);
        byte[] buffer = this.buffer;
        int position = this.position;
        this.position = position + 4;
        return (buffer[position] & 0xFF) << 24 | (buffer[position + 1] & 0xFF) << 16 | (buffer[position + 2] & 0xFF) << 8 | buffer[position + 3] & 0xFF;
    }

    public int readInt(boolean optimizePositive) throws KryoException {
        return this.readVarInt(optimizePositive);
    }

    public int readVarInt(boolean optimizePositive) throws KryoException {
        if (this.require(1) < 5) {
            return this.readInt_slow(optimizePositive);
        }
        byte b = this.buffer[this.position++];
        int result = b & 0x7F;
        if ((b & 0x80) != 0) {
            byte[] buffer = this.buffer;
            b = buffer[this.position++];
            result |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                b = buffer[this.position++];
                result |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    b = buffer[this.position++];
                    result |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        b = buffer[this.position++];
                        result |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return optimizePositive ? result : result >>> 1 ^ -(result & 1);
    }

    private int readInt_slow(boolean optimizePositive) {
        byte b = this.buffer[this.position++];
        int result = b & 0x7F;
        if ((b & 0x80) != 0) {
            this.require(1);
            byte[] buffer = this.buffer;
            b = buffer[this.position++];
            result |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                this.require(1);
                b = buffer[this.position++];
                result |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    this.require(1);
                    b = buffer[this.position++];
                    result |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        this.require(1);
                        b = buffer[this.position++];
                        result |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return optimizePositive ? result : result >>> 1 ^ -(result & 1);
    }

    public boolean canReadInt() throws KryoException {
        if (this.limit - this.position >= 5) {
            return true;
        }
        if (this.optional(5) <= 0) {
            return false;
        }
        int p = this.position;
        if ((this.buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.buffer[p++] & 0x80) == 0) {
            return true;
        }
        return p != this.limit;
    }

    public boolean canReadLong() throws KryoException {
        if (this.limit - this.position >= 9) {
            return true;
        }
        if (this.optional(5) <= 0) {
            return false;
        }
        int p = this.position;
        if ((this.buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.buffer[p++] & 0x80) == 0) {
            return true;
        }
        return p != this.limit;
    }

    public String readString() {
        byte b;
        int available = this.require(1);
        if (((b = this.buffer[this.position++]) & 0x80) == 0) {
            return this.readAscii();
        }
        int charCount = available >= 5 ? this.readUtf8Length(b) : this.readUtf8Length_slow(b);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
        }
        if (this.chars.length < --charCount) {
            this.chars = new char[charCount];
        }
        this.readUtf8(charCount);
        return new String(this.chars, 0, charCount);
    }

    private int readUtf8Length(int b) {
        int result = b & 0x3F;
        if ((b & 0x40) != 0) {
            byte[] buffer = this.buffer;
            b = buffer[this.position++];
            result |= (b & 0x7F) << 6;
            if ((b & 0x80) != 0) {
                b = buffer[this.position++];
                result |= (b & 0x7F) << 13;
                if ((b & 0x80) != 0) {
                    b = buffer[this.position++];
                    result |= (b & 0x7F) << 20;
                    if ((b & 0x80) != 0) {
                        b = buffer[this.position++];
                        result |= (b & 0x7F) << 27;
                    }
                }
            }
        }
        return result;
    }

    private int readUtf8Length_slow(int b) {
        int result = b & 0x3F;
        if ((b & 0x40) != 0) {
            this.require(1);
            byte[] buffer = this.buffer;
            b = buffer[this.position++];
            result |= (b & 0x7F) << 6;
            if ((b & 0x80) != 0) {
                this.require(1);
                b = buffer[this.position++];
                result |= (b & 0x7F) << 13;
                if ((b & 0x80) != 0) {
                    this.require(1);
                    b = buffer[this.position++];
                    result |= (b & 0x7F) << 20;
                    if ((b & 0x80) != 0) {
                        this.require(1);
                        b = buffer[this.position++];
                        result |= (b & 0x7F) << 27;
                    }
                }
            }
        }
        return result;
    }

    private void readUtf8(int charCount) {
        byte[] buffer = this.buffer;
        char[] chars = this.chars;
        int charIndex = 0;
        int count = Math.min(this.require(1), charCount);
        int position = this.position;
        while (charIndex < count) {
            byte b;
            if ((b = buffer[position++]) < 0) {
                --position;
                break;
            }
            chars[charIndex++] = (char)b;
        }
        this.position = position;
        if (charIndex < charCount) {
            this.readUtf8_slow(charCount, charIndex);
        }
    }

    private void readUtf8_slow(int charCount, int charIndex) {
        char[] chars = this.chars;
        byte[] buffer = this.buffer;
        while (charIndex < charCount) {
            if (this.position == this.limit) {
                this.require(1);
            }
            int b = buffer[this.position++] & 0xFF;
            switch (b >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chars[charIndex] = (char)b;
                    break;
                }
                case 12: 
                case 13: {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    chars[charIndex] = (char)((b & 0x1F) << 6 | buffer[this.position++] & 0x3F);
                    break;
                }
                case 14: {
                    this.require(2);
                    chars[charIndex] = (char)((b & 0xF) << 12 | (buffer[this.position++] & 0x3F) << 6 | buffer[this.position++] & 0x3F);
                }
            }
            ++charIndex;
        }
    }

    private String readAscii() {
        byte b;
        byte[] buffer = this.buffer;
        int end = this.position;
        int start = end - 1;
        int limit = this.limit;
        do {
            if (end != limit) continue;
            return this.readAscii_slow();
        } while (((b = buffer[end++]) & 0x80) == 0);
        int n = end - 1;
        buffer[n] = (byte)(buffer[n] & 0x7F);
        String value = new String(buffer, 0, start, end - start);
        int n2 = end - 1;
        buffer[n2] = (byte)(buffer[n2] | 0x80);
        this.position = end;
        return value;
    }

    private String readAscii_slow() {
        byte b;
        --this.position;
        int charCount = this.limit - this.position;
        if (charCount > this.chars.length) {
            this.chars = new char[charCount * 2];
        }
        char[] chars = this.chars;
        byte[] buffer = this.buffer;
        int i = this.position;
        int ii = 0;
        int n = this.limit;
        while (i < n) {
            chars[ii] = (char)buffer[i];
            ++i;
            ++ii;
        }
        this.position = this.limit;
        while (true) {
            this.require(1);
            b = buffer[this.position++];
            if (charCount == chars.length) {
                char[] newChars = new char[charCount * 2];
                System.arraycopy(chars, 0, newChars, 0, charCount);
                chars = newChars;
                this.chars = newChars;
            }
            if ((b & 0x80) == 128) break;
            chars[charCount++] = (char)b;
        }
        chars[charCount++] = (char)(b & 0x7F);
        return new String(chars, 0, charCount);
    }

    public StringBuilder readStringBuilder() {
        byte b;
        int available = this.require(1);
        if (((b = this.buffer[this.position++]) & 0x80) == 0) {
            return new StringBuilder(this.readAscii());
        }
        int charCount = available >= 5 ? this.readUtf8Length(b) : this.readUtf8Length_slow(b);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return new StringBuilder("");
            }
        }
        if (this.chars.length < --charCount) {
            this.chars = new char[charCount];
        }
        this.readUtf8(charCount);
        StringBuilder builder = new StringBuilder(charCount);
        builder.append(this.chars, 0, charCount);
        return builder;
    }

    public float readFloat() throws KryoException {
        return Float.intBitsToFloat(this.readInt());
    }

    public float readFloat(float precision, boolean optimizePositive) throws KryoException {
        return (float)this.readInt(optimizePositive) / precision;
    }

    public short readShort() throws KryoException {
        this.require(2);
        return (short)((this.buffer[this.position++] & 0xFF) << 8 | this.buffer[this.position++] & 0xFF);
    }

    public int readShortUnsigned() throws KryoException {
        this.require(2);
        return (this.buffer[this.position++] & 0xFF) << 8 | this.buffer[this.position++] & 0xFF;
    }

    public long readLong() throws KryoException {
        this.require(8);
        byte[] buffer = this.buffer;
        return (long)buffer[this.position++] << 56 | (long)(buffer[this.position++] & 0xFF) << 48 | (long)(buffer[this.position++] & 0xFF) << 40 | (long)(buffer[this.position++] & 0xFF) << 32 | (long)(buffer[this.position++] & 0xFF) << 24 | (long)((buffer[this.position++] & 0xFF) << 16) | (long)((buffer[this.position++] & 0xFF) << 8) | (long)(buffer[this.position++] & 0xFF);
    }

    public long readLong(boolean optimizePositive) throws KryoException {
        return this.readVarLong(optimizePositive);
    }

    public long readVarLong(boolean optimizePositive) throws KryoException {
        if (this.require(1) < 9) {
            return this.readLong_slow(optimizePositive);
        }
        byte b = this.buffer[this.position++];
        long result = b & 0x7F;
        if ((b & 0x80) != 0) {
            byte[] buffer = this.buffer;
            b = buffer[this.position++];
            result |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                b = buffer[this.position++];
                result |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    b = buffer[this.position++];
                    result |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        b = buffer[this.position++];
                        result |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            b = buffer[this.position++];
                            result |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                b = buffer[this.position++];
                                result |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    b = buffer[this.position++];
                                    result |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        b = buffer[this.position++];
                                        result |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!optimizePositive) {
            result = result >>> 1 ^ -(result & 1L);
        }
        return result;
    }

    private long readLong_slow(boolean optimizePositive) {
        byte b = this.buffer[this.position++];
        long result = b & 0x7F;
        if ((b & 0x80) != 0) {
            this.require(1);
            byte[] buffer = this.buffer;
            b = buffer[this.position++];
            result |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                this.require(1);
                b = buffer[this.position++];
                result |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    this.require(1);
                    b = buffer[this.position++];
                    result |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        this.require(1);
                        b = buffer[this.position++];
                        result |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            this.require(1);
                            b = buffer[this.position++];
                            result |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                this.require(1);
                                b = buffer[this.position++];
                                result |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    this.require(1);
                                    b = buffer[this.position++];
                                    result |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        this.require(1);
                                        b = buffer[this.position++];
                                        result |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!optimizePositive) {
            result = result >>> 1 ^ -(result & 1L);
        }
        return result;
    }

    public boolean readBoolean() throws KryoException {
        this.require(1);
        return this.buffer[this.position++] == 1;
    }

    public char readChar() throws KryoException {
        this.require(2);
        return (char)((this.buffer[this.position++] & 0xFF) << 8 | this.buffer[this.position++] & 0xFF);
    }

    public double readDouble() throws KryoException {
        return Double.longBitsToDouble(this.readLong());
    }

    public double readDouble(double precision, boolean optimizePositive) throws KryoException {
        return (double)this.readLong(optimizePositive) / precision;
    }

    public int[] readInts(int length, boolean optimizePositive) throws KryoException {
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readInt(optimizePositive);
        }
        return array;
    }

    public long[] readLongs(int length, boolean optimizePositive) throws KryoException {
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readLong(optimizePositive);
        }
        return array;
    }

    public int[] readInts(int length) throws KryoException {
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readInt();
        }
        return array;
    }

    public long[] readLongs(int length) throws KryoException {
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readLong();
        }
        return array;
    }

    public float[] readFloats(int length) throws KryoException {
        float[] array = new float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readFloat();
        }
        return array;
    }

    public short[] readShorts(int length) throws KryoException {
        short[] array = new short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readShort();
        }
        return array;
    }

    public char[] readChars(int length) throws KryoException {
        char[] array = new char[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readChar();
        }
        return array;
    }

    public double[] readDoubles(int length) throws KryoException {
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readDouble();
        }
        return array;
    }
}

