/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.google.common.util.concurrent;

import java.util.concurrent.Executor;
import org.apache.hudi.com.google.common.annotations.Beta;
import org.apache.hudi.com.google.common.base.Throwables;
import org.apache.hudi.com.google.common.util.concurrent.AbstractService;
import org.apache.hudi.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hudi.com.google.common.util.concurrent.Service;

@Beta
public abstract class AbstractIdleService
implements Service {
    private final Service delegate = new AbstractService(){

        @Override
        protected final void doStart() {
            AbstractIdleService.this.executor(Service.State.STARTING).execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractIdleService.this.startUp();
                        this.notifyStarted();
                    }
                    catch (Throwable t) {
                        this.notifyFailed(t);
                        throw Throwables.propagate(t);
                    }
                }
            });
        }

        @Override
        protected final void doStop() {
            AbstractIdleService.this.executor(Service.State.STOPPING).execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractIdleService.this.shutDown();
                        this.notifyStopped();
                    }
                    catch (Throwable t) {
                        this.notifyFailed(t);
                        throw Throwables.propagate(t);
                    }
                }
            });
        }
    };

    protected abstract void startUp() throws Exception;

    protected abstract void shutDown() throws Exception;

    protected Executor executor(final Service.State state) {
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                new Thread(command, AbstractIdleService.this.getServiceName() + " " + (Object)((Object)state)).start();
            }
        };
    }

    public String toString() {
        return this.getServiceName() + " [" + (Object)((Object)this.state()) + "]";
    }

    @Override
    public final ListenableFuture<Service.State> start() {
        return this.delegate.start();
    }

    @Override
    public final Service.State startAndWait() {
        return this.delegate.startAndWait();
    }

    @Override
    public final boolean isRunning() {
        return this.delegate.isRunning();
    }

    @Override
    public final Service.State state() {
        return this.delegate.state();
    }

    @Override
    public final ListenableFuture<Service.State> stop() {
        return this.delegate.stop();
    }

    @Override
    public final Service.State stopAndWait() {
        return this.delegate.stopAndWait();
    }

    private String getServiceName() {
        return this.getClass().getSimpleName();
    }
}

