/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.BootstrapBaseFileSplit;
import org.apache.hudi.hadoop.BootstrapColumnStichingRecordReader;
import org.apache.hudi.hadoop.HoodieColumnProjectionUtils;
import org.apache.hudi.hadoop.InputPathHandler;
import org.apache.hudi.hadoop.PathWithBootstrapFileStatus;
import org.apache.hudi.hadoop.UseFileSplitsFromInputFormat;
import org.apache.hudi.hadoop.UseRecordReaderFromInputFormat;
import org.apache.hudi.hadoop.utils.HoodieHiveUtils;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@UseRecordReaderFromInputFormat
@UseFileSplitsFromInputFormat
public class HoodieParquetInputFormat
extends MapredParquetInputFormat
implements Configurable {
    private static final Logger LOG = LogManager.getLogger(HoodieParquetInputFormat.class);
    protected Configuration conf;

    protected HoodieDefaultTimeline filterInstantsTimeline(HoodieDefaultTimeline timeline) {
        return HoodieInputFormatUtils.filterInstantsTimeline(timeline);
    }

    public FileStatus[] listStatus(JobConf job) throws IOException {
        List<Path> snapshotPaths;
        List<String> incrementalTables = HoodieHiveUtils.getIncrementalTableNames((JobContext)Job.getInstance((Configuration)job));
        InputPathHandler inputPathHandler = new InputPathHandler(this.conf, HoodieParquetInputFormat.getInputPaths((JobConf)job), incrementalTables);
        ArrayList<FileStatus> returns = new ArrayList<FileStatus>();
        Map<String, HoodieTableMetaClient> tableMetaClientMap = inputPathHandler.getTableMetaClientMap();
        for (String table : incrementalTables) {
            List<Path> inputPaths;
            List<FileStatus> result;
            HoodieTableMetaClient metaClient = tableMetaClientMap.get(table);
            if (metaClient == null || (result = this.listStatusForIncrementalMode(job, metaClient, inputPaths = inputPathHandler.getGroupedIncrementalPaths().get(metaClient))) == null) continue;
            returns.addAll(result);
        }
        List<Path> nonHoodiePaths = inputPathHandler.getNonHoodieInputPaths();
        if (nonHoodiePaths.size() > 0) {
            HoodieParquetInputFormat.setInputPaths((JobConf)job, (Path[])nonHoodiePaths.toArray(new Path[nonHoodiePaths.size()]));
            FileStatus[] fileStatuses = super.listStatus(job);
            returns.addAll(Arrays.asList(fileStatuses));
        }
        if ((snapshotPaths = inputPathHandler.getSnapshotPaths()).size() > 0) {
            returns.addAll(HoodieInputFormatUtils.filterFileStatusForSnapshotMode(job, tableMetaClientMap, snapshotPaths));
        }
        return returns.toArray(new FileStatus[0]);
    }

    private List<FileStatus> listStatusForIncrementalMode(JobConf job, HoodieTableMetaClient tableMetaClient, List<Path> inputPaths) throws IOException {
        String tableName = tableMetaClient.getTableConfig().getTableName();
        Job jobContext = Job.getInstance((Configuration)job);
        Option<HoodieTimeline> timeline = HoodieInputFormatUtils.getFilteredCommitsTimeline(jobContext, tableMetaClient);
        if (!timeline.isPresent()) {
            return null;
        }
        Option<List<HoodieInstant>> commitsToCheck = HoodieInputFormatUtils.getCommitsForIncrementalQuery(jobContext, tableName, timeline.get());
        if (!commitsToCheck.isPresent()) {
            return null;
        }
        Option<String> incrementalInputPaths = HoodieInputFormatUtils.getAffectedPartitions(commitsToCheck.get(), tableMetaClient, timeline.get(), inputPaths);
        if (!incrementalInputPaths.isPresent()) {
            return null;
        }
        HoodieParquetInputFormat.setInputPaths((JobConf)job, (String)incrementalInputPaths.get());
        FileStatus[] fileStatuses = super.listStatus(job);
        return HoodieInputFormatUtils.filterIncrementalFileStatus(jobContext, tableMetaClient, timeline.get(), fileStatuses, commitsToCheck.get());
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public RecordReader<NullWritable, ArrayWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        if (split instanceof BootstrapBaseFileSplit) {
            BootstrapBaseFileSplit eSplit = (BootstrapBaseFileSplit)split;
            String[] rawColNames = HoodieColumnProjectionUtils.getReadColumnNames((Configuration)job);
            List<Integer> rawColIds = HoodieColumnProjectionUtils.getReadColumnIDs((Configuration)job);
            List projectedColsWithIndex = IntStream.range(0, rawColIds.size()).mapToObj(idx -> Pair.of(rawColIds.get(idx), rawColNames[idx])).collect(Collectors.toList());
            List hoodieColsProjected = projectedColsWithIndex.stream().filter(idxWithName -> HoodieRecord.HOODIE_META_COLUMNS.contains(idxWithName.getValue())).collect(Collectors.toList());
            List externalColsProjected = projectedColsWithIndex.stream().filter(idxWithName -> !HoodieRecord.HOODIE_META_COLUMNS.contains(idxWithName.getValue()) && !HoodieHiveUtils.VIRTUAL_COLUMN_NAMES.contains(idxWithName.getValue())).collect(Collectors.toList());
            List<Pair<String, String>> colNameWithTypes = HoodieColumnProjectionUtils.getIOColumnNameAndTypes((Configuration)job);
            List colNamesWithTypesForExternal = colNameWithTypes.stream().filter(p -> !HoodieRecord.HOODIE_META_COLUMNS.contains(p.getKey())).collect(Collectors.toList());
            LOG.info((Object)("colNameWithTypes =" + colNameWithTypes + ", Num Entries =" + colNameWithTypes.size()));
            if (hoodieColsProjected.isEmpty()) {
                return super.getRecordReader((InputSplit)eSplit.getBootstrapFileSplit(), job, reporter);
            }
            if (externalColsProjected.isEmpty()) {
                return super.getRecordReader(split, job, reporter);
            }
            FileSplit rightSplit = eSplit.getBootstrapFileSplit();
            JobConf jobConfCopy = new JobConf((Configuration)job);
            jobConfCopy.unset("hive.io.filter.expr.serialized");
            jobConfCopy.unset("sarg.pushdown");
            LOG.info((Object)("Generating column stitching reader for " + eSplit.getPath() + " and " + rightSplit.getPath()));
            return new BootstrapColumnStichingRecordReader((RecordReader<NullWritable, ArrayWritable>)super.getRecordReader((InputSplit)eSplit, jobConfCopy, reporter), HoodieRecord.HOODIE_META_COLUMNS.size(), (RecordReader<NullWritable, ArrayWritable>)super.getRecordReader((InputSplit)rightSplit, jobConfCopy, reporter), colNamesWithTypesForExternal.size(), true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("EMPLOYING DEFAULT RECORD READER - " + split));
        }
        return super.getRecordReader(split, job, reporter);
    }

    protected boolean isSplitable(FileSystem fs, Path filename) {
        return !(filename instanceof PathWithBootstrapFileStatus);
    }

    protected FileSplit makeSplit(Path file, long start, long length, String[] hosts) {
        FileSplit split = new FileSplit(file, start, length, hosts);
        if (file instanceof PathWithBootstrapFileStatus) {
            return this.makeExternalFileSplit((PathWithBootstrapFileStatus)file, split);
        }
        return split;
    }

    protected FileSplit makeSplit(Path file, long start, long length, String[] hosts, String[] inMemoryHosts) {
        FileSplit split = new FileSplit(file, start, length, hosts, inMemoryHosts);
        if (file instanceof PathWithBootstrapFileStatus) {
            return this.makeExternalFileSplit((PathWithBootstrapFileStatus)file, split);
        }
        return split;
    }

    private BootstrapBaseFileSplit makeExternalFileSplit(PathWithBootstrapFileStatus file, FileSplit split) {
        try {
            LOG.info((Object)("Making external data split for " + (Object)((Object)file)));
            FileStatus externalFileStatus = file.getBootstrapFileStatus();
            FileSplit externalFileSplit = this.makeSplit(externalFileStatus.getPath(), 0L, externalFileStatus.getLen(), new String[0], new String[0]);
            return new BootstrapBaseFileSplit(split, externalFileSplit);
        }
        catch (IOException e) {
            throw new HoodieIOException(e.getMessage(), e);
        }
    }
}

