/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.hadoop.hive.HoodieCombineRealtimeFileSplit;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeFileSplit;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeRecordReader;
import org.apache.hudi.hadoop.utils.HoodieRealtimeRecordReaderUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieCombineRealtimeRecordReader
implements RecordReader<NullWritable, ArrayWritable> {
    private static final transient Logger LOG = LogManager.getLogger(HoodieCombineRealtimeRecordReader.class);
    List<HoodieRealtimeRecordReader> recordReaders = new LinkedList<HoodieRealtimeRecordReader>();
    HoodieRealtimeRecordReader currentRecordReader;

    public HoodieCombineRealtimeRecordReader(JobConf jobConf, CombineFileSplit split, List<RecordReader> readers) {
        try {
            ValidationUtils.checkArgument(((HoodieCombineRealtimeFileSplit)split).getRealtimeFileSplits().size() == readers.size(), "Num Splits does not match number of unique RecordReaders!");
            for (InputSplit inputSplit : ((HoodieCombineRealtimeFileSplit)split).getRealtimeFileSplits()) {
                LOG.info((Object)"Creating new RealtimeRecordReader for split");
                this.recordReaders.add(new HoodieRealtimeRecordReader((HoodieRealtimeFileSplit)inputSplit, jobConf, (RecordReader<NullWritable, ArrayWritable>)readers.remove(0)));
            }
            this.currentRecordReader = this.recordReaders.remove(0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean next(NullWritable key, ArrayWritable value) throws IOException {
        if (this.currentRecordReader.next(key, value)) {
            LOG.info((Object)"Reading from record reader");
            LOG.info((Object)HoodieRealtimeRecordReaderUtils.arrayWritableToString(value));
            return true;
        }
        if (this.recordReaders.size() > 0) {
            this.currentRecordReader.close();
            this.currentRecordReader = this.recordReaders.remove(0);
            return this.next(key, value);
        }
        return false;
    }

    public NullWritable createKey() {
        return this.currentRecordReader.createKey();
    }

    public ArrayWritable createValue() {
        return this.currentRecordReader.createValue();
    }

    public long getPos() throws IOException {
        return this.currentRecordReader.getPos();
    }

    public void close() throws IOException {
        this.currentRecordReader.close();
    }

    public float getProgress() throws IOException {
        return this.currentRecordReader.getProgress();
    }
}

