/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.realtime.AbstractRealtimeRecordReader;
import org.apache.hudi.hadoop.realtime.RealtimeSplit;
import org.apache.hudi.hadoop.utils.HoodieRealtimeRecordReaderUtils;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

class RealtimeCompactedRecordReader
extends AbstractRealtimeRecordReader
implements RecordReader<NullWritable, ArrayWritable> {
    private static final Logger LOG = LogManager.getLogger(AbstractRealtimeRecordReader.class);
    protected final RecordReader<NullWritable, ArrayWritable> parquetReader;
    private final Map<String, HoodieRecord<? extends HoodieRecordPayload>> deltaRecordMap;

    public RealtimeCompactedRecordReader(RealtimeSplit split, JobConf job, RecordReader<NullWritable, ArrayWritable> realReader) throws IOException {
        super(split, job);
        this.parquetReader = realReader;
        this.deltaRecordMap = this.getMergedLogRecordScanner().getRecords();
    }

    private HoodieMergedLogRecordScanner getMergedLogRecordScanner() throws IOException {
        return ((HoodieMergedLogRecordScanner.Builder)HoodieMergedLogRecordScanner.newBuilder().withFileSystem(FSUtils.getFs(this.split.getPath().toString(), (Configuration)this.jobConf)).withBasePath(this.split.getBasePath()).withLogFilePaths((List)this.split.getDeltaLogPaths())).withReaderSchema(this.usesCustomPayload ? this.getWriterSchema() : this.getReaderSchema()).withLatestInstantTime(this.split.getMaxCommitTime()).withMaxMemorySizeInBytes(HoodieRealtimeRecordReaderUtils.getMaxCompactionMemoryInBytes(this.jobConf)).withReadBlocksLazily(Boolean.parseBoolean(this.jobConf.get("compaction.lazy.block.read.enabled", "true"))).withReverseReader(false).withBufferSize(this.jobConf.getInt("hoodie.memory.dfs.buffer.max.size", 0x100000)).withSpillableMapBasePath(this.jobConf.get("hoodie.memory.spillable.map.path", "/tmp/")).build();
    }

    public boolean next(NullWritable aVoid, ArrayWritable arrayWritable) throws IOException {
        String key;
        boolean result = this.parquetReader.next((Object)aVoid, (Object)arrayWritable);
        if (!result) {
            return false;
        }
        if (!this.deltaRecordMap.isEmpty() && this.deltaRecordMap.containsKey(key = arrayWritable.get()[2].toString())) {
            Option<IndexedRecord> rec = this.usesCustomPayload ? this.deltaRecordMap.get(key).getData().getInsertValue(this.getWriterSchema()) : this.deltaRecordMap.get(key).getData().getInsertValue(this.getReaderSchema());
            if (!rec.isPresent()) {
                return this.next(aVoid, arrayWritable);
            }
            GenericRecord recordToReturn = (GenericRecord)rec.get();
            if (this.usesCustomPayload) {
                recordToReturn = HoodieAvroUtils.rewriteRecord((GenericRecord)rec.get(), this.getReaderSchema());
            }
            ArrayWritable aWritable = (ArrayWritable)HoodieRealtimeRecordReaderUtils.avroToArrayWritable(recordToReturn, this.getHiveSchema());
            Writable[] replaceValue = aWritable.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("key %s, base values: %s, log values: %s", key, HoodieRealtimeRecordReaderUtils.arrayWritableToString(arrayWritable), HoodieRealtimeRecordReaderUtils.arrayWritableToString(aWritable)));
            }
            Writable[] originalValue = arrayWritable.get();
            try {
                System.arraycopy(replaceValue, 0, originalValue, 0, Math.min(originalValue.length, replaceValue.length));
                arrayWritable.set(originalValue);
            }
            catch (RuntimeException re) {
                LOG.error((Object)"Got exception when doing array copy", (Throwable)re);
                LOG.error((Object)("Base record :" + HoodieRealtimeRecordReaderUtils.arrayWritableToString(arrayWritable)));
                LOG.error((Object)("Log record :" + HoodieRealtimeRecordReaderUtils.arrayWritableToString(aWritable)));
                String errMsg = "Base-record :" + HoodieRealtimeRecordReaderUtils.arrayWritableToString(arrayWritable) + " ,Log-record :" + HoodieRealtimeRecordReaderUtils.arrayWritableToString(aWritable) + " ,Error :" + re.getMessage();
                throw new RuntimeException(errMsg, re);
            }
        }
        return true;
    }

    public NullWritable createKey() {
        return (NullWritable)this.parquetReader.createKey();
    }

    public ArrayWritable createValue() {
        return (ArrayWritable)this.parquetReader.createValue();
    }

    public long getPos() throws IOException {
        return this.parquetReader.getPos();
    }

    public void close() throws IOException {
        this.parquetReader.close();
    }

    public float getProgress() throws IOException {
        return this.parquetReader.getProgress();
    }
}

