/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.metadata.FileSystemBackedTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataMetrics;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.TimelineMergedTableMetadata;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class BaseTableMetadata
implements HoodieTableMetadata {
    private static final Logger LOG = LogManager.getLogger(BaseTableMetadata.class);
    static final long MAX_MEMORY_SIZE_IN_BYTES = 0x40000000L;
    static final int BUFFER_SIZE = 0xA00000;
    protected final transient HoodieEngineContext engineContext;
    protected final SerializableConfiguration hadoopConf;
    protected final String datasetBasePath;
    protected final HoodieTableMetaClient datasetMetaClient;
    protected final Option<HoodieMetadataMetrics> metrics;
    protected final HoodieMetadataConfig metadataConfig;
    protected final String spillableMapDirectory;
    protected boolean enabled;
    private TimelineMergedTableMetadata timelineMergedMetadata;

    protected BaseTableMetadata(HoodieEngineContext engineContext, HoodieMetadataConfig metadataConfig, String datasetBasePath, String spillableMapDirectory) {
        this.engineContext = engineContext;
        this.hadoopConf = new SerializableConfiguration(engineContext.getHadoopConf());
        this.datasetBasePath = datasetBasePath;
        this.datasetMetaClient = HoodieTableMetaClient.builder().setConf(this.hadoopConf.get()).setBasePath(datasetBasePath).build();
        this.spillableMapDirectory = spillableMapDirectory;
        this.metadataConfig = metadataConfig;
        this.enabled = metadataConfig.useFileListingMetadata();
        this.metrics = metadataConfig.enableMetrics() ? Option.of(new HoodieMetadataMetrics(Registry.getRegistry("HoodieMetadata"))) : Option.empty();
        if (this.enabled) {
            this.openTimelineScanner();
        }
    }

    @Override
    public List<String> getAllPartitionPaths() throws IOException {
        if (this.enabled) {
            try {
                return this.fetchAllPartitionPaths();
            }
            catch (Exception e) {
                if (this.metadataConfig.enableFallback()) {
                    LOG.error((Object)"Failed to retrieve list of partition from metadata", (Throwable)e);
                }
                throw new HoodieMetadataException("Failed to retrieve list of partition from metadata", e);
            }
        }
        return new FileSystemBackedTableMetadata(this.getEngineContext(), this.hadoopConf, this.datasetBasePath, this.metadataConfig.shouldAssumeDatePartitioning()).getAllPartitionPaths();
    }

    @Override
    public FileStatus[] getAllFilesInPartition(Path partitionPath) throws IOException {
        if (this.enabled) {
            try {
                return this.fetchAllFilesInPartition(partitionPath);
            }
            catch (Exception e) {
                if (this.metadataConfig.enableFallback()) {
                    LOG.error((Object)("Failed to retrieve files in partition " + partitionPath + " from metadata"), (Throwable)e);
                }
                throw new HoodieMetadataException("Failed to retrieve files in partition " + partitionPath + " from metadata", e);
            }
        }
        return new FileSystemBackedTableMetadata(this.getEngineContext(), this.hadoopConf, this.datasetBasePath, this.metadataConfig.shouldAssumeDatePartitioning()).getAllFilesInPartition(partitionPath);
    }

    protected List<String> fetchAllPartitionPaths() throws IOException {
        HoodieTimer timer = new HoodieTimer().startTimer();
        Option<HoodieRecord<HoodieMetadataPayload>> hoodieRecord = this.getMergedRecordByKey("__all_partitions__");
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_partitions", timer.endTimer()));
        List<String> partitions = Collections.emptyList();
        if (hoodieRecord.isPresent()) {
            if (!hoodieRecord.get().getData().getDeletions().isEmpty()) {
                throw new HoodieMetadataException("Metadata partition list record is inconsistent: " + hoodieRecord.get().getData());
            }
            partitions = hoodieRecord.get().getData().getFilenames();
            if (partitions.contains(".")) {
                partitions.remove(".");
                partitions.add("");
            }
        }
        if (this.metadataConfig.validateFileListingMetadata()) {
            timer.startTimer();
            FileSystemBackedTableMetadata fileSystemBackedTableMetadata = new FileSystemBackedTableMetadata(this.getEngineContext(), this.hadoopConf, this.datasetBasePath, this.metadataConfig.shouldAssumeDatePartitioning());
            List<String> actualPartitions = fileSystemBackedTableMetadata.getAllPartitionPaths();
            this.metrics.ifPresent(m -> m.updateMetrics("validate_partitions", timer.endTimer()));
            Collections.sort(actualPartitions);
            Collections.sort(partitions);
            if (!actualPartitions.equals(partitions)) {
                LOG.error((Object)"Validation of metadata partition list failed. Lists do not match.");
                LOG.error((Object)("Partitions from metadata: " + Arrays.toString(partitions.toArray())));
                LOG.error((Object)("Partitions from file system: " + Arrays.toString(actualPartitions.toArray())));
                this.metrics.ifPresent(m -> m.updateMetrics("validate_errors", 0L));
            }
            partitions = actualPartitions;
        }
        LOG.info((Object)("Listed partitions from metadata: #partitions=" + partitions.size()));
        return partitions;
    }

    FileStatus[] fetchAllFilesInPartition(Path partitionPath) throws IOException {
        String partitionName = FSUtils.getRelativePartitionPath(new Path(this.datasetBasePath), partitionPath);
        if (partitionName.isEmpty()) {
            partitionName = ".";
        }
        HoodieTimer timer = new HoodieTimer().startTimer();
        Option<HoodieRecord<HoodieMetadataPayload>> hoodieRecord = this.getMergedRecordByKey(partitionName);
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_files", timer.endTimer()));
        FileStatus[] statuses = new FileStatus[]{};
        if (hoodieRecord.isPresent()) {
            if (!hoodieRecord.get().getData().getDeletions().isEmpty()) {
                throw new HoodieMetadataException("Metadata record for partition " + partitionName + " is inconsistent: " + hoodieRecord.get().getData());
            }
            statuses = hoodieRecord.get().getData().getFileStatuses(this.hadoopConf.get(), partitionPath);
        }
        if (this.metadataConfig.validateFileListingMetadata()) {
            timer.startTimer();
            String partitionPathStr = FSUtils.getRelativePartitionPath(new Path(this.datasetMetaClient.getBasePath()), partitionPath);
            String latestDataInstantTime = this.getLatestDatasetInstantTime();
            HoodieTableFileSystemView dataFsView = new HoodieTableFileSystemView(this.datasetMetaClient, this.datasetMetaClient.getActiveTimeline());
            List<FileStatus> directStatuses = dataFsView.getAllFileSlices(partitionPathStr).flatMap(slice -> {
                ArrayList paths = new ArrayList();
                slice.getBaseFile().ifPresent(baseFile -> {
                    if (HoodieTimeline.compareTimestamps(baseFile.getCommitTime(), HoodieTimeline.LESSER_THAN_OR_EQUALS, latestDataInstantTime)) {
                        paths.add(baseFile.getFileStatus());
                    }
                });
                slice.getLogFiles().forEach(logFile -> paths.add(logFile.getFileStatus()));
                return paths.stream();
            }).collect(Collectors.toList());
            List directFilenames = directStatuses.stream().map(fileStatus -> fileStatus.getPath().getName()).sorted().collect(Collectors.toList());
            this.metrics.ifPresent(m -> m.updateMetrics("validate_files", timer.endTimer()));
            List metadataFilenames = Arrays.stream(statuses).map(s -> s.getPath().getName()).sorted().collect(Collectors.toList());
            if (!metadataFilenames.equals(directFilenames)) {
                LOG.error((Object)("Validation of metadata file listing for partition " + partitionName + " failed."));
                LOG.error((Object)("File list from metadata: " + Arrays.toString(metadataFilenames.toArray())));
                LOG.error((Object)("File list from direct listing: " + Arrays.toString(directFilenames.toArray())));
                this.metrics.ifPresent(m -> m.updateMetrics("validate_errors", 0L));
            }
            statuses = directStatuses.toArray(new FileStatus[0]);
        }
        LOG.info((Object)("Listed file in partition from metadata: partition=" + partitionName + ", #files=" + statuses.length));
        return statuses;
    }

    private Option<HoodieRecord<HoodieMetadataPayload>> getMergedRecordByKey(String key) {
        Option<HoodieRecord<HoodieMetadataPayload>> mergedRecord;
        Option<HoodieRecord<HoodieMetadataPayload>> metadataHoodieRecord = this.getRecordByKeyFromMetadata(key);
        Option<HoodieRecord<HoodieMetadataPayload>> timelineHoodieRecord = this.timelineMergedMetadata.getRecordByKey(key);
        if (timelineHoodieRecord.isPresent()) {
            if (metadataHoodieRecord.isPresent()) {
                HoodieMetadataPayload mergedPayload = timelineHoodieRecord.get().getData().preCombine(metadataHoodieRecord.get().getData());
                mergedRecord = Option.of(new HoodieRecord<HoodieMetadataPayload>(metadataHoodieRecord.get().getKey(), mergedPayload));
            } else {
                mergedRecord = timelineHoodieRecord;
            }
        } else {
            mergedRecord = metadataHoodieRecord;
        }
        return mergedRecord;
    }

    protected abstract Option<HoodieRecord<HoodieMetadataPayload>> getRecordByKeyFromMetadata(String var1);

    private void openTimelineScanner() {
        if (this.timelineMergedMetadata == null) {
            List<HoodieInstant> unSyncedInstants = this.findInstantsToSync();
            this.timelineMergedMetadata = new TimelineMergedTableMetadata(this.datasetMetaClient, unSyncedInstants, this.getSyncedInstantTime(), null);
        }
    }

    protected abstract List<HoodieInstant> findInstantsToSync();

    @Override
    public boolean isInSync() {
        return this.enabled && this.findInstantsToSync().isEmpty();
    }

    protected HoodieEngineContext getEngineContext() {
        return this.engineContext != null ? this.engineContext : new HoodieLocalEngineContext(this.hadoopConf.get());
    }

    protected String getLatestDatasetInstantTime() {
        return this.datasetMetaClient.getActiveTimeline().filterCompletedInstants().lastInstant().map(HoodieInstant::getTimestamp).orElse("0000000000000");
    }
}

