/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.org.apache.avro.Schema;

public class HoodieMetadataMergedLogRecordScanner
extends HoodieMergedLogRecordScanner {
    private Set<String> mergeKeyFilter;

    public HoodieMetadataMergedLogRecordScanner(FileSystem fs, String basePath, List<String> logFilePaths, Schema readerSchema, String latestInstantTime, Long maxMemorySizeInBytes, int bufferSize, String spillableMapBasePath, Set<String> mergeKeyFilter) {
        super(fs, basePath, logFilePaths, readerSchema, latestInstantTime, maxMemorySizeInBytes, false, false, bufferSize, spillableMapBasePath, false);
        this.mergeKeyFilter = mergeKeyFilter != null ? mergeKeyFilter : Collections.emptySet();
        this.performScan();
    }

    @Override
    protected void processNextRecord(HoodieRecord<? extends HoodieRecordPayload> hoodieRecord) throws IOException {
        if (this.mergeKeyFilter.isEmpty() || this.mergeKeyFilter.contains(hoodieRecord.getRecordKey())) {
            super.processNextRecord(hoodieRecord);
        }
    }

    @Override
    protected void processNextDeletedKey(HoodieKey hoodieKey) {
        if (this.mergeKeyFilter.isEmpty() || this.mergeKeyFilter.contains(hoodieKey.getRecordKey())) {
            super.processNextDeletedKey(hoodieKey);
        }
    }

    public Option<HoodieRecord<HoodieMetadataPayload>> getRecordByKey(String key) {
        return Option.ofNullable((HoodieRecord)this.records.get(key));
    }
}

