/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import io.hops.hudi.org.apache.commons.lang3.ArrayUtils;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.ExtendedCellBuilder;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class ExtendedCellBuilderImpl
implements ExtendedCellBuilder {
    protected byte[] row = null;
    protected int rOffset = 0;
    protected int rLength = 0;
    protected byte[] family = null;
    protected int fOffset = 0;
    protected int fLength = 0;
    protected byte[] qualifier = null;
    protected int qOffset = 0;
    protected int qLength = 0;
    protected long timestamp = Long.MAX_VALUE;
    protected KeyValue.Type type = null;
    protected byte[] value = null;
    protected int vOffset = 0;
    protected int vLength = 0;
    protected long seqId = 0L;
    protected byte[] tags = null;
    protected int tagsOffset = 0;
    protected int tagsLength = 0;

    @Override
    public ExtendedCellBuilder setRow(byte[] row) {
        return this.setRow(row, 0, ArrayUtils.getLength(row));
    }

    @Override
    public ExtendedCellBuilder setRow(byte[] row, int rOffset, int rLength) {
        this.row = row;
        this.rOffset = rOffset;
        this.rLength = rLength;
        return this;
    }

    @Override
    public ExtendedCellBuilder setFamily(byte[] family) {
        return this.setFamily(family, 0, ArrayUtils.getLength(family));
    }

    @Override
    public ExtendedCellBuilder setFamily(byte[] family, int fOffset, int fLength) {
        this.family = family;
        this.fOffset = fOffset;
        this.fLength = fLength;
        return this;
    }

    @Override
    public ExtendedCellBuilder setQualifier(byte[] qualifier) {
        return this.setQualifier(qualifier, 0, ArrayUtils.getLength(qualifier));
    }

    @Override
    public ExtendedCellBuilder setQualifier(byte[] qualifier, int qOffset, int qLength) {
        this.qualifier = qualifier;
        this.qOffset = qOffset;
        this.qLength = qLength;
        return this;
    }

    @Override
    public ExtendedCellBuilder setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Override
    public ExtendedCellBuilder setType(Cell.Type type) {
        this.type = PrivateCellUtil.toTypeByte(type);
        return this;
    }

    @Override
    public ExtendedCellBuilder setType(byte type) {
        this.type = KeyValue.Type.codeToType(type);
        return this;
    }

    @Override
    public ExtendedCellBuilder setValue(byte[] value) {
        return this.setValue(value, 0, ArrayUtils.getLength(value));
    }

    @Override
    public ExtendedCellBuilder setValue(byte[] value, int vOffset, int vLength) {
        this.value = value;
        this.vOffset = vOffset;
        this.vLength = vLength;
        return this;
    }

    @Override
    public ExtendedCellBuilder setTags(byte[] tags) {
        return this.setTags(tags, 0, ArrayUtils.getLength(tags));
    }

    @Override
    public ExtendedCellBuilder setTags(byte[] tags, int tagsOffset, int tagsLength) {
        this.tags = tags;
        this.tagsOffset = tagsOffset;
        this.tagsLength = tagsLength;
        return this;
    }

    @Override
    public ExtendedCellBuilder setTags(List<Tag> tags) {
        byte[] tagBytes = TagUtil.fromList(tags);
        return this.setTags(tagBytes);
    }

    @Override
    public ExtendedCellBuilder setSequenceId(long seqId) {
        this.seqId = seqId;
        return this;
    }

    private void checkBeforeBuild() {
        if (this.type == null) {
            throw new IllegalArgumentException("The type can't be NULL");
        }
    }

    protected abstract ExtendedCell innerBuild();

    @Override
    public ExtendedCell build() {
        this.checkBeforeBuild();
        return this.innerBuild();
    }

    @Override
    public ExtendedCellBuilder clear() {
        this.row = null;
        this.rOffset = 0;
        this.rLength = 0;
        this.family = null;
        this.fOffset = 0;
        this.fLength = 0;
        this.qualifier = null;
        this.qOffset = 0;
        this.qLength = 0;
        this.timestamp = Long.MAX_VALUE;
        this.type = null;
        this.value = null;
        this.vOffset = 0;
        this.vLength = 0;
        this.seqId = 0L;
        this.tags = null;
        this.tagsOffset = 0;
        this.tagsLength = 0;
        return this;
    }
}

