/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.hops.hudi.org.apache.commons.lang3.StringUtils;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.StringJoiner;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class RetriesExhaustedException
extends IOException {
    private static final long serialVersionUID = 1876775844L;

    public RetriesExhaustedException(String msg) {
        super(msg);
    }

    public RetriesExhaustedException(String msg, IOException e) {
        super(msg, e);
    }

    public RetriesExhaustedException(String callableVitals, int numTries, List<Throwable> exceptions) {
        super(RetriesExhaustedException.getMessage(callableVitals, numTries, exceptions));
    }

    @InterfaceAudience.Private
    public RetriesExhaustedException(int numRetries, List<ThrowableWithExtraContext> exceptions) {
        super(RetriesExhaustedException.getMessage(numRetries, exceptions), exceptions.isEmpty() ? null : exceptions.get(exceptions.size() - 1).throwable);
    }

    private static String getMessage(String callableVitals, int numTries, List<Throwable> exceptions) {
        StringBuilder buffer = new StringBuilder("Failed contacting ");
        buffer.append(callableVitals);
        buffer.append(" after ");
        buffer.append(numTries);
        buffer.append(" attempts.\nExceptions:\n");
        for (Throwable t : exceptions) {
            buffer.append(t.toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private static String getMessage(int numRetries, List<ThrowableWithExtraContext> exceptions) {
        StringBuilder buffer = new StringBuilder("Failed after attempts=");
        buffer.append(numRetries + 1);
        buffer.append(", exceptions:\n");
        for (ThrowableWithExtraContext t : exceptions) {
            buffer.append(t.toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    @InterfaceAudience.Private
    public static class ThrowableWithExtraContext {
        private final Throwable throwable;
        private final long whenAsEpochMilli;
        private final String extras;

        public ThrowableWithExtraContext(Throwable throwable, long whenAsEpochMilli, String extras) {
            this.throwable = throwable;
            this.whenAsEpochMilli = whenAsEpochMilli;
            this.extras = extras;
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(", ");
            if (this.whenAsEpochMilli != 0L) {
                joiner.add(DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(this.whenAsEpochMilli)));
            }
            if (StringUtils.isNotEmpty(this.extras)) {
                joiner.add(this.extras);
            }
            if (this.throwable != null) {
                joiner.add(this.throwable.toString());
            }
            return joiner.toString();
        }
    }
}

