/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import io.hops.hudi.org.apache.commons.lang3.builder.ToStringBuilder;
import io.hops.hudi.org.apache.commons.lang3.builder.ToStringStyle;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Message;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.util.Timeout;
import io.hops.hudi.org.apache.htrace.core.Span;
import io.hops.hudi.org.apache.htrace.core.Tracer;
import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class Call {
    final int id;
    final Message param;
    CellScanner cells;
    @SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Direct access is only allowed after done")
    Message response;
    Message responseDefaultType;
    @SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Direct access is only allowed after done")
    IOException error;
    private boolean done;
    final Descriptors.MethodDescriptor md;
    final int timeout;
    final int priority;
    final MetricsConnection.CallStats callStats;
    private final RpcCallback<Call> callback;
    final Span span;
    Timeout timeoutTask;

    protected Call(int id, Descriptors.MethodDescriptor md, Message param, CellScanner cells, Message responseDefaultType, int timeout, int priority, RpcCallback<Call> callback, MetricsConnection.CallStats callStats) {
        this.param = param;
        this.md = md;
        this.cells = cells;
        this.callStats = callStats;
        this.callStats.setStartTime(EnvironmentEdgeManager.currentTime());
        this.responseDefaultType = responseDefaultType;
        this.id = id;
        this.timeout = timeout;
        this.priority = priority;
        this.callback = callback;
        this.span = Tracer.getCurrentSpan();
    }

    public String toShortString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", this.id).append("methodName", this.md.getName()).toString();
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(this.toShortString()).append("param", Optional.ofNullable(this.param).map(ProtobufUtil::getShortTextFormat).orElse("")).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(IOException error) {
        Call call = this;
        synchronized (call) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.error = error;
        }
        this.callback.run(this);
    }

    private void callComplete() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        this.callback.run(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setException(IOException error) {
        Call call = this;
        synchronized (call) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.error = error;
        }
        this.callComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(Message response, CellScanner cells) {
        Call call = this;
        synchronized (call) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.response = response;
            this.cells = cells;
        }
        this.callComplete();
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public long getStartTime() {
        return this.callStats.getStartTime();
    }
}

