/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import io.hops.hudi.org.apache.commons.lang3.builder.EqualsBuilder;
import io.hops.hudi.org.apache.commons.lang3.builder.HashCodeBuilder;
import io.hops.hudi.org.apache.commons.lang3.builder.ToStringBuilder;
import io.hops.hudi.org.apache.commons.lang3.builder.ToStringStyle;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.NormalizationTarget;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
final class MergeNormalizationPlan
implements NormalizationPlan {
    private final List<NormalizationTarget> normalizationTargets;

    private MergeNormalizationPlan(List<NormalizationTarget> normalizationTargets) {
        Preconditions.checkNotNull(normalizationTargets);
        Preconditions.checkState(normalizationTargets.size() >= 2, "normalizationTargets.size() must be >= 2 but was %s", normalizationTargets.size());
        this.normalizationTargets = Collections.unmodifiableList(normalizationTargets);
    }

    @Override
    public NormalizationPlan.PlanType getType() {
        return NormalizationPlan.PlanType.MERGE;
    }

    public List<NormalizationTarget> getNormalizationTargets() {
        return this.normalizationTargets;
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("normalizationTargets", this.normalizationTargets).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergeNormalizationPlan that = (MergeNormalizationPlan)o;
        return new EqualsBuilder().append(this.normalizationTargets, that.normalizationTargets).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.normalizationTargets).toHashCode();
    }

    static class Builder {
        private final List<NormalizationTarget> normalizationTargets = new LinkedList<NormalizationTarget>();

        Builder() {
        }

        public Builder setTargets(List<NormalizationTarget> targets) {
            this.normalizationTargets.clear();
            this.normalizationTargets.addAll(targets);
            return this;
        }

        public Builder addTarget(RegionInfo regionInfo, long regionSizeMb) {
            this.normalizationTargets.add(new NormalizationTarget(regionInfo, regionSizeMb));
            return this;
        }

        public MergeNormalizationPlan build() {
            return new MergeNormalizationPlan(this.normalizationTargets);
        }
    }
}

