/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import io.hops.hudi.org.apache.commons.lang3.ArrayUtils;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SnapshotFileCache
implements Stoppable {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotFileCache.class);
    private volatile boolean stop = false;
    private final FileSystem fs;
    private final FileSystem workingFs;
    private final SnapshotFileInspector fileInspector;
    private final Path snapshotDir;
    private final Path workingSnapshotDir;
    private final Set<String> cache = new HashSet<String>();
    private final Map<String, SnapshotDirectoryInfo> snapshots = new HashMap<String, SnapshotDirectoryInfo>();
    private final Timer refreshTimer;

    public SnapshotFileCache(Configuration conf, long cacheRefreshPeriod, long cacheRefreshDelay, String refreshThreadName, SnapshotFileInspector inspectSnapshotFiles) throws IOException {
        this(CommonFSUtils.getCurrentFileSystem(conf), CommonFSUtils.getRootDir(conf), SnapshotDescriptionUtils.getWorkingSnapshotDir(CommonFSUtils.getRootDir(conf), conf).getFileSystem(conf), SnapshotDescriptionUtils.getWorkingSnapshotDir(CommonFSUtils.getRootDir(conf), conf), cacheRefreshPeriod, cacheRefreshDelay, refreshThreadName, inspectSnapshotFiles);
    }

    public SnapshotFileCache(FileSystem fs, Path rootDir, FileSystem workingFs, Path workingDir, long cacheRefreshPeriod, long cacheRefreshDelay, String refreshThreadName, SnapshotFileInspector inspectSnapshotFiles) {
        this.fs = fs;
        this.workingFs = workingFs;
        this.workingSnapshotDir = workingDir;
        this.fileInspector = inspectSnapshotFiles;
        this.snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir(rootDir);
        this.refreshTimer = new Timer(refreshThreadName, true);
        this.refreshTimer.scheduleAtFixedRate((TimerTask)new RefreshCacheTask(), cacheRefreshDelay, cacheRefreshPeriod);
    }

    public synchronized void triggerCacheRefreshForTesting() {
        try {
            this.refreshCache();
        }
        catch (IOException e) {
            LOG.warn("Failed to refresh snapshot hfile cache!", (Throwable)e);
        }
        LOG.debug("Current cache:" + this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Iterable<FileStatus> getUnreferencedFiles(Iterable<FileStatus> files, SnapshotManager snapshotManager) throws IOException {
        ArrayList<FileStatus> unReferencedFiles = Lists.newArrayList();
        List<String> snapshotsInProgress = null;
        boolean refreshed = false;
        Lock lock = null;
        if (snapshotManager != null) {
            lock = snapshotManager.getTakingSnapshotLock().writeLock();
        }
        if (lock == null || lock.tryLock()) {
            try {
                if (snapshotManager != null && snapshotManager.isTakingAnySnapshot()) {
                    LOG.warn("Not checking unreferenced files since snapshot is running, it will skip to clean the HFiles this time");
                    ArrayList<FileStatus> arrayList = unReferencedFiles;
                    return arrayList;
                }
                for (FileStatus file : files) {
                    String fileName = file.getPath().getName();
                    if (!refreshed && !this.cache.contains(fileName)) {
                        this.refreshCache();
                        refreshed = true;
                    }
                    if (this.cache.contains(fileName)) continue;
                    if (snapshotsInProgress == null) {
                        snapshotsInProgress = this.getSnapshotsInProgress();
                    }
                    if (snapshotsInProgress.contains(fileName)) continue;
                    unReferencedFiles.add(file);
                }
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
        return unReferencedFiles;
    }

    private void refreshCache() throws IOException {
        Object[] snapshotDirs = CommonFSUtils.listStatus(this.fs, this.snapshotDir, p -> !p.getName().equals(".tmp"));
        this.cache.clear();
        if (ArrayUtils.isEmpty(snapshotDirs)) {
            if (LOG.isDebugEnabled() && this.snapshots.size() > 0) {
                LOG.debug("No snapshots on-disk, clear cache");
            }
            this.snapshots.clear();
            return;
        }
        HashMap<String, SnapshotDirectoryInfo> newSnapshots = new HashMap<String, SnapshotDirectoryInfo>();
        for (Object snapshotDir : snapshotDirs) {
            String name = snapshotDir.getPath().getName();
            SnapshotDirectoryInfo files = this.snapshots.remove(name);
            if (files == null || files.hasBeenModified(snapshotDir.getModificationTime())) {
                Collection<String> storedFiles = this.fileInspector.filesUnderSnapshot(this.fs, snapshotDir.getPath());
                files = new SnapshotDirectoryInfo(snapshotDir.getModificationTime(), storedFiles);
            }
            this.cache.addAll(files.getFiles());
            newSnapshots.put(name, files);
        }
        this.snapshots.clear();
        this.snapshots.putAll(newSnapshots);
    }

    List<String> getSnapshotsInProgress() throws IOException {
        ArrayList<String> snapshotInProgress = Lists.newArrayList();
        Object[] snapshotsInProgress = CommonFSUtils.listStatus(this.workingFs, this.workingSnapshotDir);
        if (!ArrayUtils.isEmpty(snapshotsInProgress)) {
            for (Object snapshot : snapshotsInProgress) {
                try {
                    snapshotInProgress.addAll(this.fileInspector.filesUnderSnapshot(this.workingFs, snapshot.getPath()));
                }
                catch (CorruptedSnapshotException cse) {
                    LOG.info("Corrupted in-progress snapshot file exception, ignored.", (Throwable)cse);
                }
            }
        }
        return snapshotInProgress;
    }

    @Override
    public void stop(String why) {
        if (!this.stop) {
            this.stop = true;
            this.refreshTimer.cancel();
        }
    }

    @Override
    public boolean isStopped() {
        return this.stop;
    }

    private static class SnapshotDirectoryInfo {
        long lastModified;
        Collection<String> files;

        public SnapshotDirectoryInfo(long mtime, Collection<String> files) {
            this.lastModified = mtime;
            this.files = files;
        }

        public Collection<String> getFiles() {
            return this.files;
        }

        public boolean hasBeenModified(long mtime) {
            return this.lastModified < mtime;
        }
    }

    public class RefreshCacheTask
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SnapshotFileCache snapshotFileCache = SnapshotFileCache.this;
            synchronized (snapshotFileCache) {
                try {
                    SnapshotFileCache.this.refreshCache();
                }
                catch (IOException e) {
                    LOG.warn("Failed to refresh snapshot hfile cache!", (Throwable)e);
                    SnapshotFileCache.this.cache.clear();
                    SnapshotFileCache.this.snapshots.clear();
                }
            }
        }
    }

    static interface SnapshotFileInspector {
        public Collection<String> filesUnderSnapshot(FileSystem var1, Path var2) throws IOException;
    }
}

