/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.net;

import io.hops.hudi.org.apache.commons.lang3.StringUtils;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.net.HostAndPort;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class Address
implements Comparable<Address> {
    private HostAndPort hostAndPort;

    private Address(HostAndPort hostAndPort) {
        this.hostAndPort = hostAndPort;
    }

    public static Address fromParts(String hostname, int port) {
        return new Address(HostAndPort.fromParts(hostname, port));
    }

    public static Address fromString(String hostnameAndPort) {
        return new Address(HostAndPort.fromString(hostnameAndPort));
    }

    public String getHostname() {
        return this.hostAndPort.getHost();
    }

    public int getPort() {
        return this.hostAndPort.getPort();
    }

    public String toString() {
        return this.hostAndPort.toString();
    }

    public String toStringWithoutDomain() {
        String hostname = this.getHostname();
        String[] parts = hostname.split("\\.");
        if (parts.length > 1) {
            for (String part : parts) {
                if (StringUtils.isNumeric(part)) continue;
                return Address.fromParts(parts[0], this.getPort()).toString();
            }
        }
        return this.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Address) {
            Address that = (Address)other;
            return this.getHostname().equals(that.getHostname()) && this.getPort() == that.getPort();
        }
        return false;
    }

    public int hashCode() {
        return this.getHostname().hashCode() ^ this.getPort();
    }

    @Override
    public int compareTo(Address that) {
        int compare = this.getHostname().compareTo(that.getHostname());
        if (compare != 0) {
            return compare;
        }
        return this.getPort() - that.getPort();
    }
}

