/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.provider;

import io.hops.hudi.org.apache.commons.lang3.builder.HashCodeBuilder;
import java.util.Objects;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Authentication"})
@InterfaceStability.Evolving
public class SaslAuthMethod {
    private final String name;
    private final byte code;
    private final String saslMech;
    private final UserGroupInformation.AuthenticationMethod method;

    public SaslAuthMethod(String name, byte code, String saslMech, UserGroupInformation.AuthenticationMethod method) {
        this.name = name;
        this.code = code;
        this.saslMech = saslMech;
        this.method = method;
    }

    public String getName() {
        return this.name;
    }

    public byte getCode() {
        return this.code;
    }

    public String getSaslMechanism() {
        return this.saslMech;
    }

    public UserGroupInformation.AuthenticationMethod getAuthMethod() {
        return this.method;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SaslAuthMethod)) {
            return false;
        }
        SaslAuthMethod other = (SaslAuthMethod)o;
        return Objects.equals(this.name, other.name) && this.code == other.code && Objects.equals(this.saslMech, other.saslMech) && Objects.equals(this.method, other.method);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.name).append(this.code).append(this.saslMech).append(this.method).toHashCode();
    }
}

