/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import io.hops.hudi.org.apache.avro.AvroMissingFieldException;
import io.hops.hudi.org.apache.avro.AvroRuntimeException;
import io.hops.hudi.org.apache.avro.Schema;
import io.hops.hudi.org.apache.avro.data.RecordBuilder;
import io.hops.hudi.org.apache.avro.io.DatumReader;
import io.hops.hudi.org.apache.avro.io.DatumWriter;
import io.hops.hudi.org.apache.avro.io.Encoder;
import io.hops.hudi.org.apache.avro.io.ResolvingDecoder;
import io.hops.hudi.org.apache.avro.message.BinaryMessageDecoder;
import io.hops.hudi.org.apache.avro.message.BinaryMessageEncoder;
import io.hops.hudi.org.apache.avro.message.SchemaStore;
import io.hops.hudi.org.apache.avro.specific.AvroGenerated;
import io.hops.hudi.org.apache.avro.specific.SpecificData;
import io.hops.hudi.org.apache.avro.specific.SpecificRecord;
import io.hops.hudi.org.apache.avro.specific.SpecificRecordBase;
import io.hops.hudi.org.apache.avro.specific.SpecificRecordBuilderBase;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;

@AvroGenerated
public class StringWrapper
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 5591985680093715949L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"StringWrapper\",\"namespace\":\"org.apache.hudi.avro.model\",\"doc\":\"A record wrapping string type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<StringWrapper> ENCODER = new BinaryMessageEncoder(MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<StringWrapper> DECODER = new BinaryMessageDecoder(MODEL$, SCHEMA$);
    private String value;
    private static final DatumWriter<StringWrapper> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<StringWrapper> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<StringWrapper> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<StringWrapper> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<StringWrapper> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder<StringWrapper>(MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode(this);
    }

    public static StringWrapper fromByteBuffer(ByteBuffer b) throws IOException {
        return (StringWrapper)DECODER.decode(b);
    }

    public StringWrapper() {
    }

    public StringWrapper(String value) {
        this.value = value;
    }

    @Override
    public SpecificData getSpecificData() {
        return MODEL$;
    }

    @Override
    public Schema getSchema() {
        return SCHEMA$;
    }

    @Override
    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.value;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    @Override
    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.value = value$ != null ? value$.toString() : null;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(StringWrapper other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write(this, SpecificData.getEncoder(out));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        READER$.read(this, SpecificData.getDecoder(in));
    }

    @Override
    protected boolean hasCustomCoders() {
        return true;
    }

    @Override
    public void customEncode(Encoder out) throws IOException {
        out.writeString(this.value);
    }

    @Override
    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.value = in.readString();
        } else {
            block3: for (int i = 0; i < 1; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.value = in.readString();
                        continue block3;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<StringWrapper>
    implements RecordBuilder<StringWrapper> {
        private String value;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super(other);
            if (Builder.isValidValue(this.fields()[0], other.value)) {
                this.value = this.data().deepCopy(this.fields()[0].schema(), other.value);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
        }

        private Builder(StringWrapper other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue(this.fields()[0], other.value)) {
                this.value = this.data().deepCopy(this.fields()[0].schema(), other.value);
                this.fieldSetFlags()[0] = true;
            }
        }

        public String getValue() {
            return this.value;
        }

        public Builder setValue(String value) {
            this.validate(this.fields()[0], value);
            this.value = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasValue() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearValue() {
            this.value = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        @Override
        public StringWrapper build() {
            try {
                StringWrapper record = new StringWrapper();
                record.value = this.fieldSetFlags()[0] ? this.value : (String)this.defaultValue(this.fields()[0]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException(e);
            }
        }
    }
}

