/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.processors;

import io.hops.hudi.org.apache.avro.Schema;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import org.apache.hudi.avro.AvroLogicalTypeEnum;
import org.apache.hudi.avro.processors.Parser;
import org.apache.hudi.avro.processors.TimeLogicalTypeProcessor;
import org.apache.hudi.common.util.collection.Pair;

public class LocalTimestampMicroLogicalTypeProcessor
extends TimeLogicalTypeProcessor {
    public LocalTimestampMicroLogicalTypeProcessor() {
        super(AvroLogicalTypeEnum.LOCAL_TIMESTAMP_MICROS);
    }

    @Override
    public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
        return this.convertCommon(new Parser.LongParser(){

            @Override
            public Pair<Boolean, Object> handleStringValue(String value) {
                if (!LocalTimestampMicroLogicalTypeProcessor.this.isWellFormedDateTime(value)) {
                    return Pair.of(false, null);
                }
                Pair<Boolean, LocalDateTime> result = LocalTimestampMicroLogicalTypeProcessor.this.convertToLocalDateTime(value);
                if (!result.getLeft().booleanValue()) {
                    return Pair.of(false, null);
                }
                LocalDateTime time = result.getRight();
                long diffInMicros = TimeLogicalTypeProcessor.LOCAL_UNIX_EPOCH.until(time, ChronoField.MICRO_OF_SECOND.getBaseUnit());
                return Pair.of(true, diffInMicros);
            }
        }, value, schema);
    }
}

