/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import io.hops.hudi.com.esotericsoftware.kryo.Kryo;
import io.hops.hudi.com.esotericsoftware.kryo.io.Input;
import io.hops.hudi.com.esotericsoftware.kryo.io.Output;
import io.hops.hudi.org.apache.avro.Schema;
import io.hops.hudi.org.apache.avro.generic.GenericRecord;
import io.hops.hudi.org.apache.avro.generic.IndexedRecord;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.BaseAvroPayload;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.MetadataValues;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.keygen.BaseKeyGenerator;

public class HoodieAvroRecord<T extends HoodieRecordPayload>
extends HoodieRecord<T> {
    public HoodieAvroRecord(HoodieKey key, T data) {
        super(key, data);
    }

    public HoodieAvroRecord(HoodieKey key, T data, HoodieOperation operation) {
        super(key, data, operation, Option.empty());
    }

    public HoodieAvroRecord(HoodieRecord<T> record) {
        super(record);
    }

    public HoodieAvroRecord(HoodieKey key, T data, HoodieOperation operation, HoodieRecordLocation currentLocation, HoodieRecordLocation newLocation) {
        super(key, data, operation, currentLocation, newLocation);
    }

    public HoodieAvroRecord() {
    }

    @Override
    public HoodieRecord<T> newInstance() {
        return new HoodieAvroRecord<T>(this);
    }

    @Override
    public HoodieRecord<T> newInstance(HoodieKey key, HoodieOperation op) {
        return new HoodieAvroRecord<HoodieRecordPayload>(key, (HoodieRecordPayload)this.data, op);
    }

    @Override
    public HoodieRecord<T> newInstance(HoodieKey key) {
        return new HoodieAvroRecord<HoodieRecordPayload>(key, (HoodieRecordPayload)this.data);
    }

    @Override
    public T getData() {
        if (this.data == null) {
            throw new IllegalStateException("Payload already deflated for record.");
        }
        return (T)((HoodieRecordPayload)this.data);
    }

    @Override
    public Comparable<?> doGetOrderingValue(Schema recordSchema, Properties props) {
        return this.getData().getOrderingValue();
    }

    @Override
    public String getRecordKey(Schema recordSchema, Option<BaseKeyGenerator> keyGeneratorOpt) {
        return this.getRecordKey();
    }

    @Override
    public String getRecordKey(Schema recordSchema, String keyFieldName) {
        return this.getRecordKey();
    }

    @Override
    public HoodieRecord.HoodieRecordType getRecordType() {
        return HoodieRecord.HoodieRecordType.AVRO;
    }

    @Override
    public Object[] getColumnValues(Schema recordSchema, String[] columns, boolean consistentLogicalTimestampEnabled) {
        return HoodieAvroUtils.getRecordColumnValues((HoodieRecord)this, columns, recordSchema, consistentLogicalTimestampEnabled);
    }

    @Override
    public HoodieRecord joinWith(HoodieRecord other, Schema targetSchema) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HoodieRecord prependMetaFields(Schema recordSchema, Schema targetSchema, MetadataValues metadataValues, Properties props) {
        try {
            Option<IndexedRecord> avroRecordOpt = this.getData().getInsertValue(recordSchema, props);
            GenericRecord newAvroRecord = HoodieAvroUtils.rewriteRecordWithNewSchema(avroRecordOpt.get(), targetSchema);
            HoodieAvroIndexedRecord.updateMetadataValuesInternal(newAvroRecord, metadataValues);
            return new HoodieAvroIndexedRecord(this.getKey(), newAvroRecord, this.getOperation(), this.currentLocation, this.newLocation);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to deserialize record!", e);
        }
    }

    @Override
    public HoodieRecord rewriteRecordWithNewSchema(Schema recordSchema, Properties props, Schema newSchema, Map<String, String> renameCols) {
        try {
            GenericRecord oldRecord = (GenericRecord)this.getData().getInsertValue(recordSchema, props).get();
            GenericRecord rewriteRecord = HoodieAvroUtils.rewriteRecordWithNewSchema(oldRecord, newSchema, renameCols);
            return new HoodieAvroIndexedRecord(this.getKey(), rewriteRecord, this.getOperation(), this.currentLocation, this.newLocation);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to deserialize record!", e);
        }
    }

    @Override
    public HoodieRecord truncateRecordKey(Schema recordSchema, Properties props, String keyFieldName) throws IOException {
        GenericRecord avroRecordPayload = (GenericRecord)this.getData().getInsertValue(recordSchema, props).get();
        avroRecordPayload.put(keyFieldName, (Object)"");
        return new HoodieAvroIndexedRecord(this.getKey(), avroRecordPayload, this.getOperation(), this.currentLocation, this.newLocation);
    }

    @Override
    public boolean isDelete(Schema recordSchema, Properties props) throws IOException {
        if (HoodieOperation.isDelete(this.getOperation())) {
            return true;
        }
        if (this.data instanceof BaseAvroPayload) {
            return ((BaseAvroPayload)this.data).isDeleted(recordSchema, props);
        }
        return !((HoodieRecordPayload)this.data).getInsertValue(recordSchema, props).isPresent();
    }

    @Override
    public boolean shouldIgnore(Schema recordSchema, Properties props) throws IOException {
        Object recordPayload = this.getData();
        if (recordPayload instanceof BaseAvroPayload && ((BaseAvroPayload)recordPayload).canProduceSentinel()) {
            Option<IndexedRecord> insertRecord = recordPayload.getInsertValue(recordSchema, props);
            return insertRecord.isPresent() && insertRecord.get().equals(SENTINEL);
        }
        return false;
    }

    @Override
    public HoodieRecord<T> copy() {
        return this;
    }

    @Override
    public HoodieRecord wrapIntoHoodieRecordPayloadWithParams(Schema recordSchema, Properties props, Option<Pair<String, String>> simpleKeyGenFieldsOpt, Boolean withOperation, Option<String> partitionNameOp, Boolean populateMetaFields, Option<Schema> schemaWithoutMetaFields) throws IOException {
        IndexedRecord indexedRecord = ((HoodieRecordPayload)this.data).getInsertValue(recordSchema, props).get();
        String payloadClass = ConfigUtils.getPayloadClass(props);
        String preCombineField = ConfigUtils.getOrderingField(props);
        return HoodieAvroUtils.createHoodieRecordFromAvro(indexedRecord, payloadClass, preCombineField, simpleKeyGenFieldsOpt, withOperation, partitionNameOp, populateMetaFields, schemaWithoutMetaFields);
    }

    @Override
    public HoodieRecord wrapIntoHoodieRecordPayloadWithKeyGen(Schema recordSchema, Properties props, Option<BaseKeyGenerator> keyGen) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Option<Map<String, String>> getMetadata() {
        return this.getData().getMetadata();
    }

    @Override
    public Option<HoodieAvroIndexedRecord> toIndexedRecord(Schema recordSchema, Properties props) throws IOException {
        Option<IndexedRecord> avroData = this.getData().getInsertValue(recordSchema, props);
        if (avroData.isPresent()) {
            HoodieAvroIndexedRecord record = new HoodieAvroIndexedRecord(this.key, avroData.get(), this.operation, this.getData().getMetadata());
            return Option.of(record);
        }
        return Option.empty();
    }

    @Override
    public ByteArrayOutputStream getAvroBytes(Schema recordSchema, Properties props) throws IOException {
        if (this.data instanceof BaseAvroPayload) {
            byte[] data = ((BaseAvroPayload)this.getData()).getRecordBytes();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(data.length);
            baos.write(data);
            return baos;
        }
        Option<IndexedRecord> avroData = this.getData().getInsertValue(recordSchema, props);
        return avroData.map(HoodieAvroUtils::avroToBytesStream).orElse(new ByteArrayOutputStream(0));
    }

    @Override
    protected final void writeRecordPayload(T payload, Kryo kryo, Output output) {
        kryo.writeClassAndObject(output, payload);
    }

    @Override
    protected final T readRecordPayload(Kryo kryo, Input input) {
        return (T)((HoodieRecordPayload)kryo.readClassAndObject(input));
    }
}

