/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import io.hops.hudi.org.apache.avro.generic.GenericRecord;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.OperationModeAwareness;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieRecordUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieRecordUtils.class);
    private static final Map<String, Object> INSTANCE_CACHE = new HashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HoodieRecordMerger loadRecordMerger(String mergerClass) {
        try {
            HoodieRecordMerger recordMerger = (HoodieRecordMerger)INSTANCE_CACHE.get(mergerClass);
            if (null != recordMerger) return recordMerger;
            Class<HoodieRecordMerger> clazz = HoodieRecordMerger.class;
            synchronized (HoodieRecordMerger.class) {
                recordMerger = (HoodieRecordMerger)INSTANCE_CACHE.get(mergerClass);
                if (null != recordMerger) return recordMerger;
                recordMerger = (HoodieRecordMerger)ReflectionUtils.loadClass(mergerClass, new Object[0]);
                INSTANCE_CACHE.put(mergerClass, recordMerger);
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return recordMerger;
            }
        }
        catch (HoodieException e) {
            throw new HoodieException("Unable to instantiate hoodie merge class ", e);
        }
    }

    public static HoodieRecordMerger createRecordMerger(String basePath, EngineType engineType, List<String> mergerClassList, String recordMergerStrategy) {
        if (mergerClassList.isEmpty() || HoodieTableMetadata.isMetadataTable(basePath)) {
            return HoodieAvroRecordMerger.INSTANCE;
        }
        return HoodieRecordUtils.createValidRecordMerger(engineType, mergerClassList, recordMergerStrategy).orElse(HoodieAvroRecordMerger.INSTANCE);
    }

    public static Option<HoodieRecordMerger> createValidRecordMerger(EngineType engineType, String mergerImpls, String recordMergerStrategy) {
        return HoodieRecordUtils.createValidRecordMerger(engineType, ConfigUtils.split2List(mergerImpls), recordMergerStrategy);
    }

    public static Option<HoodieRecordMerger> createValidRecordMerger(EngineType engineType, List<String> mergeImplClassList, String recordMergeStrategyId) {
        return Option.fromJavaOptional(mergeImplClassList.stream().map(clazz -> HoodieRecordUtils.loadRecordMerger(clazz)).filter(Objects::nonNull).filter(merger -> merger.getMergingStrategy().equals(recordMergeStrategyId)).filter(merger -> HoodieRecordUtils.recordTypeCompatibleEngine(merger.getRecordType(), engineType)).findFirst());
    }

    public static <T extends HoodieRecordPayload> T loadPayload(String recordPayloadClass, Object[] payloadArgs, Class<?> ... constructorArgTypes) {
        try {
            return (T)((HoodieRecordPayload)ReflectionUtils.getClass(recordPayloadClass).getConstructor(constructorArgTypes).newInstance(payloadArgs));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new HoodieException("Unable to instantiate payload class ", e);
        }
    }

    public static <T extends HoodieRecordPayload> T loadPayload(String recordPayloadClass, GenericRecord record, Comparable orderingValue) {
        return HoodieRecordUtils.loadPayload(recordPayloadClass, new Object[]{record, orderingValue}, GenericRecord.class, Comparable.class);
    }

    public static boolean recordTypeCompatibleEngine(HoodieRecord.HoodieRecordType recordType, EngineType engineType) {
        return engineType == EngineType.SPARK && recordType == HoodieRecord.HoodieRecordType.SPARK;
    }

    public static HoodieRecordMerger mergerToPreCombineMode(HoodieRecordMerger merger) {
        return merger instanceof OperationModeAwareness ? ((OperationModeAwareness)((Object)merger)).asPreCombiningMode() : merger;
    }

    public static String getCurrentLocationInstant(HoodieRecord<?> record) {
        if (record.getCurrentLocation() != null) {
            return record.getCurrentLocation().getInstantTime();
        }
        return null;
    }

    static {
        INSTANCE_CACHE.put(HoodieAvroRecordMerger.class.getName(), HoodieAvroRecordMerger.INSTANCE);
    }
}

