/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.utils;

import io.hops.hudi.org.apache.avro.Schema;
import io.hops.hudi.org.apache.avro.generic.GenericRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.hive.ql.io.parquet.serde.ArrayWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hudi.hadoop.utils.HiveAvroSerializer;

public class ObjectInspectorCache {
    private final Map<String, TypeInfo> columnTypeMap = new HashMap<String, TypeInfo>();
    private final Map<Schema, ArrayWritableObjectInspector> objectInspectorCache = new HashMap<Schema, ArrayWritableObjectInspector>();
    private final Map<Schema, HiveAvroSerializer> serializerCache = new HashMap<Schema, HiveAvroSerializer>();

    public Map<String, TypeInfo> getColumnTypeMap() {
        return this.columnTypeMap;
    }

    public ObjectInspectorCache(Schema tableSchema, JobConf jobConf) {
        int columnNameListLen;
        String lastColName;
        Set writerSchemaColNames = tableSchema.getFields().stream().map(f -> f.name().toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        List columnNameList = Arrays.stream(jobConf.get("columns").split(",")).collect(Collectors.toList());
        ArrayList columnTypeList = TypeInfoUtils.getTypeInfosFromTypeString((String)jobConf.get("columns.types"));
        for (int i2 = columnNameListLen = columnNameList.size() - 1; i2 >= 0 && !writerSchemaColNames.contains(lastColName = (String)columnNameList.get(columnNameList.size() - 1)); --i2) {
            columnNameList.remove(columnNameList.size() - 1);
            columnTypeList.remove(columnTypeList.size() - 1);
        }
        IntStream.range(0, columnNameList.size()).boxed().forEach(i -> this.columnTypeMap.put((String)columnNameList.get((int)i), (TypeInfo)TypeInfoUtils.getTypeInfosFromTypeString((String)((TypeInfo)columnTypeList.get((int)i)).getQualifiedName()).get(0)));
        StructTypeInfo rowTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(columnNameList, (List)columnTypeList);
        ArrayWritableObjectInspector objectInspector = new ArrayWritableObjectInspector(rowTypeInfo);
        this.objectInspectorCache.put(tableSchema, objectInspector);
    }

    public Object getValue(ArrayWritable record, Schema schema, String fieldName) {
        ArrayWritableObjectInspector objectInspector = this.getObjectInspector(schema);
        StructField structFieldRef = objectInspector.getStructFieldRef(fieldName);
        if (structFieldRef == null) {
            return null;
        }
        return objectInspector.getStructFieldData((Object)record, structFieldRef);
    }

    public ArrayWritableObjectInspector getObjectInspector(Schema schema) {
        return this.objectInspectorCache.computeIfAbsent(schema, s -> {
            List columnNameList = s.getFields().stream().map(Schema.Field::name).collect(Collectors.toList());
            List columnTypeList = columnNameList.stream().map(this.columnTypeMap::get).collect(Collectors.toList());
            StructTypeInfo rowTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(columnNameList, columnTypeList);
            return new ArrayWritableObjectInspector(rowTypeInfo);
        });
    }

    public GenericRecord serialize(ArrayWritable record, Schema schema) {
        return this.serializerCache.computeIfAbsent(schema, s -> {
            List<String> columnNameList = s.getFields().stream().map(Schema.Field::name).collect(Collectors.toList());
            List<TypeInfo> columnTypeList = columnNameList.stream().map(this.columnTypeMap::get).collect(Collectors.toList());
            StructTypeInfo rowTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(columnNameList, columnTypeList);
            return new HiveAvroSerializer((ObjectInspector)new ArrayWritableObjectInspector(rowTypeInfo), columnNameList, columnTypeList);
        }).serialize(record, schema);
    }
}

