/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.callback;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.callback.HoodieClientInitCallback;
import org.apache.hudi.callback.impl.HoodieWriteCommitHttpCallback;
import org.apache.hudi.client.BaseHoodieClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.execution.bulkinsert.NonSortPartitionerWithRows;
import org.apache.hudi.storage.StorageConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mock;
import org.mockito.Mockito;

public class TestHoodieClientInitCallback {
    @TempDir
    Path tmpDir;
    @Mock
    static HoodieSparkEngineContext engineContext = (HoodieSparkEngineContext)Mockito.mock(HoodieSparkEngineContext.class);

    @BeforeAll
    public static void setup() {
        StorageConfiguration storageConfToReturn = HoodieTestUtils.getDefaultStorageConf();
        Mockito.when((Object)engineContext.getStorageConf()).thenReturn((Object)storageConfToReturn);
    }

    @Test
    public void testNoClientInitCallback() {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.tmpDir.toString()).withEmbeddedTimelineServerEnabled(false).build(false);
        Assertions.assertFalse((boolean)config.contains("user.defined.key1"));
        try (SparkRDDWriteClient writeClient = new SparkRDDWriteClient((HoodieEngineContext)engineContext, config);){
            Assertions.assertFalse((boolean)writeClient.getConfig().contains("user.defined.key1"));
            Assertions.assertFalse((boolean)writeClient.getTableServiceClient().getConfig().contains("user.defined.key1"));
        }
    }

    @Test
    public void testSingleClientInitCallback() {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.tmpDir.toString()).withEmbeddedTimelineServerEnabled(false).withClientInitCallbackClassNames(ChangeConfigInitCallbackTestClass.class.getName()).withProps(Collections.singletonMap(HoodieWriteConfig.WRITE_SCHEMA_OVERRIDE.key(), "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}")).build(false);
        Assertions.assertFalse((boolean)config.contains("user.defined.key1"));
        Assertions.assertFalse((boolean)new Schema.Parser().parse(config.getWriteSchema()).getObjectProps().containsKey("user.defined.key2"));
        try (SparkRDDWriteClient writeClient = new SparkRDDWriteClient((HoodieEngineContext)engineContext, config);){
            HoodieWriteConfig updatedConfig = writeClient.getConfig();
            Assertions.assertFalse((boolean)updatedConfig.contains("user.defined.key1"));
            Schema actualSchema = new Schema.Parser().parse(updatedConfig.getWriteSchema());
            Assertions.assertTrue((boolean)actualSchema.getObjectProps().containsKey("user.defined.key2"));
            Assertions.assertEquals((Object)"value2", actualSchema.getObjectProps().get("user.defined.key2"));
            updatedConfig = writeClient.getTableServiceClient().getConfig();
            Assertions.assertFalse((boolean)updatedConfig.contains("user.defined.key1"));
            actualSchema = new Schema.Parser().parse(updatedConfig.getWriteSchema());
            Assertions.assertTrue((boolean)actualSchema.getObjectProps().containsKey("user.defined.key2"));
            Assertions.assertEquals((Object)"value2", actualSchema.getObjectProps().get("user.defined.key2"));
        }
    }

    @Test
    public void testTwoClientInitCallbacks() {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.tmpDir.toString()).withEmbeddedTimelineServerEnabled(false).withClientInitCallbackClassNames(ChangeConfigInitCallbackTestClass.class.getName() + "," + AddConfigInitCallbackTestClass.class.getName()).withProps(Collections.singletonMap(HoodieWriteConfig.WRITE_SCHEMA_OVERRIDE.key(), "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}")).build(false);
        Assertions.assertFalse((boolean)config.contains("user.defined.key1"));
        Assertions.assertFalse((boolean)new Schema.Parser().parse(config.getWriteSchema()).getObjectProps().containsKey("user.defined.key2"));
        try (SparkRDDWriteClient writeClient = new SparkRDDWriteClient((HoodieEngineContext)engineContext, config);){
            HoodieWriteConfig updatedConfig = writeClient.getConfig();
            Assertions.assertTrue((boolean)updatedConfig.contains("user.defined.key1"));
            Assertions.assertEquals((Object)"value1", (Object)updatedConfig.getString("user.defined.key1"));
            Schema actualSchema = new Schema.Parser().parse(updatedConfig.getWriteSchema());
            Assertions.assertTrue((boolean)actualSchema.getObjectProps().containsKey("user.defined.key2"));
            Assertions.assertEquals((Object)"value2", actualSchema.getObjectProps().get("user.defined.key2"));
            updatedConfig = writeClient.getTableServiceClient().getConfig();
            Assertions.assertTrue((boolean)updatedConfig.contains("user.defined.key1"));
            Assertions.assertEquals((Object)"value1", (Object)updatedConfig.getString("user.defined.key1"));
            actualSchema = new Schema.Parser().parse(updatedConfig.getWriteSchema());
            Assertions.assertTrue((boolean)actualSchema.getObjectProps().containsKey("user.defined.key2"));
            Assertions.assertEquals((Object)"value2", actualSchema.getObjectProps().get("user.defined.key2"));
        }
    }

    @Test
    public void testClientInitCallbackThrowingException() {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.tmpDir.toString()).withEmbeddedTimelineServerEnabled(false).withClientInitCallbackClassNames(AddConfigInitCallbackTestClass.class.getName() + "," + ThrowExceptionCallbackTestClass.class.getName()).build(false);
        HoodieIOException exception = (HoodieIOException)Assertions.assertThrows(HoodieIOException.class, () -> new SparkRDDWriteClient((HoodieEngineContext)engineContext, config), (String)"Expects the initialization to throw a HoodieIOException");
        Assertions.assertEquals((Object)"Throwing exception during client initialization.", (Object)exception.getMessage());
    }

    @ParameterizedTest
    @MethodSource(value={"testArgsForNonCallbackClass"})
    public void testNonClientInitCallbackClassInConfig(String className, String errorMsg) {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.tmpDir.toString()).withEmbeddedTimelineServerEnabled(false).withClientInitCallbackClassNames(className).build(false);
        HoodieException exception = (HoodieException)Assertions.assertThrows(HoodieException.class, () -> new SparkRDDWriteClient((HoodieEngineContext)engineContext, config), (String)"Expects the initialization to throw a HoodieException");
        Assertions.assertEquals((Object)errorMsg, (Object)exception.getMessage());
    }

    private static Stream<Arguments> testArgsForNonCallbackClass() {
        return Arrays.stream(new String[][]{{HoodieWriteCommitHttpCallback.class.getName(), "Could not load class " + HoodieWriteCommitHttpCallback.class.getName()}, {NonSortPartitionerWithRows.class.getName(), NonSortPartitionerWithRows.class.getName() + " is not a subclass of " + HoodieClientInitCallback.class.getName()}}).map(Arguments::of);
    }

    public static class ThrowExceptionCallbackTestClass
    implements HoodieClientInitCallback {
        public void call(BaseHoodieClient hoodieClient) {
            throw new HoodieIOException("Throwing exception during client initialization.");
        }
    }

    public static class ChangeConfigInitCallbackTestClass
    implements HoodieClientInitCallback {
        public static final String CUSTOM_CONFIG_KEY2 = "user.defined.key2";
        public static final String CUSTOM_CONFIG_VALUE2 = "value2";

        public void call(BaseHoodieClient hoodieClient) {
            HoodieWriteConfig config = hoodieClient.getConfig();
            Schema schema = new Schema.Parser().parse(config.getWriteSchema());
            if (!schema.getObjectProps().containsKey(CUSTOM_CONFIG_KEY2)) {
                schema.addProp(CUSTOM_CONFIG_KEY2, CUSTOM_CONFIG_VALUE2);
            }
            config.getProps().setProperty(HoodieWriteConfig.WRITE_SCHEMA_OVERRIDE.key(), schema.toString());
        }
    }

    public static class AddConfigInitCallbackTestClass
    implements HoodieClientInitCallback {
        public static final String CUSTOM_CONFIG_KEY1 = "user.defined.key1";
        public static final String CUSTOM_CONFIG_VALUE1 = "value1";

        public void call(BaseHoodieClient hoodieClient) {
            HoodieWriteConfig config = hoodieClient.getConfig();
            config.setValue(CUSTOM_CONFIG_KEY1, CUSTOM_CONFIG_VALUE1);
        }
    }
}

