/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.metadata.SparkHoodieMetadataBulkInsertPartitioner;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.api.java.function.VoidFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Tuple2;

class TestSparkHoodieMetadataBulkInsertPartitioner
extends SparkClientFunctionalTestHarness {
    TestSparkHoodieMetadataBulkInsertPartitioner() {
    }

    @Test
    public void testPartitioner() {
        ArrayList records = new ArrayList();
        BiConsumer<String, Integer> initRecords = (fileGroupId, count) -> {
            while (true) {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count - 1);
                if (n <= 0) break;
                HoodieRecord r = HoodieMetadataPayload.createPartitionListRecord((List)Collections.EMPTY_LIST);
                r.unseal();
                r.setCurrentLocation(new HoodieRecordLocation("001", fileGroupId));
                r.seal();
                records.add(r);
            }
        };
        initRecords.accept(MetadataPartitionType.FILES.getFileIdPrefix() + "000", 3);
        initRecords.accept(MetadataPartitionType.FILES.getFileIdPrefix() + "001", 5);
        initRecords.accept(MetadataPartitionType.FILES.getFileIdPrefix() + "002", 7);
        initRecords.accept(MetadataPartitionType.FILES.getFileIdPrefix() + "004", 9);
        initRecords.accept(MetadataPartitionType.FILES.getFileIdPrefix() + "002", 11);
        SparkHoodieMetadataBulkInsertPartitioner partitioner = new SparkHoodieMetadataBulkInsertPartitioner(5);
        JavaRDD partitionedRecords = partitioner.repartitionRecords(this.jsc().parallelize(records, records.size()), 0);
        Assertions.assertEquals((int)5, (int)partitionedRecords.getNumPartitions(), (String)"Only 5 partitions should be there corresponding to 3 unique fileGroups in MDT");
        Assertions.assertTrue((boolean)partitioner.arePartitionRecordsSorted(), (String)"Must be sorted");
        partitionedRecords.foreachPartition((VoidFunction & Serializable)recordIterator -> {
            HoodieRecordLocation location = null;
            while (recordIterator.hasNext()) {
                HoodieRecord record = (HoodieRecord)recordIterator.next();
                HoodieRecordLocation recordLocation = record.getCurrentLocation();
                if (location == null) {
                    location = recordLocation;
                    continue;
                }
                Assertions.assertEquals((Object)recordLocation, (Object)location, (String)"Records should have the same location in a partition");
            }
        });
        Assertions.assertEquals((long)records.size(), (long)partitionedRecords.count(), (String)"Record count should match");
        Map recordsPerFileGroup = partitionedRecords.mapToPair((PairFunction & Serializable)r -> new Tuple2((Object)r.getCurrentLocation().getFileId(), (Object)1)).reduceByKey(Integer::sum).collectAsMap();
        Assertions.assertEquals((int)3, (Integer)((Integer)recordsPerFileGroup.get(MetadataPartitionType.FILES.getFileIdPrefix() + "000")), (String)"Number of records in each partition should be correct");
        Assertions.assertEquals((int)5, (Integer)((Integer)recordsPerFileGroup.get(MetadataPartitionType.FILES.getFileIdPrefix() + "001")), (String)"Number of records in each partition should be correct");
        Assertions.assertEquals((int)18, (Integer)((Integer)recordsPerFileGroup.get(MetadataPartitionType.FILES.getFileIdPrefix() + "002")), (String)"Number of records in each partition should be correct");
        Assertions.assertEquals((int)9, (Integer)((Integer)recordsPerFileGroup.get(MetadataPartitionType.FILES.getFileIdPrefix() + "004")), (String)"Number of records in each partition should be correct");
        Assertions.assertEquals((int)-1, (Integer)recordsPerFileGroup.getOrDefault(MetadataPartitionType.FILES.getFileIdPrefix() + "003", -1), (String)"No records in skipped file group");
        Set fileIDPrefixes = IntStream.of(0, 1, 2, 4).mapToObj(arg_0 -> ((SparkHoodieMetadataBulkInsertPartitioner)partitioner).getFileIdPfx(arg_0)).collect(Collectors.toSet());
        Assertions.assertEquals(fileIDPrefixes, recordsPerFileGroup.keySet(), (String)"fileIDPrefixes should match the name of the MDT fileGroups");
    }
}

