/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.bootstrap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.client.bootstrap.BootstrapMode;
import org.apache.hudi.client.bootstrap.selector.BootstrapRegexModeSelector;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBootstrapRegexModeSelector {
    private HoodieWriteConfig getConfig(String regex, BootstrapMode selectedMode) {
        return HoodieWriteConfig.newBuilder().withPath("").withBootstrapConfig(HoodieBootstrapConfig.newBuilder().withBootstrapModeSelectorRegex(regex).withBootstrapModeForRegexMatch(selectedMode).build()).forTable("test-trip-table").build();
    }

    @Test
    public void testModeSelector() {
        List<String> partitionPaths = Arrays.asList("2020/05/01", "2020/05/02", "2020/05/10", "2020/05/11");
        List input = partitionPaths.stream().map(p -> Pair.of((Object)p, new ArrayList())).collect(Collectors.toList());
        String regex = "2020/05/1[0-9]";
        BootstrapRegexModeSelector regexModeSelector = new BootstrapRegexModeSelector(this.getConfig(regex, BootstrapMode.FULL_RECORD));
        Map result = regexModeSelector.select(input);
        Assertions.assertTrue((boolean)((List)result.get(BootstrapMode.METADATA_ONLY)).contains("2020/05/01"));
        Assertions.assertTrue((boolean)((List)result.get(BootstrapMode.METADATA_ONLY)).contains("2020/05/02"));
        Assertions.assertTrue((boolean)((List)result.get(BootstrapMode.FULL_RECORD)).contains("2020/05/10"));
        Assertions.assertTrue((boolean)((List)result.get(BootstrapMode.FULL_RECORD)).contains("2020/05/11"));
        Assertions.assertEquals((int)2, (int)((List)result.get(BootstrapMode.METADATA_ONLY)).size());
        Assertions.assertEquals((int)2, (int)((List)result.get(BootstrapMode.FULL_RECORD)).size());
        regexModeSelector = new BootstrapRegexModeSelector(this.getConfig(regex, BootstrapMode.METADATA_ONLY));
        result = regexModeSelector.select(input);
        Assertions.assertTrue((boolean)((List)result.get(BootstrapMode.FULL_RECORD)).contains("2020/05/01"));
        Assertions.assertTrue((boolean)((List)result.get(BootstrapMode.FULL_RECORD)).contains("2020/05/02"));
        Assertions.assertTrue((boolean)((List)result.get(BootstrapMode.METADATA_ONLY)).contains("2020/05/10"));
        Assertions.assertTrue((boolean)((List)result.get(BootstrapMode.METADATA_ONLY)).contains("2020/05/11"));
        Assertions.assertEquals((int)2, (int)((List)result.get(BootstrapMode.METADATA_ONLY)).size());
        Assertions.assertEquals((int)2, (int)((List)result.get(BootstrapMode.FULL_RECORD)).size());
    }
}

