/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.function.SerializableBiFunction;
import org.apache.hudi.common.function.SerializablePairFlatMapFunction;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestHoodieSparkEngineContext
extends SparkClientFunctionalTestHarness {
    private HoodieSparkEngineContext context;

    TestHoodieSparkEngineContext() {
    }

    @BeforeEach
    void setUp() {
        this.context = new HoodieSparkEngineContext(this.jsc());
    }

    @Test
    void testAddRemoveCachedDataIds() {
        String basePath = "/tmp/foo";
        String instantTime = "000";
        this.context.putCachedDataIds(HoodieData.HoodieDataCacheKey.of((String)basePath, (String)instantTime), new int[]{1, 2, 3});
        Assertions.assertEquals(Arrays.asList(1, 2, 3), (Object)this.context.getCachedDataIds(HoodieData.HoodieDataCacheKey.of((String)basePath, (String)instantTime)));
        Assertions.assertEquals(Arrays.asList(1, 2, 3), (Object)this.context.removeCachedDataIds(HoodieData.HoodieDataCacheKey.of((String)basePath, (String)instantTime)));
        Assertions.assertTrue((boolean)this.context.getCachedDataIds(HoodieData.HoodieDataCacheKey.of((String)basePath, (String)instantTime)).isEmpty());
    }

    @Test
    void testSetJobStatus() {
        String jobGroupId = "jobGroupId";
        String initialJobDescription = "initialJobDescription";
        String activeModule = "TestModule";
        String activityDescription = "Running test operation";
        String expectedJobDescription = String.format("%s:%s", activeModule, activityDescription);
        this.context.getJavaSparkContext().setJobGroup(jobGroupId, initialJobDescription);
        Assertions.assertEquals((Object)jobGroupId, (Object)this.context.getJavaSparkContext().getLocalProperty("spark.jobGroup.id"));
        Assertions.assertEquals((Object)initialJobDescription, (Object)this.context.getJavaSparkContext().getLocalProperty("spark.job.description"));
        this.context.setJobStatus(activeModule, activityDescription);
        Assertions.assertEquals((Object)expectedJobDescription, (Object)this.context.getJavaSparkContext().getLocalProperty("spark.job.description"));
        Assertions.assertEquals((Object)jobGroupId, (Object)this.context.getJavaSparkContext().getLocalProperty("spark.jobGroup.id"));
    }

    @Test
    void testMapPartitionsToPairAndReduceByKey() {
        int numPartitions = 6;
        HoodieData rddData = this.context.parallelize(IntStream.rangeClosed(0, 99).boxed().collect(Collectors.toList()), numPartitions);
        List<ImmutablePair> result = this.context.mapPartitionsToPairAndReduceByKey(rddData.collectAsList().stream(), (SerializablePairFlatMapFunction)new SerializablePairFlatMapTestFunc(), (SerializableBiFunction)new SerializableReduceTestFunc(), 6).collect(Collectors.toList());
        Assertions.assertEquals((int)50, (int)result.size());
        result.forEach(entry -> Assertions.assertEquals((int)((Integer)entry.getKey() * 10), (Integer)((Integer)entry.getValue())));
    }

    static class SerializableReduceTestFunc
    implements SerializableBiFunction<Integer, Integer, Integer> {
        SerializableReduceTestFunc() {
        }

        public Integer apply(Integer integer, Integer integer2) {
            return integer + integer2;
        }
    }

    static class SerializablePairFlatMapTestFunc
    implements SerializablePairFlatMapFunction<Iterator<Integer>, Integer, Integer> {
        SerializablePairFlatMapTestFunc() {
        }

        public Stream<Pair<Integer, Integer>> call(Iterator<Integer> t) throws Exception {
            ArrayList<Pair> toReturn = new ArrayList<Pair>();
            while (t.hasNext()) {
                Integer next = t.next();
                toReturn.add(Pair.of((Object)(next / 2), (Object)(next / 2 * 5)));
            }
            return toReturn.stream();
        }
    }
}

