/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.functional;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializableFunctionUnchecked;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestHoodieFileSystemViews
extends HoodieClientTestBase {
    private HoodieTableType tableType = HoodieTableType.COPY_ON_WRITE;

    protected HoodieTableType getTableType() {
        return this.tableType;
    }

    public static List<Arguments> tableTypeMetadataFSVTypeArgs() {
        ArrayList<Arguments> testCases = new ArrayList<Arguments>();
        for (HoodieTableType tableType : HoodieTableType.values()) {
            for (boolean enableMdt : Arrays.asList(true, false)) {
                for (FileSystemViewStorageType viewStorageType : Arrays.asList(FileSystemViewStorageType.MEMORY, FileSystemViewStorageType.SPILLABLE_DISK)) {
                    for (int writerVersion : Arrays.asList(6, 8)) {
                        testCases.add(Arguments.of((Object[])new Object[]{tableType, enableMdt, viewStorageType, writerVersion}));
                    }
                }
            }
        }
        return testCases;
    }

    @ParameterizedTest
    @MethodSource(value={"tableTypeMetadataFSVTypeArgs"})
    public void testFileSystemViewConsistency(HoodieTableType tableType, boolean enableMdt, FileSystemViewStorageType storageType, int writeVersion) throws IOException {
        this.tableType = tableType;
        HoodieWriteConfig.Builder configBuilder = this.getConfigBuilder();
        if (tableType == HoodieTableType.MERGE_ON_READ) {
            configBuilder.withCompactionConfig(HoodieCompactionConfig.newBuilder().withInlineCompaction(Boolean.valueOf(true)).withMaxNumDeltaCommitsBeforeCompaction(3).build());
        }
        configBuilder.withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withStorageType(storageType).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(enableMdt).build()).withClusteringConfig(HoodieClusteringConfig.newBuilder().withInlineClustering(Boolean.valueOf(true)).withInlineClusteringNumCommits(5).build()).withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(4).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(6, 8).build()).withWriteTableVersion(writeVersion);
        HoodieWriteConfig config = configBuilder.build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(config);){
            String commitTime;
            int i;
            this.insertRecords(client, "001", 100, WriteOperationType.BULK_INSERT);
            this.insertRecords(client, "002", 100, WriteOperationType.INSERT);
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            HoodieTableFileSystemView expectedFileSystemView = FileSystemViewManager.createInMemoryFileSystemView((HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient, (HoodieMetadataConfig)HoodieMetadataConfig.newBuilder().enable(false).build());
            FileSystemViewStorageConfig viewStorageConfig = FileSystemViewStorageConfig.newBuilder().fromProperties((Properties)config.getProps()).withStorageType(storageType).build();
            HoodieTableFileSystemView actualFileSystemView = (HoodieTableFileSystemView)FileSystemViewManager.createViewManager((HoodieEngineContext)this.context, (HoodieMetadataConfig)config.getMetadataConfig(), (FileSystemViewStorageConfig)viewStorageConfig, (HoodieCommonConfig)config.getCommonConfig(), (SerializableFunctionUnchecked & Serializable)v1 -> HoodieTableMetadata.create((HoodieEngineContext)this.context, (HoodieStorage)this.metaClient.getStorage(), (HoodieMetadataConfig)config.getMetadataConfig(), (String)config.getBasePath())).getFileSystemView(this.basePath);
            this.assertFileSystemViews(config, enableMdt, storageType);
            for (i = 3; i < 10; ++i) {
                commitTime = String.format("%10d", i);
                this.upsertRecords(client, commitTime, 50);
            }
            expectedFileSystemView.sync();
            actualFileSystemView.sync();
            this.assertForFSVEquality(expectedFileSystemView, actualFileSystemView, enableMdt);
            for (i = 10; i < 20; ++i) {
                commitTime = String.format("%10d", i);
                this.upsertRecords(client, commitTime, 50);
            }
            HoodieInstant lastInstant = (HoodieInstant)this.metaClient.reloadActiveTimeline().lastInstant().get();
            StoragePath instantPath = HoodieTestUtils.getCompleteInstantPath((HoodieStorage)this.metaClient.getStorage(), (StoragePath)this.metaClient.getTimelinePath(), (String)lastInstant.requestedTime(), (String)lastInstant.getAction());
            this.metaClient.getStorage().deleteFile(instantPath);
            expectedFileSystemView.sync();
            actualFileSystemView.sync();
            this.assertForFSVEquality(expectedFileSystemView, actualFileSystemView, enableMdt);
            for (int i2 = 21; i2 < 23; ++i2) {
                String commitTime2 = String.format("%10d", i2);
                this.upsertRecords(client, commitTime2, 50);
            }
            actualFileSystemView.close();
            expectedFileSystemView.close();
        }
        this.assertFileSystemViews(config, enableMdt, storageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertFileSystemViews(HoodieWriteConfig writeConfig, boolean enableMdt, FileSystemViewStorageType baseStorageType) {
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieTableFileSystemView expectedFileSystemView = FileSystemViewManager.createInMemoryFileSystemView((HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient, (HoodieMetadataConfig)HoodieMetadataConfig.newBuilder().enable(false).build());
        FileSystemViewStorageConfig viewStorageConfig = FileSystemViewStorageConfig.newBuilder().fromProperties((Properties)writeConfig.getProps()).withStorageType(baseStorageType).build();
        HoodieTableFileSystemView actualFileSystemView = (HoodieTableFileSystemView)FileSystemViewManager.createViewManager((HoodieEngineContext)this.context, (HoodieMetadataConfig)writeConfig.getMetadataConfig(), (FileSystemViewStorageConfig)viewStorageConfig, (HoodieCommonConfig)writeConfig.getCommonConfig(), (SerializableFunctionUnchecked & Serializable)v1 -> HoodieTableMetadata.create((HoodieEngineContext)this.context, (HoodieStorage)this.metaClient.getStorage(), (HoodieMetadataConfig)writeConfig.getMetadataConfig(), (String)writeConfig.getBasePath())).getFileSystemView(this.basePath);
        try {
            this.assertForFSVEquality(expectedFileSystemView, actualFileSystemView, enableMdt);
        }
        finally {
            expectedFileSystemView.close();
            actualFileSystemView.close();
        }
    }

    private void assertForFSVEquality(HoodieTableFileSystemView fsv1, HoodieTableFileSystemView fsv2, boolean enableMdt) {
        List<String> allPartitionNames = Arrays.asList("2016/03/15", "2015/03/16", "2015/03/17");
        fsv1.loadPartitions(allPartitionNames);
        if (enableMdt) {
            fsv2.loadAllPartitions();
        } else {
            fsv2.loadPartitions(allPartitionNames);
        }
        List allPartitions1 = fsv1.getPartitionPaths();
        List allPartitions2 = fsv2.getPartitionPaths();
        Collections.sort(allPartitions1);
        Collections.sort(allPartitions2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)allPartitions1, (Object)allPartitions2);
        allPartitionNames.forEach(path -> {
            List<HoodieBaseFile> latestBaseFiles1 = fsv1.getLatestBaseFiles(path).collect(Collectors.toList());
            List<HoodieBaseFile> latestBaseFiles2 = fsv2.getLatestBaseFiles(path).collect(Collectors.toList());
            this.assertBaseFileListEquality(latestBaseFiles1, latestBaseFiles2);
            List<FileSlice> fileSlices1 = fsv1.getLatestFileSlices(path).collect(Collectors.toList());
            List<FileSlice> fileSlices2 = fsv2.getLatestFileSlices(path).collect(Collectors.toList());
            this.assertFileSliceListEquality(fileSlices1, fileSlices2);
        });
    }

    private void assertBaseFileListEquality(List<HoodieBaseFile> baseFileList1, List<HoodieBaseFile> baseFileList2) {
        org.junit.jupiter.api.Assertions.assertEquals((int)baseFileList1.size(), (int)baseFileList2.size());
        HashMap fileNameToBaseFileMap1 = new HashMap();
        baseFileList1.forEach(entry -> fileNameToBaseFileMap1.put(entry.getFileName(), entry));
        HashMap fileNameToBaseFileMap2 = new HashMap();
        baseFileList2.forEach(entry -> fileNameToBaseFileMap2.put(entry.getFileName(), entry));
        fileNameToBaseFileMap1.entrySet().forEach(kv -> {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)fileNameToBaseFileMap2.containsKey(kv.getKey()));
            this.assertBaseFileEquality((HoodieBaseFile)kv.getValue(), (HoodieBaseFile)fileNameToBaseFileMap2.get(kv.getKey()));
        });
    }

    public void assertBaseFileEquality(HoodieBaseFile baseFile1, HoodieBaseFile baseFile2) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)baseFile1.getFileName(), (Object)baseFile2.getFileName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)baseFile1.getFileId(), (Object)baseFile2.getFileId());
        org.junit.jupiter.api.Assertions.assertEquals((long)baseFile1.getFileLen(), (long)baseFile2.getFileLen());
        org.junit.jupiter.api.Assertions.assertEquals((long)baseFile1.getFileSize(), (long)baseFile2.getFileSize());
    }

    private void assertFileSliceListEquality(List<FileSlice> fileSlices1, List<FileSlice> fileSlices2) {
        org.junit.jupiter.api.Assertions.assertEquals((int)fileSlices1.size(), (int)fileSlices1.size());
        HashMap fileNameToFileSliceMap1 = new HashMap();
        fileSlices1.forEach(entry -> fileNameToFileSliceMap1.put(Pair.of((Object)entry.getFileId(), (Object)entry.getBaseInstantTime()), entry));
        HashMap fileNameToFileSliceMap2 = new HashMap();
        fileSlices2.forEach(entry -> fileNameToFileSliceMap2.put(Pair.of((Object)entry.getFileId(), (Object)entry.getBaseInstantTime()), entry));
        fileNameToFileSliceMap1.entrySet().forEach(kv -> {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)fileNameToFileSliceMap2.containsKey(kv.getKey()));
            this.assertFileSliceEquality((FileSlice)kv.getValue(), (FileSlice)fileNameToFileSliceMap2.get(kv.getKey()));
        });
    }

    private void assertFileSliceEquality(FileSlice fileSlice1, FileSlice fileSlice2) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)fileSlice1.getBaseFile().isPresent(), (Object)fileSlice2.getBaseFile().isPresent());
        if (fileSlice1.getBaseFile().isPresent()) {
            this.assertBaseFileEquality((HoodieBaseFile)fileSlice1.getBaseFile().get(), (HoodieBaseFile)fileSlice2.getBaseFile().get());
        }
        List logFiles1 = fileSlice1.getLogFiles().collect(Collectors.toList());
        List logFiles2 = fileSlice2.getLogFiles().collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)logFiles1.size(), (int)logFiles2.size());
        int counter = 0;
        for (HoodieLogFile logFile1 : logFiles1) {
            HoodieLogFile logFile2 = (HoodieLogFile)logFiles2.get(counter++);
            this.assertLogFileEquality(logFile1, logFile2);
        }
    }

    private void assertLogFileEquality(HoodieLogFile logFile1, HoodieLogFile logFile2) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)logFile1.getFileName(), (Object)logFile2.getFileName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)logFile1.getFileId(), (Object)logFile2.getFileId());
        org.junit.jupiter.api.Assertions.assertEquals((int)logFile1.getLogVersion(), (int)logFile2.getLogVersion());
        org.junit.jupiter.api.Assertions.assertEquals((long)logFile1.getFileSize(), (long)logFile2.getFileSize());
        org.junit.jupiter.api.Assertions.assertEquals((Object)logFile1.getDeltaCommitTime(), (Object)logFile2.getDeltaCommitTime());
        org.junit.jupiter.api.Assertions.assertEquals((Object)logFile1.getFileExtension(), (Object)logFile2.getFileExtension());
        org.junit.jupiter.api.Assertions.assertEquals((Object)logFile1.getLogWriteToken(), (Object)logFile2.getLogWriteToken());
    }

    private void insertRecords(SparkRDDWriteClient client, String commitTime, int numRecords, WriteOperationType operationType) {
        client.startCommitWithTime(commitTime);
        List inserts1 = this.dataGen.generateInserts(commitTime, Integer.valueOf(numRecords));
        JavaRDD insertRecordsRDD1 = this.jsc.parallelize(inserts1, 2);
        List statuses = operationType == WriteOperationType.BULK_INSERT ? client.bulkInsert(insertRecordsRDD1, commitTime, Option.empty()).collect() : client.insert(insertRecordsRDD1, commitTime).collect();
        Assertions.assertNoWriteErrors((List)statuses);
    }

    private void upsertRecords(SparkRDDWriteClient client, String commitTime, int numRecords) {
        client.startCommitWithTime(commitTime);
        List updates = this.dataGen.generateUniqueUpdates(commitTime, Integer.valueOf(numRecords));
        JavaRDD updatesRdd = this.jsc.parallelize(updates, 2);
        List statuses = client.upsert(updatesRdd, commitTime).collect();
        Assertions.assertNoWriteErrors((List)statuses);
    }
}

