/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.hudi.client.model.HoodieInternalRow;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.unsafe.types.UTF8String;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieInternalRow {
    private static final Random RANDOM = new Random();
    private static final int INTEGER_INDEX = 5;
    private static final int STRING_INDEX = 6;
    private static final int BOOLEAN_INDEX = 7;
    private static final int SHORT_INDEX = 8;
    private static final int BYTE_INDEX = 9;
    private static final int LONG_INDEX = 10;
    private static final int FLOAT_INDEX = 11;
    private static final int DOUBLE_INDEX = 12;
    private static final int DECIMAL_INDEX = 13;
    private static final int BINARY_INDEX = 14;
    private static final int STRUCT_INDEX = 15;
    private static final int ARRAY_INDEX = 16;
    private static final int MAP_INDEX = 17;
    private List<Integer> nullIndices = new ArrayList<Integer>();

    @Test
    public void testGet() {
        Object[] values = this.getRandomValue(true);
        GenericInternalRow row = new GenericInternalRow(values);
        HoodieInternalRow hoodieInternalRow = new HoodieInternalRow(UTF8String.fromString((String)"commitTime"), UTF8String.fromString((String)"commitSeqNo"), UTF8String.fromString((String)"recordKey"), UTF8String.fromString((String)"partitionPath"), UTF8String.fromString((String)"fileName"), (InternalRow)row, true);
        this.assertValues(hoodieInternalRow, "commitTime", "commitSeqNo", "recordKey", "partitionPath", "fileName", values, this.nullIndices);
    }

    @Test
    public void testUpdate() {
        Object[] values = this.getRandomValue(true);
        GenericInternalRow row = new GenericInternalRow(values);
        HoodieInternalRow hoodieInternalRow = new HoodieInternalRow(UTF8String.fromString((String)"commitTime"), UTF8String.fromString((String)"commitSeqNo"), UTF8String.fromString((String)"recordKey"), UTF8String.fromString((String)"partitionPath"), UTF8String.fromString((String)"fileName"), (InternalRow)row, true);
        hoodieInternalRow.update(0, (Object)"commitTime_updated");
        hoodieInternalRow.update(1, (Object)"commitSeqNo_updated");
        hoodieInternalRow.update(2, (Object)"recordKey_updated");
        hoodieInternalRow.update(3, (Object)"partitionPath_updated");
        hoodieInternalRow.update(4, (Object)"fileName_updated");
        values = this.getRandomValue(true);
        hoodieInternalRow.update(5, values[5]);
        hoodieInternalRow.update(7, values[7]);
        hoodieInternalRow.update(8, values[8]);
        hoodieInternalRow.update(9, values[9]);
        hoodieInternalRow.update(10, values[10]);
        hoodieInternalRow.update(11, values[11]);
        hoodieInternalRow.update(12, values[12]);
        hoodieInternalRow.update(14, values[14]);
        hoodieInternalRow.update(15, values[15]);
        hoodieInternalRow.update(6, (Object)values[6].toString());
        this.assertValues(hoodieInternalRow, "commitTime_updated", "commitSeqNo_updated", "recordKey_updated", "partitionPath_updated", "fileName_updated", values, this.nullIndices);
    }

    @Test
    public void testNumFields() {
        Object[] values = this.getRandomValue(true);
        GenericInternalRow row = new GenericInternalRow(values);
        HoodieInternalRow hoodieInternalRow1 = new HoodieInternalRow(UTF8String.fromString((String)"commitTime"), UTF8String.fromString((String)"commitSeqNo"), UTF8String.fromString((String)"recordKey"), UTF8String.fromString((String)"partitionPath"), UTF8String.fromString((String)"fileName"), (InternalRow)row, true);
        HoodieInternalRow hoodieInternalRow2 = new HoodieInternalRow(UTF8String.fromString((String)"commitTime"), UTF8String.fromString((String)"commitSeqNo"), UTF8String.fromString((String)"recordKey"), UTF8String.fromString((String)"partitionPath"), UTF8String.fromString((String)"fileName"), (InternalRow)row, false);
        Assertions.assertEquals((int)row.numFields(), (int)hoodieInternalRow1.numFields());
        Assertions.assertEquals((int)(row.numFields() + 5), (int)hoodieInternalRow2.numFields());
    }

    @Test
    public void testIsNullCheck() {
        int i;
        for (i = 0; i < 16; ++i) {
            Object[] values = this.getRandomValue(true);
            GenericInternalRow row = new GenericInternalRow(values);
            HoodieInternalRow hoodieInternalRow = new HoodieInternalRow(UTF8String.fromString((String)"commitTime"), UTF8String.fromString((String)"commitSeqNo"), UTF8String.fromString((String)"recordKey"), UTF8String.fromString((String)"partitionPath"), UTF8String.fromString((String)"fileName"), (InternalRow)row, true);
            hoodieInternalRow.setNullAt(i);
            this.nullIndices.clear();
            this.nullIndices.add(i);
            this.assertValues(hoodieInternalRow, "commitTime", "commitSeqNo", "recordKey", "partitionPath", "fileName", values, this.nullIndices);
        }
        for (i = 0; i < 5; ++i) {
            int numNullValues = 1 + RANDOM.nextInt(4);
            ArrayList<Integer> nullsSoFar = new ArrayList<Integer>();
            while (nullsSoFar.size() < numNullValues) {
                int randomIndex = RANDOM.nextInt(16);
                if (nullsSoFar.contains(randomIndex)) continue;
                nullsSoFar.add(randomIndex);
            }
            Object[] values = this.getRandomValue(true);
            GenericInternalRow row = new GenericInternalRow(values);
            HoodieInternalRow hoodieInternalRow = new HoodieInternalRow(UTF8String.fromString((String)"commitTime"), UTF8String.fromString((String)"commitSeqNo"), UTF8String.fromString((String)"recordKey"), UTF8String.fromString((String)"partitionPath"), UTF8String.fromString((String)"fileName"), (InternalRow)row, true);
            this.nullIndices.clear();
            for (Integer index : nullsSoFar) {
                hoodieInternalRow.setNullAt(index.intValue());
                this.nullIndices.add(index);
            }
            this.assertValues(hoodieInternalRow, "commitTime", "commitSeqNo", "recordKey", "partitionPath", "fileName", values, this.nullIndices);
        }
    }

    private Object[] getRandomValue(boolean withStructType) {
        Object[] values = new Object[16];
        values[5] = RANDOM.nextInt();
        values[6] = UUID.randomUUID().toString();
        values[7] = RANDOM.nextBoolean();
        values[8] = (short)RANDOM.nextInt(2);
        byte[] bytes = new byte[1];
        RANDOM.nextBytes(bytes);
        values[9] = bytes[0];
        values[10] = RANDOM.nextLong();
        values[11] = Float.valueOf(RANDOM.nextFloat());
        values[12] = RANDOM.nextDouble();
        values[13] = Float.valueOf(RANDOM.nextFloat());
        bytes = new byte[20];
        RANDOM.nextBytes(bytes);
        values[14] = bytes;
        if (withStructType) {
            Object[] structField = this.getRandomValue(false);
            values[15] = new GenericInternalRow(structField);
        }
        return values;
    }

    private void assertValues(HoodieInternalRow hoodieInternalRow, String commitTime, String commitSeqNo, String recordKey, String partitionPath, String filename, Object[] values, List<Integer> nullIndexes) {
        for (Integer index : nullIndexes) {
            Assertions.assertTrue((boolean)hoodieInternalRow.isNullAt(index.intValue()));
        }
        for (int i = 0; i < 16; ++i) {
            if (nullIndexes.contains(i)) continue;
            Assertions.assertFalse((boolean)hoodieInternalRow.isNullAt(i));
        }
        if (!nullIndexes.contains(0)) {
            Assertions.assertEquals((Object)commitTime, (Object)hoodieInternalRow.get(0, DataTypes.StringType).toString());
        }
        if (!nullIndexes.contains(1)) {
            Assertions.assertEquals((Object)commitSeqNo, (Object)hoodieInternalRow.get(1, DataTypes.StringType).toString());
        }
        if (!nullIndexes.contains(2)) {
            Assertions.assertEquals((Object)recordKey, (Object)hoodieInternalRow.get(2, DataTypes.StringType).toString());
        }
        if (!nullIndexes.contains(3)) {
            Assertions.assertEquals((Object)partitionPath, (Object)hoodieInternalRow.get(3, DataTypes.StringType).toString());
        }
        if (!nullIndexes.contains(4)) {
            Assertions.assertEquals((Object)filename, (Object)hoodieInternalRow.get(4, DataTypes.StringType).toString());
        }
        if (!nullIndexes.contains(5)) {
            Assertions.assertEquals((Object)values[5], (Object)hoodieInternalRow.getInt(5));
            Assertions.assertEquals((Object)values[5], (Object)hoodieInternalRow.get(5, DataTypes.IntegerType));
        }
        if (!nullIndexes.contains(6)) {
            Assertions.assertEquals((Object)values[6].toString(), (Object)hoodieInternalRow.get(6, DataTypes.StringType));
        }
        if (!nullIndexes.contains(7)) {
            Assertions.assertEquals((Object)values[7], (Object)hoodieInternalRow.getBoolean(7));
            Assertions.assertEquals((Object)values[7], (Object)hoodieInternalRow.get(7, DataTypes.BooleanType));
        }
        if (!nullIndexes.contains(8)) {
            Assertions.assertEquals((Object)values[8], (Object)hoodieInternalRow.getShort(8));
            Assertions.assertEquals((Object)values[8], (Object)hoodieInternalRow.get(8, DataTypes.ShortType));
        }
        if (!nullIndexes.contains(9)) {
            Assertions.assertEquals((Object)values[9], (Object)hoodieInternalRow.getByte(9));
            Assertions.assertEquals((Object)values[9], (Object)hoodieInternalRow.get(9, DataTypes.ByteType));
        }
        if (!nullIndexes.contains(10)) {
            Assertions.assertEquals((Object)values[10], (Object)hoodieInternalRow.getLong(10));
            Assertions.assertEquals((Object)values[10], (Object)hoodieInternalRow.get(10, DataTypes.LongType));
        }
        if (!nullIndexes.contains(11)) {
            Assertions.assertEquals((Object)values[11], (Object)Float.valueOf(hoodieInternalRow.getFloat(11)));
            Assertions.assertEquals((Object)values[11], (Object)hoodieInternalRow.get(11, DataTypes.FloatType));
        }
        if (!nullIndexes.contains(12)) {
            Assertions.assertEquals((Object)values[12], (Object)hoodieInternalRow.getDouble(12));
            Assertions.assertEquals((Object)values[12], (Object)hoodieInternalRow.get(12, DataTypes.DoubleType));
        }
        if (!nullIndexes.contains(14)) {
            Assertions.assertEquals((Object)values[14], (Object)hoodieInternalRow.getBinary(14));
            Assertions.assertEquals((Object)values[14], (Object)hoodieInternalRow.get(14, DataTypes.BinaryType));
        }
        if (!nullIndexes.contains(15)) {
            Assertions.assertEquals((Object)values[15], (Object)hoodieInternalRow.getStruct(15, 18));
        }
    }
}

