/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.NonSerializableFileSystem;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.hadoop.fs.HoodieSerializableFileStatus;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.apache.spark.SparkException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestHoodieSerializableFileStatus
extends HoodieSparkClientTestHarness {
    HoodieEngineContext engineContext;
    List<Path> testPaths;

    @BeforeAll
    public void setUp() throws IOException {
        this.initSparkContexts();
        this.testPaths = new ArrayList<Path>(5);
        for (int i = 0; i < 5; ++i) {
            this.testPaths.add(new Path("s3://table-bucket/"));
        }
        this.engineContext = new HoodieSparkEngineContext(this.jsc);
    }

    @AfterAll
    public void tearDown() {
        this.cleanupSparkContexts();
    }

    @Test
    public void testNonSerializableFileStatus() {
        Exception e = (Exception)Assertions.assertThrows(SparkException.class, () -> {
            List statuses = this.engineContext.flatMap(this.testPaths, (SerializableFunction & Serializable)path -> {
                NonSerializableFileSystem fileSystem = new NonSerializableFileSystem();
                return Arrays.stream(fileSystem.listStatus((Path)path));
            }, 5);
        }, (String)"Serialization is supposed to fail!");
        Assertions.assertTrue((boolean)e.getMessage().contains("com.esotericsoftware.kryo.KryoException: java.util.ConcurrentModificationException"));
    }

    @Test
    public void testHoodieFileStatusSerialization() {
        List statuses = this.engineContext.flatMap(this.testPaths, (SerializableFunction & Serializable)path -> {
            NonSerializableFileSystem fileSystem = new NonSerializableFileSystem();
            return Arrays.stream(HoodieSerializableFileStatus.fromFileStatuses((FileStatus[])fileSystem.listStatus((Path)path)));
        }, 5);
    }
}

