/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.data.HoodieJavaPairRDD;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFunction;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Tuple2;

public class TestHoodieJavaPairRDD {
    private static JavaSparkContext jsc;

    @BeforeEach
    public void setUp() {
        SparkConf conf = new SparkConf().setAppName("HoodieJavaPairRDDJoinTest").setMaster("local[2]");
        jsc = new JavaSparkContext(conf);
    }

    @AfterEach
    public void tearDown() {
        if (jsc != null) {
            jsc.stop();
        }
    }

    @Test
    public void testJoinOperation() {
        JavaPairRDD partitionRecordKeyPairRDD = jsc.parallelize(Arrays.asList(new Tuple2((Object)"2017/10/22", (Object)"003"), new Tuple2((Object)"2017/10/22", (Object)"002"), new Tuple2((Object)"2017/10/22", (Object)"005"), new Tuple2((Object)"2017/10/22", (Object)"004"))).mapToPair((PairFunction & Serializable)t -> t);
        JavaPairRDD otherPairRDD = jsc.parallelize(Arrays.asList(new Tuple2((Object)"2017/10/22", (Object)"value1"), new Tuple2((Object)"2017/10/22", (Object)"value2"))).mapToPair((PairFunction & Serializable)t -> t);
        HoodieJavaPairRDD hoodiePairData = HoodieJavaPairRDD.of((JavaPairRDD)partitionRecordKeyPairRDD);
        HoodieJavaPairRDD otherHoodiePairData = HoodieJavaPairRDD.of((JavaPairRDD)otherPairRDD);
        HoodiePairData result = hoodiePairData.join((HoodiePairData)otherHoodiePairData);
        List resultList = result.collectAsList();
        Assertions.assertEquals((int)8, (int)resultList.size());
        resultList.forEach(item -> {
            Assertions.assertEquals((Object)"2017/10/22", (Object)item.getLeft());
            Assertions.assertTrue((boolean)Arrays.asList("003", "002", "005", "004").contains(((Pair)item.getRight()).getLeft()));
            Assertions.assertTrue((boolean)Arrays.asList("value1", "value2").contains(((Pair)item.getRight()).getRight()));
        });
    }

    @Test
    public void testLeftOuterJoinOperation() {
        JavaPairRDD partitionRecordKeyPairRDD = jsc.parallelize(Arrays.asList(new Tuple2((Object)"2017/10/22", (Object)"003"), new Tuple2((Object)"2017/10/22", (Object)"002"), new Tuple2((Object)"2017/10/22", (Object)"005"), new Tuple2((Object)"2017/10/22", (Object)"004"))).mapToPair((PairFunction & Serializable)t -> t);
        JavaPairRDD otherPairRDD = jsc.parallelize(Arrays.asList(new Tuple2((Object)"2017/10/22", (Object)"value1"))).mapToPair((PairFunction & Serializable)t -> t);
        HoodieJavaPairRDD hoodiePairData = HoodieJavaPairRDD.of((JavaPairRDD)partitionRecordKeyPairRDD);
        HoodieJavaPairRDD otherHoodiePairData = HoodieJavaPairRDD.of((JavaPairRDD)otherPairRDD);
        HoodiePairData result = hoodiePairData.leftOuterJoin((HoodiePairData)otherHoodiePairData);
        List resultList = result.collectAsList();
        Assertions.assertEquals((int)4, (int)resultList.size());
        resultList.forEach(item -> {
            Assertions.assertEquals((Object)"2017/10/22", (Object)item.getLeft());
            Assertions.assertTrue((boolean)Arrays.asList("003", "002", "005", "004").contains(((Pair)item.getRight()).getLeft()));
            Assertions.assertEquals((Object)Option.of((Object)"value1"), (Object)((Pair)item.getRight()).getRight());
        });
    }
}

