/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.util.Arrays;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.functional.TestHoodieMetadataBase;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.bloom.BaseHoodieBloomIndexHelper;
import org.apache.hudi.index.bloom.HoodieBloomIndex;
import org.apache.hudi.index.bloom.SparkHoodieBloomIndexHelper;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBloomIndexTagWithColStats
extends TestHoodieMetadataBase {
    private static final Schema SCHEMA = SchemaTestUtil.getSchemaFromResource(TestBloomIndexTagWithColStats.class, (String)"/exampleSchema.avsc", (boolean)true);

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanupResources();
    }

    private void init(Properties props) throws Exception {
        this.initSparkContexts();
        this.initPath();
        this.initHoodieStorage();
        this.initMetaClient(props);
        this.writeClient = this.getHoodieWriteClient(this.makeConfig());
    }

    private HoodieWriteConfig makeConfig() {
        return HoodieWriteConfig.newBuilder().withPath(this.basePath).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).bloomIndexPruneByRanges(true).bloomIndexTreebasedFilter(true).bloomIndexBucketizedChecking(true).bloomIndexKeysPerBucket(2).bloomIndexUseMetadata(true).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMetadataIndexBloomFilter(true).withMetadataIndexColumnStats(true).build()).withSchema(SCHEMA.toString()).build();
    }

    @Test
    public void testSimpleKeyGenerator() throws Exception {
        Properties props = new Properties();
        props.setProperty("hoodie.table.recordkey.fields", "_row_key");
        this.init(props);
        TypedProperties keyGenProperties = new TypedProperties();
        keyGenProperties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key");
        keyGenProperties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"time");
        SimpleKeyGenerator keyGenerator = new SimpleKeyGenerator(keyGenProperties);
        this.testTagLocationOnPartitionedTable((KeyGenerator)keyGenerator);
    }

    @Test
    public void testComplexGeneratorWithMultiKeysSinglePartitionField() throws Exception {
        Properties props = new Properties();
        props.setProperty("hoodie.table.recordkey.fields", "_row_key,number");
        this.init(props);
        TypedProperties keyGenProperties = new TypedProperties();
        keyGenProperties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key,number");
        keyGenProperties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"time");
        ComplexKeyGenerator keyGenerator = new ComplexKeyGenerator(keyGenProperties);
        this.testTagLocationOnPartitionedTable((KeyGenerator)keyGenerator);
    }

    @Test
    public void testComplexGeneratorWithSingleKeyMultiPartitionFields() throws Exception {
        Properties props = new Properties();
        props.setProperty("hoodie.table.recordkey.fields", "_row_key");
        this.init(props);
        TypedProperties keyGenProperties = new TypedProperties();
        keyGenProperties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key");
        keyGenProperties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"time,number");
        ComplexKeyGenerator keyGenerator = new ComplexKeyGenerator(keyGenProperties);
        this.testTagLocationOnPartitionedTable((KeyGenerator)keyGenerator);
    }

    private void testTagLocationOnPartitionedTable(KeyGenerator keyGenerator) throws Exception {
        GenericRecord genericRecord = this.generateGenericRecord("1", "2020", 1);
        HoodieAvroRecord record = new HoodieAvroRecord(keyGenerator.getKey(genericRecord), (HoodieRecordPayload)new HoodieAvroPayload(Option.of((Object)genericRecord)));
        JavaRDD recordRDD = this.jsc.parallelize(Arrays.asList(record));
        HoodieWriteConfig config = this.makeConfig();
        HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieBloomIndex bloomIndex = new HoodieBloomIndex(config, (BaseHoodieBloomIndexHelper)SparkHoodieBloomIndexHelper.getInstance());
        JavaRDD<HoodieRecord> taggedRecordRDD = this.tagLocation((HoodieIndex)bloomIndex, (JavaRDD<HoodieRecord>)recordRDD, (HoodieTable)hoodieTable);
        Assertions.assertFalse((boolean)((HoodieRecord)taggedRecordRDD.first()).isCurrentLocationKnown());
        this.writeClient.startCommitWithTime("001");
        JavaRDD status = this.writeClient.upsert(taggedRecordRDD, "001");
        String fileId = ((WriteStatus)status.first()).getFileId();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        taggedRecordRDD = this.tagLocation((HoodieIndex)bloomIndex, (JavaRDD<HoodieRecord>)recordRDD, (HoodieTable)HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient));
        Assertions.assertEquals((Object)((HoodieRecord)taggedRecordRDD.first()).getCurrentLocation().getFileId(), (Object)fileId);
    }

    private GenericRecord generateGenericRecord(String rowKey, String time, int number) {
        GenericData.Record rec = new GenericData.Record(SCHEMA);
        rec.put("_row_key", (Object)rowKey);
        rec.put("time", (Object)time);
        rec.put("number", (Object)number);
        return rec;
    }
}

