/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.nio.file.Path;
import org.apache.hudi.client.SparkTaskContextSupplier;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestSparkIOUtils {
    @TempDir
    public Path basePath;
    private final SparkTaskContextSupplier contextSupplier = new SparkTaskContextSupplier();

    @Test
    public void testMaxMemoryPerPartitionMergeWithMaxSizeDefined() {
        String path = this.basePath.toString();
        long mergeMaxSize = 1000L;
        long compactionMaxSize = 1000L;
        HoodieMemoryConfig memoryConfig = HoodieMemoryConfig.newBuilder().withMaxMemoryMaxSize(mergeMaxSize, compactionMaxSize).build();
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(path).withMemoryConfig(memoryConfig).build();
        Assertions.assertEquals((long)mergeMaxSize, (long)IOUtils.getMaxMemoryPerPartitionMerge((TaskContextSupplier)this.contextSupplier, (HoodieConfig)config));
        Assertions.assertEquals((long)compactionMaxSize, (long)IOUtils.getMaxMemoryPerCompaction((TaskContextSupplier)this.contextSupplier, (HoodieConfig)config));
    }

    @Test
    public void testMaxMemoryPerPartitionMergeInDefault() {
        String path = this.basePath.toString();
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(path).build();
        String compactionFraction = config.getProps().getProperty(HoodieMemoryConfig.MAX_MEMORY_FRACTION_FOR_COMPACTION.key(), (String)HoodieMemoryConfig.MAX_MEMORY_FRACTION_FOR_COMPACTION.defaultValue());
        long compactionMaxSize = IOUtils.getMaxMemoryAllowedForMerge((TaskContextSupplier)this.contextSupplier, (String)compactionFraction);
        String mergeFraction = config.getProps().getProperty(HoodieMemoryConfig.MAX_MEMORY_FRACTION_FOR_MERGE.key(), (String)HoodieMemoryConfig.MAX_MEMORY_FRACTION_FOR_MERGE.defaultValue());
        long mergeMaxSize = IOUtils.getMaxMemoryAllowedForMerge((TaskContextSupplier)this.contextSupplier, (String)mergeFraction);
        Assertions.assertEquals((long)mergeMaxSize, (long)IOUtils.getMaxMemoryPerPartitionMerge((TaskContextSupplier)this.contextSupplier, (HoodieConfig)config));
        Assertions.assertEquals((long)compactionMaxSize, (long)IOUtils.getMaxMemoryPerCompaction((TaskContextSupplier)this.contextSupplier, (HoodieConfig)config));
    }
}

