/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHoodieSparkTable
extends HoodieCommonTestHarness {
    private static final StorageConfiguration<?> CONF = HoodieTestUtils.getDefaultStorageConf();

    @ParameterizedTest
    @EnumSource(value=DeleteFailureType.class)
    public void testDeleteFailureDuringMarkerReconciliation(DeleteFailureType failureType) throws IOException {
        this.initPath();
        HoodieStorage localStorage = HoodieStorageUtils.getStorage((String)this.basePath, CONF);
        WriteMarkers writeMarkers = (WriteMarkers)Mockito.mock(WriteMarkers.class);
        String partitionPath = "p1";
        List<String> datafiles = Arrays.asList("file1", "file2", "file3");
        ArrayList writeStatList = new ArrayList();
        HashSet markerList = new HashSet();
        datafiles.forEach(fileName -> {
            HoodieWriteStat writeStat = new HoodieWriteStat();
            writeStat.setPath(partitionPath + "/" + fileName);
            writeStatList.add(writeStat);
            markerList.add(partitionPath + "/" + fileName);
        });
        List<String> additionalFiles = Arrays.asList("file4", "file5");
        additionalFiles.forEach(fileName -> markerList.add(partitionPath + "/" + fileName));
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).withMarkersType(MarkerType.DIRECT.name()).build();
        Mockito.when((Object)writeMarkers.doesMarkerDirExist()).thenReturn((Object)true);
        Mockito.when((Object)writeMarkers.createdAndMergedDataPaths(this.getEngineContext(), writeConfig.getFinalizeWriteParallelism())).thenReturn(markerList);
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)metaClient.getBasePath()).thenReturn((Object)new StoragePath(this.basePath));
        Mockito.when((Object)metaClient.getTableType()).thenReturn((Object)HoodieTableType.COPY_ON_WRITE);
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        Mockito.when((Object)metaClient.getStorage()).thenReturn((Object)storage);
        additionalFiles.forEach(fileName -> {
            try {
                StoragePath storagePath = new StoragePath(this.basePath + "/" + partitionPath + "/" + fileName);
                if (failureType == DeleteFailureType.TRUE_ON_DELETE) {
                    Mockito.when((Object)storage.deleteFile(storagePath)).thenReturn((Object)true);
                } else if (failureType == DeleteFailureType.FALSE_ON_DELETE_IS_EXISTS_FALSE) {
                    Mockito.when((Object)storage.deleteFile(storagePath)).thenReturn((Object)false);
                    Mockito.when((Object)storage.exists(storagePath)).thenReturn((Object)false);
                } else if (failureType == DeleteFailureType.FALSE_ON_DELETE_IS_EXISTS_TRUE) {
                    Mockito.when((Object)storage.deleteFile(storagePath)).thenReturn((Object)false);
                    Mockito.when((Object)storage.exists(storagePath)).thenReturn((Object)true);
                } else if (failureType == DeleteFailureType.FILE_NOT_FOUND_EXC_ON_DELETE) {
                    Mockito.when((Object)storage.deleteFile(storagePath)).thenThrow(new Throwable[]{new FileNotFoundException("throwing file not found exception")});
                } else {
                    Mockito.when((Object)storage.deleteFile(storagePath)).thenThrow(new Throwable[]{new RuntimeException("throwing run time exception")});
                }
                localStorage.create(storagePath);
            }
            catch (IOException e) {
                throw new HoodieException("Failed to check data file existance " + fileName);
            }
        });
        HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.getEngineContext(), (HoodieTableMetaClient)metaClient);
        if (failureType == DeleteFailureType.RUNTIME_EXC_ON_DELETE || failureType == DeleteFailureType.FALSE_ON_DELETE_IS_EXISTS_TRUE) {
            Assertions.assertThrows(HoodieException.class, () -> this.lambda$testDeleteFailureDuringMarkerReconciliation$3((HoodieTable)hoodieTable, writeStatList, writeMarkers));
        } else {
            hoodieTable.reconcileAgainstMarkers(this.getEngineContext(), "0001", writeStatList, false, false, writeMarkers);
            additionalFiles.forEach(fileName -> {
                try {
                    ((HoodieStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)1))).deleteFile(new StoragePath(this.basePath + "/" + partitionPath + "/" + fileName));
                }
                catch (IOException e) {
                    throw new HoodieException("Failed to validate that file exists " + fileName);
                }
            });
        }
    }

    private /* synthetic */ void lambda$testDeleteFailureDuringMarkerReconciliation$3(HoodieTable hoodieTable, List writeStatList, WriteMarkers writeMarkers) throws Throwable {
        hoodieTable.reconcileAgainstMarkers(this.getEngineContext(), "0001", writeStatList, false, false, writeMarkers);
    }

    static enum DeleteFailureType {
        TRUE_ON_DELETE,
        FALSE_ON_DELETE_IS_EXISTS_FALSE,
        FALSE_ON_DELETE_IS_EXISTS_TRUE,
        FILE_NOT_FOUND_EXC_ON_DELETE,
        RUNTIME_EXC_ON_DELETE;

    }
}

