/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster;

import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieSliceInfo;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.TableServiceType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.cluster.ClusteringPlanActionExecutor;
import org.apache.hudi.table.action.cluster.ClusteringPlanPartitionFilterMode;
import org.apache.hudi.table.action.cluster.ClusteringTestUtils;
import org.apache.hudi.table.action.cluster.strategy.ClusteringPlanStrategy;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class TestIncrementalClustering
extends SparkClientFunctionalTestHarness {
    private static final String TODAY;
    private static final String YESTERDAY;
    private static final String TOMORROW;

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPartitionsForIncrClusteringWithMaxGroupLimit(boolean enableIncrTableService) throws Exception {
        int maxClusteringGroup = 1;
        HoodieWriteConfig writeConfig = this.buildWriteConfig(enableIncrTableService, new Properties(), maxClusteringGroup);
        HoodieTableMetaClient metaClient = this.getHoodieMetaClient(HoodieTableType.COPY_ON_WRITE);
        String[] partitions = new String[]{YESTERDAY, TODAY};
        this.prepareBasicData(writeConfig, partitions);
        this.prepareBasicData(writeConfig, partitions);
        String clusteringInstantTime = this.doClustering(writeConfig);
        HoodieClusteringPlan clusteringPlan = ClusteringTestUtils.getClusteringPlan(metaClient, clusteringInstantTime);
        if (enableIncrTableService) {
            Assertions.assertEquals((int)2, (int)clusteringPlan.getMissingSchedulePartitions().size());
            Assertions.assertTrue((boolean)clusteringPlan.getMissingSchedulePartitions().contains(YESTERDAY));
            Assertions.assertTrue((boolean)clusteringPlan.getMissingSchedulePartitions().contains(TODAY));
            String[] partitions2 = new String[]{TOMORROW};
            this.prepareBasicData(this.buildWriteConfig(true, new Properties(), maxClusteringGroup), partitions2);
            HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context());
            ClusteringPlanActionExecutor executor = new ClusteringPlanActionExecutor((HoodieEngineContext)this.context(), writeConfig, (HoodieTable)table, "9999999", Option.empty());
            List incrementalPartitions = executor.getPartitions(ReflectionUtils.loadClass((String)ClusteringPlanStrategy.checkAndGetClusteringPlanStrategy((HoodieWriteConfig)writeConfig), (Class[])new Class[]{HoodieTable.class, HoodieEngineContext.class, HoodieWriteConfig.class}, (Object[])new Object[]{table, this.context(), writeConfig}), TableServiceType.CLUSTER);
            Assertions.assertEquals((int)3, (int)incrementalPartitions.size());
        } else {
            Assertions.assertNull((Object)clusteringPlan.getMissingSchedulePartitions());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"testIncrClusteringWithFilter"})
    public void testPartitionsForIncrClusteringWithFilter(ClusteringPlanPartitionFilterMode mode, Properties props) throws Exception {
        HoodieWriteConfig writeConfig = this.buildWriteConfig(true, props, 100);
        HoodieTableMetaClient metaClient = this.getHoodieMetaClient(HoodieTableType.COPY_ON_WRITE);
        String[] partitions = new String[]{YESTERDAY, TODAY};
        this.prepareBasicData(writeConfig, partitions);
        String clusteringInstantTime = this.doClustering(writeConfig);
        HoodieClusteringPlan clusteringPlan = ClusteringTestUtils.getClusteringPlan(metaClient, clusteringInstantTime);
        switch (mode) {
            case NONE: {
                Assertions.assertEquals((int)0, (int)clusteringPlan.getMissingSchedulePartitions().size());
                break;
            }
            case SELECTED_PARTITIONS: {
                Set<String> affectedPartitions = this.getAffectedPartition(clusteringPlan);
                Assertions.assertEquals((int)1, (int)affectedPartitions.size());
                Assertions.assertTrue((boolean)affectedPartitions.contains(YESTERDAY));
                Assertions.assertEquals((int)0, (int)clusteringPlan.getMissingSchedulePartitions().size());
                break;
            }
            case RECENT_DAYS: {
                Assertions.assertEquals((int)1, (int)clusteringPlan.getMissingSchedulePartitions().size());
                Assertions.assertTrue((boolean)clusteringPlan.getMissingSchedulePartitions().contains(TODAY));
                String[] partitions2 = new String[]{TOMORROW};
                HoodieWriteConfig hoodieWriteConfig2 = this.buildWriteConfig(true, props, 100);
                this.prepareBasicData(hoodieWriteConfig2, partitions2);
                String clusteringInstantTime2 = this.doClustering(hoodieWriteConfig2);
                HoodieClusteringPlan clusteringPlan2 = ClusteringTestUtils.getClusteringPlan(metaClient, clusteringInstantTime2);
                Assertions.assertEquals((int)1, (int)clusteringPlan2.getMissingSchedulePartitions().size());
                Assertions.assertTrue((boolean)clusteringPlan2.getMissingSchedulePartitions().contains(TOMORROW));
                break;
            }
            default: {
                throw new HoodieException("Un-support mode" + mode);
            }
        }
    }

    private Set<String> getAffectedPartition(HoodieClusteringPlan clusteringPlan) {
        return clusteringPlan.getInputGroups().stream().flatMap(hoodieClusteringGroup -> hoodieClusteringGroup.getSlices().stream()).map(HoodieSliceInfo::getPartitionPath).collect(Collectors.toSet());
    }

    public static Stream<Object> testIncrClusteringWithFilter() {
        Properties none = new Properties();
        none.put("hoodie.clustering.plan.partition.filter.mode", ClusteringPlanPartitionFilterMode.NONE);
        none.put("hoodie.clustering.plan.strategy.partition.regex.pattern", TODAY + ".*");
        Properties selectedPartitions = new Properties();
        selectedPartitions.put("hoodie.clustering.plan.partition.filter.mode", ClusteringPlanPartitionFilterMode.SELECTED_PARTITIONS.name());
        selectedPartitions.put(HoodieClusteringConfig.PARTITION_FILTER_BEGIN_PARTITION.key(), YESTERDAY);
        selectedPartitions.put(HoodieClusteringConfig.PARTITION_FILTER_END_PARTITION.key(), YESTERDAY);
        Properties recentDay = new Properties();
        recentDay.put("hoodie.clustering.plan.partition.filter.mode", ClusteringPlanPartitionFilterMode.RECENT_DAYS);
        recentDay.put(HoodieClusteringConfig.PLAN_STRATEGY_SKIP_PARTITIONS_FROM_LATEST.key(), (Object)1);
        recentDay.put(HoodieClusteringConfig.DAYBASED_LOOKBACK_PARTITIONS.key(), (Object)1);
        return Stream.of(Arguments.of((Object[])new Object[]{ClusteringPlanPartitionFilterMode.NONE, none}), Arguments.of((Object[])new Object[]{ClusteringPlanPartitionFilterMode.SELECTED_PARTITIONS, selectedPartitions}), Arguments.of((Object[])new Object[]{ClusteringPlanPartitionFilterMode.RECENT_DAYS, recentDay}));
    }

    private HoodieWriteConfig buildWriteConfig(boolean enableIncrTableService, Properties properties, int maxClusteringGroup) {
        properties.put("hoodie.datasource.write.row.writer.enable", String.valueOf(false));
        properties.put("hoodie.parquet.small.file.limit", String.valueOf(-1));
        return this.getConfigBuilder(true).withIncrementalTableServiceEnabled(enableIncrTableService).withClusteringConfig(HoodieClusteringConfig.newBuilder().withClusteringMaxNumGroups(maxClusteringGroup).withClusteringMaxBytesInGroup((long)maxClusteringGroup).fromProperties(properties).build()).withProperties(properties).build();
    }

    private void prepareBasicData(HoodieWriteConfig writeConfig, String[] partitions) throws IOException {
        SparkRDDWriteClient client = this.getHoodieWriteClient(writeConfig);
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(partitions);
        for (int i = 0; i < partitions.length; ++i) {
            String instantTime = client.createNewInstantTime();
            client.startCommitWithTime(instantTime);
            client.insert(this.jsc().parallelize(dataGen.generateInsertsForPartition(instantTime, Integer.valueOf(10), partitions[i]), 1), instantTime);
        }
        client.close();
    }

    private String doClustering(HoodieWriteConfig writeConfig) throws IOException {
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(writeConfig);){
            String string = ClusteringTestUtils.runClustering(client, false, true);
            return string;
        }
    }

    static {
        LocalDate today = LocalDate.now();
        LocalDate yesterday = today.minusDays(1L);
        LocalDate tomorrow = today.plusDays(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        TODAY = today.format(formatter);
        YESTERDAY = yesterday.format(formatter);
        TOMORROW = tomorrow.format(formatter);
    }
}

