/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.client.HoodieWriteResult;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.Assertions;

public class HoodieClientRollbackTestBase
extends HoodieClientTestBase {
    protected void twoUpsertCommitDataWithTwoPartitions(List<FileSlice> firstPartitionCommit2FileSlices, List<FileSlice> secondPartitionCommit2FileSlices, HoodieWriteConfig cfg, boolean commitSecondUpsert) throws IOException {
        this.dataGen = new HoodieTestDataGenerator(new String[]{"2016/03/15", "2015/03/16"});
        HoodieTestDataGenerator.writePartitionMetadataDeprecated((HoodieStorage)this.storage, (String[])new String[]{"2016/03/15", "2015/03/16"}, (String)this.basePath);
        SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);
        String newCommitTime = "001";
        client.startCommitWithTime(newCommitTime);
        List records = this.dataGen.generateInsertsContainsAllPartitions(newCommitTime, Integer.valueOf(2));
        JavaRDD writeRecords = this.jsc.parallelize(records, 1);
        JavaRDD statuses = client.upsert(writeRecords, newCommitTime);
        org.apache.hudi.testutils.Assertions.assertNoWriteErrors((List)statuses.collect());
        client.commit(newCommitTime, (Object)statuses);
        newCommitTime = "002";
        client.startCommitWithTime(newCommitTime);
        records = this.dataGen.generateUpdates(newCommitTime, records);
        statuses = client.upsert(this.jsc.parallelize(records, 1), newCommitTime);
        org.apache.hudi.testutils.Assertions.assertNoWriteErrors((List)statuses.collect());
        if (commitSecondUpsert) {
            client.commit(newCommitTime, (Object)statuses);
        }
        HoodieSparkTable table = this.getHoodieTable(this.metaClient, cfg);
        SyncableFileSystemView fsView = this.getFileSystemViewWithUnCommittedSlices(table.getMetaClient());
        List firstPartitionCommit2FileGroups = fsView.getAllFileGroups("2016/03/15").collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)firstPartitionCommit2FileGroups.size());
        firstPartitionCommit2FileSlices.addAll(((HoodieFileGroup)firstPartitionCommit2FileGroups.get(0)).getAllFileSlices().collect(Collectors.toList()));
        List secondPartitionCommit2FileGroups = fsView.getAllFileGroups("2015/03/16").collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)secondPartitionCommit2FileGroups.size());
        secondPartitionCommit2FileSlices.addAll(((HoodieFileGroup)secondPartitionCommit2FileGroups.get(0)).getAllFileSlices().collect(Collectors.toList()));
        HoodieTableType tableType = this.getTableType();
        if (tableType.equals((Object)HoodieTableType.COPY_ON_WRITE)) {
            Assertions.assertEquals((int)2, (int)firstPartitionCommit2FileSlices.size());
            Assertions.assertEquals((int)2, (int)secondPartitionCommit2FileSlices.size());
        } else {
            Assertions.assertEquals((int)1, (int)firstPartitionCommit2FileSlices.size());
            Assertions.assertEquals((int)1, (int)secondPartitionCommit2FileSlices.size());
        }
    }

    protected void insertOverwriteCommitDataWithTwoPartitions(List<FileSlice> firstPartitionCommit2FileSlices, List<FileSlice> secondPartitionCommit2FileSlices, HoodieWriteConfig cfg, boolean commitSecondInsertOverwrite) throws IOException {
        this.dataGen = new HoodieTestDataGenerator(new String[]{"2016/03/15", "2015/03/16"});
        HoodieTestDataGenerator.writePartitionMetadataDeprecated((HoodieStorage)this.storage, (String[])new String[]{"2016/03/15", "2015/03/16"}, (String)this.basePath);
        SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);
        String newCommitTime = "001";
        List records = this.dataGen.generateInsertsContainsAllPartitions(newCommitTime, Integer.valueOf(2));
        JavaRDD writeRecords = this.jsc.parallelize(records, 1);
        client.startCommitWithTime(newCommitTime);
        JavaRDD statuses = client.upsert(writeRecords, newCommitTime);
        org.apache.hudi.testutils.Assertions.assertNoWriteErrors((List)statuses.collect());
        client.commit(newCommitTime, (Object)statuses);
        HoodieSparkTable table = this.getHoodieTable(this.metaClient, cfg);
        SyncableFileSystemView fsView = this.getFileSystemViewWithUnCommittedSlices(table.getMetaClient());
        List firstPartitionCommit1FileGroups = fsView.getAllFileGroups("2016/03/15").collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)firstPartitionCommit1FileGroups.size());
        Set partition1Commit1FileIds = ((HoodieFileGroup)firstPartitionCommit1FileGroups.get(0)).getAllFileSlices().map(FileSlice::getFileId).collect(Collectors.toSet());
        List secondPartitionCommit1FileGroups = fsView.getAllFileGroups("2015/03/16").collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)secondPartitionCommit1FileGroups.size());
        Set partition2Commit1FileIds = ((HoodieFileGroup)secondPartitionCommit1FileGroups.get(0)).getAllFileSlices().map(FileSlice::getFileId).collect(Collectors.toSet());
        String commitActionType = "replacecommit";
        newCommitTime = "002";
        records = this.dataGen.generateInsertsContainsAllPartitions(newCommitTime, Integer.valueOf(2));
        writeRecords = this.jsc.parallelize(records, 1);
        client.startCommitWithTime(newCommitTime, commitActionType);
        HoodieWriteResult result = client.insertOverwrite(writeRecords, newCommitTime);
        statuses = result.getWriteStatuses();
        org.apache.hudi.testutils.Assertions.assertNoWriteErrors((List)statuses.collect());
        if (commitSecondInsertOverwrite) {
            client.commit(newCommitTime, (Object)statuses, Option.empty(), commitActionType, result.getPartitionToReplaceFileIds());
        }
        this.metaClient.reloadActiveTimeline();
        fsView = this.getFileSystemViewWithUnCommittedSlices(this.metaClient);
        List firstPartitionCommit2FileGroups = fsView.getAllFileGroups("2016/03/15").filter(fg -> !partition1Commit1FileIds.contains(fg.getFileGroupId().getFileId())).collect(Collectors.toList());
        firstPartitionCommit2FileSlices.addAll(((HoodieFileGroup)firstPartitionCommit2FileGroups.get(0)).getAllFileSlices().collect(Collectors.toList()));
        List secondPartitionCommit2FileGroups = fsView.getAllFileGroups("2015/03/16").filter(fg -> !partition2Commit1FileIds.contains(fg.getFileGroupId().getFileId())).collect(Collectors.toList());
        secondPartitionCommit2FileSlices.addAll(((HoodieFileGroup)secondPartitionCommit2FileGroups.get(0)).getAllFileSlices().collect(Collectors.toList()));
        Assertions.assertEquals((int)1, (int)firstPartitionCommit2FileSlices.size());
        Assertions.assertEquals((int)1, (int)secondPartitionCommit2FileSlices.size());
    }
}

