/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.functional;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.common.HoodieCleanStat;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.BootstrapFileMapping;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.testutils.HoodieMetadataTestTable;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.testutils.HoodieCleanerTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestCleanPlanExecutor
extends HoodieCleanerTestBase {
    @Test
    public void testInvalidCleaningTriggerStrategy() {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(false).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withIncrementalCleaningMode(Boolean.valueOf(true)).withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.EAGER).withCleanBootstrapBaseFileEnabled(Boolean.valueOf(true)).withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(2).withCleaningTriggerStrategy("invalid_strategy").build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(false).build()).build();
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.runCleaner(config, true), (String)"should fail when invalid trigger strategy is provided!");
        Assertions.assertTrue((boolean)e.getMessage().contains("No enum constant org.apache.hudi.table.action.clean.CleaningTriggerStrategy.invalid_strategy"));
    }

    private static Stream<Arguments> argumentsForTestKeepLatestCommits() {
        return Stream.of(Arguments.of((Object[])new Object[]{false, false, false, false}), Arguments.of((Object[])new Object[]{true, false, false, false}), Arguments.of((Object[])new Object[]{true, true, false, false}), Arguments.of((Object[])new Object[]{false, false, true, false}), Arguments.of((Object[])new Object[]{false, false, false, true}));
    }

    @ParameterizedTest
    @MethodSource(value={"argumentsForTestKeepLatestCommits"})
    public void testKeepLatestCommits(boolean simulateFailureRetry, boolean simulateMetadataFailure, boolean enableIncrementalClean, boolean enableBootstrapSourceClean) throws Exception {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withMetadataConfig(HoodieMetadataConfig.newBuilder().build()).withCleanConfig(HoodieCleanConfig.newBuilder().withIncrementalCleaningMode(Boolean.valueOf(enableIncrementalClean)).withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.EAGER).withCleanBootstrapBaseFileEnabled(Boolean.valueOf(enableBootstrapSourceClean)).withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(2).withMaxCommitsBeforeCleaning(2).build()).build();
        HoodieTestTable testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)this.getMetadataWriter(config), (Option)Option.of((Object)this.context));
        final String p0 = "2020/01/01";
        final String p1 = "2020/01/02";
        Map<String, List<BootstrapFileMapping>> bootstrapMapping = enableBootstrapSourceClean ? this.generateBootstrapIndexAndSourceData(p0, p1) : null;
        final String file1P0C0 = enableBootstrapSourceClean ? ((BootstrapFileMapping)((List)bootstrapMapping.get(p0)).get(0)).getFileId() : UUID.randomUUID().toString();
        final String file1P1C0 = enableBootstrapSourceClean ? bootstrapMapping.get(p1).get(0).getFileId() : UUID.randomUUID().toString();
        Map<String, List<String>> part1ToFileId = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
            {
                this.put(p0, CollectionUtils.createImmutableList((Object[])new String[]{file1P0C0}));
                this.put(p1, CollectionUtils.createImmutableList((Object[])new String[]{file1P1C0}));
            }
        });
        this.commitWithMdt("00000000000001", part1ToFileId, testTable, config, true, true);
        testTable = this.tearDownTestTableAndReinit(testTable, config);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        List<HoodieCleanStat> hoodieCleanStatsOne = this.runCleaner(config, simulateFailureRetry, simulateMetadataFailure, 2, true);
        Assertions.assertEquals((int)0, (int)hoodieCleanStatsOne.size(), (String)"Must not scan any partitions and clean any files");
        Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000001", file1P0C0));
        Assertions.assertTrue((boolean)testTable.baseFileExists(p1, "00000000000001", file1P1C0));
        Map partitionAndFileId002 = testTable.addInflightCommit("00000000000003").getFileIdsWithBaseFilesInPartitions(new String[]{p0, p1});
        final String file2P0C1 = (String)partitionAndFileId002.get(p0);
        final String file2P1C1 = (String)partitionAndFileId002.get(p1);
        Map<String, List<String>> part2ToFileId = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
            {
                this.put(p0, CollectionUtils.createImmutableList((Object[])new String[]{file1P0C0, file2P0C1}));
                this.put(p1, CollectionUtils.createImmutableList((Object[])new String[]{file1P1C0, file2P1C1}));
            }
        });
        this.commitWithMdt("00000000000003", part2ToFileId, testTable, config, true, true);
        testTable = this.tearDownTestTableAndReinit(testTable, config);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        List<HoodieCleanStat> hoodieCleanStatsTwo = this.runCleaner(config, simulateFailureRetry, simulateMetadataFailure, 4, true);
        Assertions.assertEquals((int)0, (int)hoodieCleanStatsTwo.size(), (String)"Must not scan any partitions and clean any files");
        Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000003", file2P0C1));
        Assertions.assertTrue((boolean)testTable.baseFileExists(p1, "00000000000003", file2P1C1));
        Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000001", file1P0C0));
        Assertions.assertTrue((boolean)testTable.baseFileExists(p1, "00000000000001", file1P1C0));
        final String file3P0C2 = (String)testTable.addInflightCommit("00000000000005").getFileIdsWithBaseFilesInPartitions(new String[]{p0}).get(p0);
        Map<String, List<String>> part3ToFileId = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
            {
                this.put(p0, CollectionUtils.createImmutableList((Object[])new String[]{file1P0C0, file2P0C1, file3P0C2}));
            }
        });
        this.commitWithMdt("00000000000005", part3ToFileId, testTable, config, true, true);
        testTable = this.tearDownTestTableAndReinit(testTable, config);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        List<HoodieCleanStat> hoodieCleanStatsThree = this.runCleaner(config, simulateFailureRetry, simulateMetadataFailure, 6, true);
        Assertions.assertEquals((int)0, (int)hoodieCleanStatsThree.size(), (String)"Must not clean any file. We have to keep 1 version before the latest commit time to keep");
        Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000001", file1P0C0));
        final String file4P0C3 = (String)testTable.addInflightCommit("00000000000007").getFileIdsWithBaseFilesInPartitions(new String[]{p0}).get(p0);
        Map<String, List<String>> part4ToFileId = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
            {
                this.put(p0, CollectionUtils.createImmutableList((Object[])new String[]{file1P0C0, file2P0C1, file4P0C3}));
            }
        });
        this.commitWithMdt("00000000000007", part4ToFileId, testTable, config);
        testTable = this.tearDownTestTableAndReinit(testTable, config);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        List<HoodieCleanStat> hoodieCleanStatsFour = this.runCleaner(config, simulateFailureRetry, simulateMetadataFailure, 8, true);
        HoodieCleanStat partitionCleanStat = this.getCleanStat(hoodieCleanStatsFour, p0);
        Assertions.assertEquals((int)3, (int)partitionCleanStat.getSuccessDeleteFiles().size());
        Assertions.assertFalse((boolean)testTable.baseFileExists(p0, "00000000000001", file1P0C0));
        Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000003", file1P0C0));
        Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000005", file1P0C0));
        Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000003", file2P0C1));
        Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000005", file2P0C1));
        Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000005", file3P0C2));
        Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000007", file4P0C3));
        if (enableBootstrapSourceClean) {
            Assertions.assertEquals((int)1, (int)partitionCleanStat.getSuccessDeleteBootstrapBaseFiles().size());
            Assertions.assertFalse((boolean)Files.exists(Paths.get(bootstrapMapping.get(p0).get(0).getBootstrapFileStatus().getPath().getUri(), new String[0]), new LinkOption[0]));
        }
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        final String file5P0C4 = (String)testTable.addInflightCommit("00000000000009").getFileIdsWithBaseFilesInPartitions(new String[]{p0}).get(p0);
        Map<String, List<String>> part5ToFileId = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
            {
                this.put(p0, CollectionUtils.createImmutableList((Object[])new String[]{file1P0C0, file2P0C1, file5P0C4}));
            }
        });
        this.commitWithMdt("00000000000009", part5ToFileId, testTable, config, true, true);
        testTable = this.tearDownTestTableAndReinit(testTable, config);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        List<HoodieCleanStat> hoodieCleanStatsFive = this.runCleaner(config, simulateFailureRetry, simulateMetadataFailure, 10, true);
        Assertions.assertEquals((int)0, (int)hoodieCleanStatsFive.size(), (String)"Must not clean any files since at least 2 commits are needed from last clean operation before clean can be scheduled again");
        Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000003", file1P0C0));
        Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000005", file1P0C0));
        Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000003", file2P0C1));
        Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000005", file2P0C1));
        Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000005", file3P0C2));
        Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000007", file4P0C3));
        testTable.forCommit("00000000000011").withBaseFilesInPartition(p0, new String[]{file3P0C2});
        HoodieCommitMetadata commitMetadata = TestCleanPlanExecutor.generateCommitMetadata("00000000000011", Collections.singletonMap(p0, CollectionUtils.createImmutableList((Object[])new String[]{file3P0C2})));
        this.metaClient.getActiveTimeline().createNewInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "commit", "00000000000011"));
        this.metaClient.getActiveTimeline().transitionRequestedToInflight(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "commit", "00000000000011"), Option.of((Object)commitMetadata));
        List<HoodieCleanStat> hoodieCleanStatsFive2 = this.runCleaner(config, simulateFailureRetry, simulateMetadataFailure, 12, true);
        HoodieCleanStat cleanStat = this.getCleanStat(hoodieCleanStatsFive2, p0);
        Assertions.assertNull((Object)cleanStat, (String)"Must not clean any files");
        Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000005", file3P0C2));
        Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000007", file4P0C3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKeepLatestFileVersions() throws Exception {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withMetadataConfig(HoodieMetadataConfig.newBuilder().build()).withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS).retainFileVersions(1).build()).build();
        try (HoodieTestTable testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)this.getMetadataWriter(config), (Option)Option.of((Object)this.context));){
            String p0 = "2020/01/01";
            String p1 = "2020/01/02";
            String file1P0C0 = UUID.randomUUID().toString();
            String file1P1C0 = UUID.randomUUID().toString();
            HashMap<String, List<Pair>> c1PartitionToFilesNameLengthMap = new HashMap<String, List<Pair>>();
            c1PartitionToFilesNameLengthMap.put("2020/01/01", Collections.singletonList(Pair.of((Object)file1P0C0, (Object)100)));
            c1PartitionToFilesNameLengthMap.put("2020/01/02", Collections.singletonList(Pair.of((Object)file1P1C0, (Object)200)));
            testTable.doWriteOperation("00000000000001", WriteOperationType.INSERT, Arrays.asList("2020/01/01", "2020/01/02"), c1PartitionToFilesNameLengthMap, false, false);
            List<HoodieCleanStat> hoodieCleanStatsOne = this.runCleaner(config, 2, true);
            Assertions.assertEquals((int)0, (int)hoodieCleanStatsOne.size(), (String)"Must not clean any files");
            Assertions.assertTrue((boolean)testTable.baseFileExists("2020/01/01", "00000000000001", file1P0C0));
            Assertions.assertTrue((boolean)testTable.baseFileExists("2020/01/02", "00000000000001", file1P1C0));
            String file2P0C1 = UUID.randomUUID().toString();
            String file2P1C1 = UUID.randomUUID().toString();
            HashMap<String, List<Pair>> c2PartitionToFilesNameLengthMap = new HashMap<String, List<Pair>>();
            c2PartitionToFilesNameLengthMap.put("2020/01/01", Arrays.asList(Pair.of((Object)file1P0C0, (Object)101), Pair.of((Object)file2P0C1, (Object)100)));
            c2PartitionToFilesNameLengthMap.put("2020/01/02", Arrays.asList(Pair.of((Object)file1P1C0, (Object)201), Pair.of((Object)file2P1C1, (Object)200)));
            testTable.doWriteOperation("00000000000003", WriteOperationType.UPSERT, Collections.emptyList(), c2PartitionToFilesNameLengthMap, false, false);
            List<HoodieCleanStat> hoodieCleanStatsTwo = this.runCleaner(config, 4, true);
            HoodieCleanStat cleanStat = this.getCleanStat(hoodieCleanStatsTwo, "2020/01/01");
            Assertions.assertEquals((int)1, (int)(cleanStat.getSuccessDeleteFiles().size() + (cleanStat.getSuccessDeleteBootstrapBaseFiles() == null ? 0 : cleanStat.getSuccessDeleteBootstrapBaseFiles().size())), (String)"Must clean at least 1 file");
            cleanStat = this.getCleanStat(hoodieCleanStatsTwo, "2020/01/02");
            Assertions.assertTrue((boolean)testTable.baseFileExists("2020/01/01", "00000000000003", file2P0C1));
            Assertions.assertTrue((boolean)testTable.baseFileExists("2020/01/02", "00000000000003", file2P1C1));
            Assertions.assertFalse((boolean)testTable.baseFileExists("2020/01/01", "00000000000001", file1P0C0));
            Assertions.assertFalse((boolean)testTable.baseFileExists("2020/01/02", "00000000000001", file1P1C0));
            Assertions.assertEquals((int)1, (int)(cleanStat.getSuccessDeleteFiles().size() + (cleanStat.getSuccessDeleteBootstrapBaseFiles() == null ? 0 : cleanStat.getSuccessDeleteBootstrapBaseFiles().size())), (String)"Must clean at least 1 file");
            String file3P0C2 = UUID.randomUUID().toString();
            HashMap<String, List<Pair>> c3PartitionToFilesNameLengthMap = new HashMap<String, List<Pair>>();
            c3PartitionToFilesNameLengthMap.put("2020/01/01", Arrays.asList(Pair.of((Object)file1P0C0, (Object)102), Pair.of((Object)file2P0C1, (Object)101), Pair.of((Object)file3P0C2, (Object)100)));
            testTable.doWriteOperation("00000000000005", WriteOperationType.UPSERT, Collections.emptyList(), c3PartitionToFilesNameLengthMap, false, false);
            List<HoodieCleanStat> hoodieCleanStatsThree = this.runCleaner(config, 6, true);
            Assertions.assertEquals((int)2, (int)this.getCleanStat(hoodieCleanStatsThree, "2020/01/01").getSuccessDeleteFiles().size(), (String)"Must clean two files");
            Assertions.assertFalse((boolean)testTable.baseFileExists("2020/01/01", "00000000000003", file1P0C0));
            Assertions.assertFalse((boolean)testTable.baseFileExists("2020/01/01", "00000000000003", file2P0C1));
            Assertions.assertTrue((boolean)testTable.baseFileExists("2020/01/01", "00000000000005", file3P0C2));
            testTable.forCommit("00000000000007").withBaseFilesInPartition("2020/01/01", new String[]{file3P0C2});
            List<HoodieCleanStat> hoodieCleanStatsFour = this.runCleaner(config);
            Assertions.assertEquals((int)0, (int)hoodieCleanStatsFour.size(), (String)"Must not clean any files");
            Assertions.assertTrue((boolean)testTable.baseFileExists("2020/01/01", "00000000000005", file3P0C2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKeepLatestFileVersionsWithBootstrapFileClean() throws Exception {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMetadataIndexColumnStats(false).withMetadataIndexPartitionStats(false).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withCleanBootstrapBaseFileEnabled(Boolean.valueOf(true)).withCleanerParallelism(1).withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS).retainFileVersions(1).build()).build();
        try (HoodieTestTable testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)this.getMetadataWriter(config), (Option)Option.of((Object)this.context));){
            String p0 = "2020/01/01";
            String p1 = "2020/01/02";
            Map<String, List<BootstrapFileMapping>> bootstrapMapping = this.generateBootstrapIndexAndSourceData("2020/01/01", "2020/01/02");
            String file1P0C0 = bootstrapMapping.get("2020/01/01").get(0).getFileId();
            String file1P1C0 = bootstrapMapping.get("2020/01/02").get(0).getFileId();
            HashMap<String, List<Pair>> c1PartitionToFilesNameLengthMap = new HashMap<String, List<Pair>>();
            c1PartitionToFilesNameLengthMap.put("2020/01/01", Collections.singletonList(Pair.of((Object)file1P0C0, (Object)100)));
            c1PartitionToFilesNameLengthMap.put("2020/01/02", Collections.singletonList(Pair.of((Object)file1P1C0, (Object)200)));
            testTable.doWriteOperation("00000000000001", WriteOperationType.INSERT, Arrays.asList("2020/01/01", "2020/01/02"), c1PartitionToFilesNameLengthMap, false, false);
            List<HoodieCleanStat> hoodieCleanStatsOne = this.runCleaner(config, 2, true);
            Assertions.assertEquals((int)0, (int)hoodieCleanStatsOne.size(), (String)"Must not clean any files");
            Assertions.assertTrue((boolean)testTable.baseFileExists("2020/01/01", "00000000000001", file1P0C0));
            Assertions.assertTrue((boolean)testTable.baseFileExists("2020/01/02", "00000000000001", file1P1C0));
            String file2P0C1 = UUID.randomUUID().toString();
            String file2P1C1 = UUID.randomUUID().toString();
            HashMap<String, List<Pair>> c2PartitionToFilesNameLengthMap = new HashMap<String, List<Pair>>();
            c2PartitionToFilesNameLengthMap.put("2020/01/01", Arrays.asList(Pair.of((Object)file1P0C0, (Object)101), Pair.of((Object)file2P0C1, (Object)100)));
            c2PartitionToFilesNameLengthMap.put("2020/01/02", Arrays.asList(Pair.of((Object)file1P1C0, (Object)201), Pair.of((Object)file2P1C1, (Object)200)));
            testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)this.getMetadataWriter(config), (Option)Option.of((Object)this.context));
            testTable.doWriteOperation("00000000000003", WriteOperationType.UPSERT, Collections.emptyList(), c2PartitionToFilesNameLengthMap, false, false);
            List<HoodieCleanStat> hoodieCleanStatsTwo = this.runCleaner(config, 4, true);
            HoodieCleanStat cleanStat = this.getCleanStat(hoodieCleanStatsTwo, "2020/01/01");
            Assertions.assertEquals((int)2, (int)(cleanStat.getSuccessDeleteFiles().size() + (cleanStat.getSuccessDeleteBootstrapBaseFiles() == null ? 0 : cleanStat.getSuccessDeleteBootstrapBaseFiles().size())), (String)"Must clean at least 1 file");
            HoodieFileStatus fstatus = bootstrapMapping.get("2020/01/01").get(0).getBootstrapFileStatus();
            Assertions.assertTrue((boolean)cleanStat.getSuccessDeleteBootstrapBaseFiles().contains(fstatus.getPath().getUri()), (String)("Successful delete files were " + cleanStat.getSuccessDeleteBootstrapBaseFiles() + " but did not contain " + fstatus.getPath().getUri()));
            Assertions.assertFalse((boolean)Files.exists(Paths.get(bootstrapMapping.get("2020/01/01").get(0).getBootstrapFileStatus().getPath().getUri(), new String[0]), new LinkOption[0]));
            cleanStat = this.getCleanStat(hoodieCleanStatsTwo, "2020/01/02");
            Assertions.assertTrue((boolean)testTable.baseFileExists("2020/01/01", "00000000000003", file2P0C1));
            Assertions.assertTrue((boolean)testTable.baseFileExists("2020/01/02", "00000000000003", file2P1C1));
            Assertions.assertFalse((boolean)testTable.baseFileExists("2020/01/01", "00000000000001", file1P0C0));
            Assertions.assertFalse((boolean)testTable.baseFileExists("2020/01/02", "00000000000001", file1P1C0));
            Assertions.assertEquals((int)2, (int)(cleanStat.getSuccessDeleteFiles().size() + (cleanStat.getSuccessDeleteBootstrapBaseFiles() == null ? 0 : cleanStat.getSuccessDeleteBootstrapBaseFiles().size())), (String)"Must clean at least 1 file");
            fstatus = bootstrapMapping.get("2020/01/02").get(0).getBootstrapFileStatus();
            Assertions.assertTrue((boolean)cleanStat.getSuccessDeleteBootstrapBaseFiles().contains(fstatus.getPath().getUri()), (String)("Successful delete files were " + cleanStat.getSuccessDeleteBootstrapBaseFiles() + " but did not contain " + fstatus.getPath().getUri()));
            Assertions.assertFalse((boolean)Files.exists(Paths.get(bootstrapMapping.get("2020/01/02").get(0).getBootstrapFileStatus().getPath().getUri(), new String[0]), new LinkOption[0]));
            String file3P0C2 = UUID.randomUUID().toString();
            HashMap<String, List<Pair>> c3PartitionToFilesNameLengthMap = new HashMap<String, List<Pair>>();
            c3PartitionToFilesNameLengthMap.put("2020/01/01", Arrays.asList(Pair.of((Object)file1P0C0, (Object)102), Pair.of((Object)file2P0C1, (Object)101), Pair.of((Object)file3P0C2, (Object)100)));
            testTable.doWriteOperation("00000000000005", WriteOperationType.UPSERT, Collections.emptyList(), c3PartitionToFilesNameLengthMap, false, false);
            List<HoodieCleanStat> hoodieCleanStatsThree = this.runCleaner(config, 6, true);
            Assertions.assertEquals((int)2, (int)this.getCleanStat(hoodieCleanStatsThree, "2020/01/01").getSuccessDeleteFiles().size(), (String)"Must clean two files");
            Assertions.assertFalse((boolean)testTable.baseFileExists("2020/01/01", "00000000000003", file1P0C0));
            Assertions.assertFalse((boolean)testTable.baseFileExists("2020/01/01", "00000000000003", file2P0C1));
            Assertions.assertTrue((boolean)testTable.baseFileExists("2020/01/01", "00000000000005", file3P0C2));
            testTable.forCommit("00000000000007").withBaseFilesInPartition("2020/01/01", new String[]{file3P0C2});
            List<HoodieCleanStat> hoodieCleanStatsFour = this.runCleaner(config);
            Assertions.assertEquals((int)0, (int)hoodieCleanStatsFour.size(), (String)"Must not clean any files");
            Assertions.assertTrue((boolean)testTable.baseFileExists("2020/01/01", "00000000000005", file3P0C2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKeepLatestFileVersionsMOR() throws Exception {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMetadataIndexColumnStats(false).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS).retainFileVersions(1).build()).build();
        HoodieTableMetaClient metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)HoodieTableType.MERGE_ON_READ);
        try (HoodieTestTable testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)metaClient, (HoodieTableMetadataWriter)this.getMetadataWriter(config), (Option)Option.of((Object)this.context));){
            final String p0 = "2020/01/01";
            final String file1P0 = (String)testTable.addDeltaCommit("000").getFileIdsWithBaseFilesInPartitions(new String[]{p0}).get(p0);
            Map<String, List<String>> part1ToFileId = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
                {
                    this.put(p0, CollectionUtils.createImmutableList((Object[])new String[]{file1P0}));
                }
            });
            this.commitWithMdt("000", part1ToFileId, testTable, config, true, true);
            testTable = this.tearDownTestTableAndReinit(testTable, config);
            ((HoodieTestTable)testTable.addDeltaCommit("001").withBaseFilesInPartition(p0, new String[]{file1P0}).getLeft()).withLogFile(p0, file1P0, new int[]{3});
            this.commitWithMdt("001", part1ToFileId, testTable, config, true, true);
            testTable = this.tearDownTestTableAndReinit(testTable, config);
            List<HoodieCleanStat> hoodieCleanStats = this.runCleaner(config);
            Assertions.assertEquals((int)3, (int)this.getCleanStat(hoodieCleanStats, p0).getSuccessDeleteFiles().size(), (String)"Must clean three files, one base and 2 log files");
            Assertions.assertFalse((boolean)testTable.baseFileExists(p0, "000", file1P0));
            Assertions.assertFalse((boolean)testTable.logFilesExist(p0, "000", file1P0, new int[]{1, 2}));
            Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "001", file1P0));
            Assertions.assertTrue((boolean)testTable.logFileExists(p0, "001", file1P0, 3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKeepLatestCommitsMOR() throws Exception {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMetadataIndexColumnStats(false).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(1).build()).build();
        HoodieTableMetaClient metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)HoodieTableType.MERGE_ON_READ);
        try (HoodieTestTable testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)metaClient, (HoodieTableMetadataWriter)this.getMetadataWriter(config), (Option)Option.of((Object)this.context));){
            final String p0 = "2020/01/01";
            final String file1P0 = (String)testTable.addDeltaCommit("000").getFileIdsWithBaseFilesInPartitions(new String[]{p0}).get(p0);
            Map<String, List<String>> part1ToFileId = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
                {
                    this.put(p0, CollectionUtils.createImmutableList((Object[])new String[]{file1P0}));
                }
            });
            this.commitWithMdt("000", part1ToFileId, testTable, config, true, true);
            testTable = this.tearDownTestTableAndReinit(testTable, config);
            ((HoodieTestTable)testTable.addDeltaCommit("001").withBaseFilesInPartition(p0, new String[]{file1P0}).getLeft()).withLogFile(p0, file1P0, new int[]{3});
            this.commitWithMdt("001", part1ToFileId, testTable, config, true, true);
            testTable = this.tearDownTestTableAndReinit(testTable, config);
            ((HoodieTestTable)testTable.addDeltaCommit("002").withBaseFilesInPartition(p0, new String[]{file1P0}).getLeft()).withLogFile(p0, file1P0, new int[]{4});
            this.commitWithMdt("002", part1ToFileId, testTable, config, true, true);
            testTable = this.tearDownTestTableAndReinit(testTable, config);
            List<HoodieCleanStat> hoodieCleanStats = this.runCleaner(config);
            Assertions.assertEquals((int)3, (int)this.getCleanStat(hoodieCleanStats, p0).getSuccessDeleteFiles().size(), (String)"Must clean three files, one base and 2 log files");
            Assertions.assertFalse((boolean)testTable.baseFileExists(p0, "000", file1P0));
            Assertions.assertFalse((boolean)testTable.logFilesExist(p0, "000", file1P0, new int[]{1, 2}));
            Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "001", file1P0));
            Assertions.assertTrue((boolean)testTable.logFileExists(p0, "001", file1P0, 3));
            Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "002", file1P0));
            Assertions.assertTrue((boolean)testTable.logFileExists(p0, "002", file1P0, 4));
        }
    }

    @Test
    public void testKeepLatestCommitWithDeletePartition() throws Exception {
        this.testCleanDeletePartition(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(1).build());
    }

    @Test
    public void testKeepXHoursWithDeletePartition() throws Exception {
        this.testCleanDeletePartition(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_BY_HOURS).cleanerNumHoursRetained(30).build());
    }

    @Test
    public void testKeepFileVersionsWithDeletePartition() throws Exception {
        this.testCleanDeletePartition(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCleanDeletePartition(HoodieCleanConfig cleanConfig) throws Exception {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withCleanConfig(cleanConfig).build();
        long now = System.currentTimeMillis();
        String commitInstant = TimelineUtils.formatDate((Date)new Date(now - 176400000L));
        String deleteInstant1 = TimelineUtils.formatDate((Date)new Date(now - 172800000L));
        String deleteInstant2 = TimelineUtils.formatDate((Date)new Date(now - 86400000L));
        final String p1 = "part_1";
        final String file1P1 = UUID.randomUUID().toString();
        final String file2P1 = UUID.randomUUID().toString();
        final String p2 = "part_2";
        final String file1P2 = UUID.randomUUID().toString();
        final String file2P2 = UUID.randomUUID().toString();
        try (HoodieTestTable testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)this.getMetadataWriter(config), (Option)Option.of((Object)this.context));){
            testTable.withPartitionMetaFiles(new String[]{p1, p2});
            Map<String, List<String>> part1ToFileId = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
                {
                    this.put(p1, CollectionUtils.createImmutableList((Object[])new String[]{file1P1, file2P1}));
                    this.put(p2, CollectionUtils.createImmutableList((Object[])new String[]{file1P2, file2P2}));
                }
            });
            this.commitWithMdt(commitInstant, part1ToFileId, testTable, config, true, true);
            testTable = this.tearDownTestTableAndReinit(testTable, config);
            testTable.addDeletePartitionCommit(deleteInstant1, p1, Arrays.asList(file1P1, file2P1));
            testTable = this.tearDownTestTableAndReinit(testTable, config);
            testTable.addDeletePartitionCommit(deleteInstant2, p2, Arrays.asList(file1P2, file2P2));
            this.runCleaner(config);
            Assertions.assertFalse((boolean)testTable.baseFileExists(p1, commitInstant, file1P1), (String)"p1 cleaned");
            Assertions.assertFalse((boolean)testTable.baseFileExists(p1, commitInstant, file2P1), (String)"p1 cleaned");
            String policy = cleanConfig.getString(HoodieCleanConfig.CLEANER_POLICY);
            if (HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS.name().equals(policy)) {
                Assertions.assertFalse((boolean)testTable.baseFileExists(p2, commitInstant, file1P2), (String)"p2 cleaned");
                Assertions.assertFalse((boolean)testTable.baseFileExists(p2, commitInstant, file2P2), (String)"p2 cleaned");
            } else {
                Assertions.assertTrue((boolean)testTable.baseFileExists(p2, commitInstant, file1P2), (String)"p2 retained");
                Assertions.assertTrue((boolean)testTable.baseFileExists(p2, commitInstant, file2P2), (String)"p2 retained");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"argumentsForTestKeepLatestCommits"})
    public void testKeepXHoursWithCleaning(boolean simulateFailureRetry, boolean simulateMetadataFailure, boolean enableIncrementalClean, boolean enableBootstrapSourceClean) throws Exception {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withMetadataConfig(HoodieMetadataConfig.newBuilder().build()).withCleanConfig(HoodieCleanConfig.newBuilder().withIncrementalCleaningMode(Boolean.valueOf(enableIncrementalClean)).withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.EAGER).withCleanBootstrapBaseFileEnabled(Boolean.valueOf(enableBootstrapSourceClean)).withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_BY_HOURS).cleanerNumHoursRetained(2).build()).build();
        try (HoodieTestTable testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)this.getMetadataWriter(config), (Option)Option.of((Object)this.context));){
            final String p0 = "2020/01/01";
            final String p1 = "2020/01/02";
            Map<String, List<BootstrapFileMapping>> bootstrapMapping = enableBootstrapSourceClean ? this.generateBootstrapIndexAndSourceData(p0, p1) : null;
            final String file1P0C0 = enableBootstrapSourceClean ? ((BootstrapFileMapping)((List)bootstrapMapping.get(p0)).get(0)).getFileId() : UUID.randomUUID().toString();
            final String file1P1C0 = enableBootstrapSourceClean ? bootstrapMapping.get(p1).get(0).getFileId() : UUID.randomUUID().toString();
            Instant instant = Instant.now();
            ZonedDateTime commitDateTime = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
            int minutesForFirstCommit = 180;
            String firstCommitTs = TimelineUtils.formatDate((Date)Date.from(commitDateTime.minusMinutes(minutesForFirstCommit).toInstant()));
            Map<String, List<String>> part1ToFileId = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
                {
                    this.put(p0, CollectionUtils.createImmutableList((Object[])new String[]{file1P0C0}));
                    this.put(p1, CollectionUtils.createImmutableList((Object[])new String[]{file1P1C0}));
                }
            });
            this.commitWithMdt(firstCommitTs, part1ToFileId, testTable, config, true, true);
            testTable = this.tearDownTestTableAndReinit(testTable, config);
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            List<HoodieCleanStat> hoodieCleanStatsOne = this.runCleaner(config, simulateFailureRetry, simulateMetadataFailure);
            Assertions.assertEquals((int)0, (int)hoodieCleanStatsOne.size(), (String)"Must not scan any partitions and clean any files");
            Assertions.assertTrue((boolean)testTable.baseFileExists(p0, firstCommitTs, file1P0C0));
            Assertions.assertTrue((boolean)testTable.baseFileExists(p1, firstCommitTs, file1P1C0));
            int minutesForSecondCommit = 150;
            String secondCommitTs = TimelineUtils.formatDate((Date)Date.from(commitDateTime.minusMinutes(minutesForSecondCommit).toInstant()));
            Map partitionAndFileId002 = testTable.addInflightCommit(secondCommitTs).getFileIdsWithBaseFilesInPartitions(new String[]{p0, p1});
            final String file2P0C1 = (String)partitionAndFileId002.get(p0);
            final String file2P1C1 = (String)partitionAndFileId002.get(p1);
            Map<String, List<String>> part2ToFileId = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
                {
                    this.put(p0, CollectionUtils.createImmutableList((Object[])new String[]{file1P0C0, file2P0C1}));
                    this.put(p1, CollectionUtils.createImmutableList((Object[])new String[]{file1P1C0, file2P1C1}));
                }
            });
            this.commitWithMdt(secondCommitTs, part2ToFileId, testTable, config, true, true);
            testTable = this.tearDownTestTableAndReinit(testTable, config);
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            int minutesForThirdCommit = 90;
            String thirdCommitTs = TimelineUtils.formatDate((Date)Date.from(commitDateTime.minusMinutes(minutesForThirdCommit).toInstant()));
            Map partitionAndFileId003 = testTable.addInflightCommit(thirdCommitTs).getFileIdsWithBaseFilesInPartitions(new String[]{p0, p1});
            final String file3P0C1 = (String)partitionAndFileId003.get(p0);
            final String file3P1C1 = (String)partitionAndFileId003.get(p1);
            Map<String, List<String>> part3ToFileId = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
                {
                    this.put(p0, CollectionUtils.createImmutableList((Object[])new String[]{file1P0C0, file2P0C1, file3P0C1}));
                    this.put(p1, CollectionUtils.createImmutableList((Object[])new String[]{file1P1C0, file2P1C1, file3P1C1}));
                }
            });
            this.commitWithMdt(thirdCommitTs, part3ToFileId, testTable, config, true, true);
            testTable = this.tearDownTestTableAndReinit(testTable, config);
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            List<HoodieCleanStat> hoodieCleanStatsThree = this.runCleaner(config, simulateFailureRetry, simulateMetadataFailure);
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            Assertions.assertEquals((int)2, (int)hoodieCleanStatsThree.size(), (String)"Should clean one file each from both the partitions");
            Assertions.assertTrue((boolean)testTable.baseFileExists(p0, thirdCommitTs, file3P0C1));
            Assertions.assertTrue((boolean)testTable.baseFileExists(p1, thirdCommitTs, file3P1C1));
            Assertions.assertTrue((boolean)testTable.baseFileExists(p0, secondCommitTs, file2P0C1));
            Assertions.assertTrue((boolean)testTable.baseFileExists(p1, secondCommitTs, file2P1C1));
            Assertions.assertTrue((boolean)testTable.baseFileExists(p0, secondCommitTs, file1P0C0));
            Assertions.assertTrue((boolean)testTable.baseFileExists(p1, secondCommitTs, file1P1C0));
            Assertions.assertFalse((boolean)testTable.baseFileExists(p0, firstCommitTs, file1P0C0));
            Assertions.assertFalse((boolean)testTable.baseFileExists(p1, firstCommitTs, file1P1C0));
        }
    }
}

