/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.functional;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="functional")
public class TestHoodieSparkCopyOnWriteTableArchiveWithReplace
extends SparkClientFunctionalTestHarness {
    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testDeletePartitionAndArchive(boolean metadataEnabled) throws IOException {
        HoodieTableMetaClient metaClient = this.getHoodieMetaClient(HoodieTableType.COPY_ON_WRITE);
        HoodieWriteConfig writeConfig = this.getConfigBuilder(true).withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(1).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(4, 5).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(metadataEnabled).build()).build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(writeConfig);
             HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS);){
            String instantTime1 = client.createNewInstantTime();
            client.startCommitWithTime(instantTime1);
            client.insert(this.jsc().parallelize(dataGen.generateInsertsForPartition(instantTime1, Integer.valueOf(10), "2016/03/15"), 1), instantTime1);
            String instantTime2 = client.createNewInstantTime();
            client.startCommitWithTime(instantTime2);
            client.insert(this.jsc().parallelize(dataGen.generateInsertsForPartition(instantTime2, Integer.valueOf(10), "2015/03/16"), 1), instantTime2);
            String instantTime3 = client.createNewInstantTime();
            client.startCommitWithTime(instantTime3);
            client.insert(this.jsc().parallelize(dataGen.generateInsertsForPartition(instantTime3, Integer.valueOf(1), "2015/03/17"), 1), instantTime3);
            HoodieTimeline timeline1 = metaClient.getCommitsTimeline().filterCompletedInstants();
            Assertions.assertEquals((long)21L, (long)HoodieClientTestUtils.countRecordsOptionallySince(this.jsc(), this.basePath(), this.sqlContext(), timeline1, (Option<String>)Option.empty()));
            String instantTime4 = client.createNewInstantTime();
            client.startCommitWithTime(instantTime4, "replacecommit");
            client.deletePartitions(Arrays.asList("2016/03/15", "2015/03/16"), instantTime4);
            for (int i = 5; i < 11; ++i) {
                String instantTime = client.createNewInstantTime();
                client.startCommitWithTime(instantTime);
                client.insert(this.jsc().parallelize(dataGen.generateInsertsForPartition(instantTime, Integer.valueOf(1), "2015/03/17"), 1), instantTime);
            }
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            HoodieArchivedTimeline archivedTimeline = metaClient.getArchivedTimeline();
            Assertions.assertTrue((boolean)archivedTimeline.containsInstant(instantTime1));
            Assertions.assertTrue((boolean)archivedTimeline.containsInstant(instantTime2));
            Assertions.assertTrue((boolean)archivedTimeline.containsInstant(instantTime3));
            Assertions.assertTrue((boolean)archivedTimeline.containsInstant(instantTime4), (String)"should contain the replace commit.");
            HoodieTimeline timeline2 = metaClient.getCommitTimeline().filterCompletedInstants();
            Assertions.assertEquals((long)7L, (long)HoodieClientTestUtils.countRecordsOptionallySince(this.jsc(), this.basePath(), this.sqlContext(), timeline2, (Option<String>)Option.empty()), (String)"should only have the 7 records from the 3rd partition.");
        }
    }
}

