/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.marker.AppendMarkerHandler;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.spark.api.java.JavaSparkContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public abstract class TestWriteMarkersBase
extends HoodieCommonTestHarness {
    protected WriteMarkers writeMarkers;
    protected HoodieStorage storage;
    protected StoragePath markerFolderPath;
    protected JavaSparkContext jsc;
    protected HoodieSparkEngineContext context;

    protected void createSomeMarkers(boolean isTablePartitioned) {
        this.writeMarkers.create(isTablePartitioned ? "2020/06/01" : "", "file1", IOType.MERGE);
        this.writeMarkers.create(isTablePartitioned ? "2020/06/02" : "", "file2", IOType.APPEND);
        this.writeMarkers.create(isTablePartitioned ? "2020/06/03" : "", "file3", IOType.CREATE);
        this.writeMarkers.createLogMarkerIfNotExists(isTablePartitioned ? "2025/03/28" : "", "file4.log", HoodieWriteConfig.newBuilder().withPath(this.metaClient.getBasePath()).build(), "", this.metaClient.getActiveTimeline());
    }

    protected List<String> getRelativeMarkerPathList(boolean isTablePartitioned) {
        IOType logMarkerType = this.writeMarkers instanceof AppendMarkerHandler ? IOType.APPEND : IOType.CREATE;
        return isTablePartitioned ? CollectionUtils.createImmutableList((Object[])new String[]{"2020/06/01/file1.marker.MERGE", "2020/06/02/file2.marker.APPEND", "2020/06/03/file3.marker.CREATE", "2025/03/28/file4.log.marker." + logMarkerType}) : CollectionUtils.createImmutableList((Object[])new String[]{"file1.marker.MERGE", "file2.marker.APPEND", "file3.marker.CREATE", "file4.log.marker." + logMarkerType});
    }

    private void createInvalidFile(String partitionPath, String invalidFileName) {
        StoragePath path = FSUtils.constructAbsolutePath((StoragePath)this.markerFolderPath, (String)partitionPath);
        StoragePath invalidFilePath = new StoragePath(path, invalidFileName);
        try {
            this.storage.create(invalidFilePath, false).close();
        }
        catch (IOException e) {
            throw new HoodieException("Failed to create invalid file " + invalidFilePath, (Throwable)e);
        }
    }

    protected StoragePath createDataFile(String partitionPath, String datafileName) {
        StoragePath path = FSUtils.constructAbsolutePath((StoragePath)this.metaClient.getBasePath(), (String)(partitionPath + "/" + datafileName));
        try {
            this.storage.create(path, false).close();
        }
        catch (IOException e) {
            throw new HoodieException("Failed to create data file " + path, (Throwable)e);
        }
        return path;
    }

    abstract void verifyMarkersInFileSystem(boolean var1) throws IOException;

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCreation(boolean isTablePartitioned) throws Exception {
        this.createSomeMarkers(isTablePartitioned);
        Assertions.assertTrue((boolean)this.storage.exists(this.markerFolderPath));
        this.verifyMarkersInFileSystem(isTablePartitioned);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDeletionWhenMarkerDirExists(boolean isTablePartitioned) throws IOException {
        this.writeMarkers.create(isTablePartitioned ? "2020/06/01" : "", "file1", IOType.MERGE);
        Assertions.assertTrue((boolean)this.writeMarkers.doesMarkerDirExist());
        Assertions.assertTrue((boolean)this.writeMarkers.deleteMarkerDir((HoodieEngineContext)this.context, 2));
        Assertions.assertFalse((boolean)this.writeMarkers.doesMarkerDirExist());
    }

    @Test
    public void testDeletionWhenMarkerDirNotExists() throws IOException {
        Assertions.assertFalse((boolean)this.writeMarkers.doesMarkerDirExist());
        Assertions.assertTrue((boolean)this.writeMarkers.allMarkerFilePaths().isEmpty());
        Assertions.assertFalse((boolean)this.writeMarkers.deleteMarkerDir((HoodieEngineContext)this.context, 2));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDataPathsWhenCreatingOrMerging(boolean isTablePartitioned) throws IOException {
        this.createSomeMarkers(isTablePartitioned);
        this.createInvalidFile(isTablePartitioned ? "2020/06/01" : "", "invalid_file3");
        long fileSize = HoodieTestTable.listRecursive((HoodieStorage)this.storage, (StoragePath)this.markerFolderPath).stream().filter(fileStatus -> !fileStatus.getPath().getName().contains("MARKERS.type")).count();
        Assertions.assertEquals((long)(this.getRelativeMarkerPathList(isTablePartitioned).size() + 1), (long)fileSize);
        ArrayList<String> expectedPaths = new ArrayList<String>(isTablePartitioned ? Arrays.asList("2020/06/01/file1", "2020/06/03/file3") : Arrays.asList("file1", "file3"));
        if (!(this.writeMarkers instanceof AppendMarkerHandler)) {
            expectedPaths.add(isTablePartitioned ? "2025/03/28/file4.log" : "file4.log");
        }
        Assertions.assertIterableEquals(expectedPaths, (Iterable)this.writeMarkers.createdAndMergedDataPaths((HoodieEngineContext)this.context, 2).stream().sorted().collect(Collectors.toList()));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGetAppendedLogPaths(boolean isTablePartitioned) throws IOException {
        if (this.writeMarkers instanceof AppendMarkerHandler) {
            this.createSomeMarkers(isTablePartitioned);
            this.createInvalidFile(isTablePartitioned ? "2020/06/01" : "", "invalid_file3");
            long fileSize = this.storage.listFiles(this.markerFolderPath).stream().filter(fileStatus -> !fileStatus.getPath().getName().contains("MARKERS.type")).count();
            Assertions.assertEquals((long)(this.getRelativeMarkerPathList(isTablePartitioned).size() + 1), (long)fileSize);
            ArrayList<String> expectedPaths = new ArrayList<String>(isTablePartitioned ? Collections.singletonList("2020/06/02/file2") : Collections.singletonList("file2"));
            if (this.writeMarkers instanceof AppendMarkerHandler) {
                expectedPaths.add(isTablePartitioned ? "2025/03/28/file4.log" : "file4.log");
            }
            Assertions.assertIterableEquals(expectedPaths, (Iterable)((AppendMarkerHandler)this.writeMarkers).getAppendedLogPaths((HoodieEngineContext)this.context, 2).stream().sorted().collect(Collectors.toList()));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testAllMarkerPaths(boolean isTablePartitioned) throws IOException {
        this.createSomeMarkers(isTablePartitioned);
        List<String> expectedPaths = this.getRelativeMarkerPathList(isTablePartitioned);
        Assertions.assertIterableEquals(expectedPaths, (Iterable)this.writeMarkers.allMarkerFilePaths().stream().filter(path -> !path.contains("MARKERS.type")).sorted().collect(Collectors.toList()));
    }

    @Test
    public void testStripMarkerSuffix() {
        String pathPrefix = "file://" + this.metaClient.getMetaPath() + "/file";
        String markerFilePath = pathPrefix + ".marker.APPEND";
        Assertions.assertEquals((Object)pathPrefix, (Object)WriteMarkers.stripMarkerSuffix((String)markerFilePath));
    }
}

