/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.testutils.HoodieMetadataTestTable;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.hudi.table.upgrade.SparkUpgradeDowngradeHelper;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngrade;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class TestUpgradeDowngrade
extends HoodieClientTestBase {
    private static final String TEST_NAME_WITH_PARAMS = "[{index}] Test with deletePartialMarkerFiles={0} and TableType = {1}";
    private static final String TEST_NAME_WITH_DOWNGRADE_PARAMS = "[{index}] Test with deletePartialMarkerFiles={0} and TableType = {1} and  enableMetadataTable = {2} and from {3} to {4}";

    public static Stream<Arguments> configParams() {
        Object[][] data = new Object[][]{{true, HoodieTableType.COPY_ON_WRITE}, {false, HoodieTableType.COPY_ON_WRITE}, {true, HoodieTableType.MERGE_ON_READ}, {false, HoodieTableType.MERGE_ON_READ}};
        return Stream.of(data).map(Arguments::of);
    }

    public static Stream<Arguments> downGradeConfigParams() {
        Object[][] data = new Object[][]{{true, HoodieTableType.COPY_ON_WRITE, true, HoodieTableVersion.SIX, HoodieTableVersion.FIVE}, {false, HoodieTableType.COPY_ON_WRITE, false, HoodieTableVersion.SIX, HoodieTableVersion.FIVE}, {true, HoodieTableType.COPY_ON_WRITE, true, HoodieTableVersion.FIVE, HoodieTableVersion.FOUR}, {false, HoodieTableType.COPY_ON_WRITE, false, HoodieTableVersion.FIVE, HoodieTableVersion.FOUR}, {true, HoodieTableType.MERGE_ON_READ, true, HoodieTableVersion.FIVE, HoodieTableVersion.FOUR}, {false, HoodieTableType.MERGE_ON_READ, false, HoodieTableVersion.FIVE, HoodieTableVersion.FOUR}, {true, HoodieTableType.COPY_ON_WRITE, true, HoodieTableVersion.FOUR, HoodieTableVersion.TWO}, {false, HoodieTableType.COPY_ON_WRITE, false, HoodieTableVersion.FOUR, HoodieTableVersion.TWO}, {true, HoodieTableType.MERGE_ON_READ, true, HoodieTableVersion.FOUR, HoodieTableVersion.TWO}, {false, HoodieTableType.MERGE_ON_READ, false, HoodieTableVersion.FOUR, HoodieTableVersion.TWO}, {true, HoodieTableType.COPY_ON_WRITE, false, HoodieTableVersion.TWO, HoodieTableVersion.ONE}, {false, HoodieTableType.COPY_ON_WRITE, false, HoodieTableVersion.TWO, HoodieTableVersion.ONE}, {true, HoodieTableType.MERGE_ON_READ, false, HoodieTableVersion.TWO, HoodieTableVersion.ONE}, {false, HoodieTableType.MERGE_ON_READ, false, HoodieTableVersion.TWO, HoodieTableVersion.ONE}, {true, HoodieTableType.COPY_ON_WRITE, false, HoodieTableVersion.ONE, HoodieTableVersion.ZERO}, {false, HoodieTableType.COPY_ON_WRITE, false, HoodieTableVersion.ONE, HoodieTableVersion.ZERO}, {true, HoodieTableType.MERGE_ON_READ, false, HoodieTableVersion.ONE, HoodieTableVersion.ZERO}, {false, HoodieTableType.MERGE_ON_READ, false, HoodieTableVersion.ONE, HoodieTableVersion.ZERO}};
        return Stream.of(data).map(Arguments::of);
    }

    public static Stream<Arguments> twoToThreeUpgradeConfigParams() {
        Object[][] data = new Object[][]{{HoodieTableType.COPY_ON_WRITE, Option.empty()}, {HoodieTableType.COPY_ON_WRITE, Option.of((Object)TimestampBasedKeyGenerator.class.getName())}, {HoodieTableType.MERGE_ON_READ, Option.empty()}, {HoodieTableType.MERGE_ON_READ, Option.of((Object)TimestampBasedKeyGenerator.class.getName())}};
        return Stream.of(data).map(Arguments::of);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.initSparkContexts();
        this.initPath();
        this.initTestDataGenerator();
        this.initMetaClient();
    }

    @AfterEach
    public void cleanUp() throws Exception {
        this.cleanupResources();
    }

    @Test
    public void testWithoutAutoUpgrade() throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addNewTableParamsToProps(params);
        HoodieWriteConfig cfg = this.getConfigBuilder().withAutoUpgradeVersion(false).withProps(params).build();
        HoodieTableMetaClient metaClient = HoodieTestUtils.init((String)this.basePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE, (HoodieTableVersion)HoodieTableVersion.SIX);
        new UpgradeDowngrade(metaClient, cfg, (HoodieEngineContext)this.context, (SupportsUpgradeDowngrade)SparkUpgradeDowngradeHelper.getInstance()).run(HoodieTableVersion.EIGHT, null);
        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTableVersion.SIX, (Object)metaClient.getTableConfig().getTableVersion());
    }

    @Test
    public void testLeftOverUpdatedPropFileCleanup() throws IOException {
        this.testUpgradeZeroToOneInternal(true, true, HoodieTableType.MERGE_ON_READ);
    }

    @ParameterizedTest(name="[{index}] Test with deletePartialMarkerFiles={0} and TableType = {1}")
    @MethodSource(value={"configParams"})
    public void testUpgradeZeroToOne(boolean deletePartialMarkerFiles, HoodieTableType tableType) throws IOException {
        this.testUpgradeZeroToOneInternal(false, deletePartialMarkerFiles, tableType);
    }

    public void testUpgradeZeroToOneInternal(boolean induceResiduesFromPrevUpgrade, boolean deletePartialMarkerFiles, HoodieTableType tableType) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (tableType == HoodieTableType.MERGE_ON_READ) {
            params.put(HoodieTableConfig.TYPE.key(), HoodieTableType.MERGE_ON_READ.name());
            this.metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)HoodieTableType.MERGE_ON_READ);
        }
        HoodieWriteConfig cfg = this.getConfigBuilder().withAutoCommit(false).withRollbackUsingMarkers(false).withProps(params).build();
        SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);
        ArrayList<FileSlice> firstPartitionCommit2FileSlices = new ArrayList<FileSlice>();
        ArrayList<FileSlice> secondPartitionCommit2FileSlices = new ArrayList<FileSlice>();
        Pair<List<HoodieRecord>, List<HoodieRecord>> inputRecords = this.twoUpsertCommitDataWithTwoPartitions(firstPartitionCommit2FileSlices, secondPartitionCommit2FileSlices, cfg, client, false);
        HoodieSparkTable table = this.getHoodieTable(this.metaClient, cfg);
        this.prepForUpgradeFromZeroToOne((HoodieTable)table);
        HoodieInstant commitsInstant = (HoodieInstant)table.getPendingCommitsTimeline().lastInstant().get();
        WriteMarkers writeMarkers = WriteMarkersFactory.get((MarkerType)this.getConfig().getMarkersType(), (HoodieTable)table, (String)commitsInstant.requestedTime());
        ArrayList markerPaths = new ArrayList(writeMarkers.allMarkerFilePaths());
        if (deletePartialMarkerFiles) {
            String toDeleteMarkerFile = (String)markerPaths.get(0);
            table.getStorage().deleteDirectory(new StoragePath(table.getMetaClient().getTempFolderPath() + "/" + commitsInstant.requestedTime() + "/" + toDeleteMarkerFile));
            markerPaths.remove(toDeleteMarkerFile);
        }
        this.metaClient.getTableConfig().setTableVersion(HoodieTableVersion.ZERO);
        if (induceResiduesFromPrevUpgrade) {
            this.createResidualFile();
        }
        new UpgradeDowngrade(this.metaClient, cfg, (HoodieEngineContext)this.context, (SupportsUpgradeDowngrade)SparkUpgradeDowngradeHelper.getInstance()).run(HoodieTableVersion.ONE, null);
        this.assertMarkerFilesForUpgrade((HoodieTable)table, commitsInstant, firstPartitionCommit2FileSlices, secondPartitionCommit2FileSlices);
        this.metaClient = HoodieTableMetaClient.builder().setConf(this.context.getStorageConf().newInstance()).setBasePath(cfg.getBasePath()).setLayoutVersion(Option.of((Object)new TimelineLayoutVersion(cfg.getTimelineLayoutVersion()))).build();
        this.assertTableVersionOnDataAndMetadataTable(this.metaClient, HoodieTableVersion.ONE);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testUpgradeOneToTwo(HoodieTableType tableType) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addNewTableParamsToProps(params);
        if (tableType == HoodieTableType.MERGE_ON_READ) {
            params.put(HoodieTableConfig.TYPE.key(), HoodieTableType.MERGE_ON_READ.name());
            this.metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)HoodieTableType.MERGE_ON_READ);
        }
        HoodieWriteConfig cfg = this.getConfigBuilder().withAutoCommit(false).withRollbackUsingMarkers(false).withProps(params).build();
        SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);
        this.doInsert(client);
        this.downgradeTableConfigsFromTwoToOne(cfg);
        new UpgradeDowngrade(this.metaClient, cfg, (HoodieEngineContext)this.context, (SupportsUpgradeDowngrade)SparkUpgradeDowngradeHelper.getInstance()).run(HoodieTableVersion.TWO, null);
        this.metaClient = HoodieTableMetaClient.builder().setConf(this.context.getStorageConf().newInstance()).setBasePath(cfg.getBasePath()).setLayoutVersion(Option.of((Object)new TimelineLayoutVersion(cfg.getTimelineLayoutVersion()))).build();
        this.assertTableVersionOnDataAndMetadataTable(this.metaClient, HoodieTableVersion.TWO);
        this.assertTableProps(cfg);
    }

    @ParameterizedTest
    @MethodSource(value={"twoToThreeUpgradeConfigParams"})
    public void testUpgradeTwoToThree(HoodieTableType tableType, Option<String> keyGeneratorClass) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addNewTableParamsToProps(params);
        if (tableType == HoodieTableType.MERGE_ON_READ) {
            params.put(HoodieTableConfig.TYPE.key(), HoodieTableType.MERGE_ON_READ.name());
            this.metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)HoodieTableType.MERGE_ON_READ);
        }
        HoodieWriteConfig.Builder cfgBuilder = this.getConfigBuilder().withAutoCommit(false).withRollbackUsingMarkers(false).withProps(params);
        if (keyGeneratorClass.isPresent()) {
            cfgBuilder.withKeyGenerator((String)keyGeneratorClass.get());
        }
        HoodieWriteConfig cfg = cfgBuilder.build();
        SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);
        this.doInsert(client);
        this.downgradeTableConfigsFromThreeToTwo(cfg);
        new UpgradeDowngrade(this.metaClient, cfg, (HoodieEngineContext)this.context, (SupportsUpgradeDowngrade)SparkUpgradeDowngradeHelper.getInstance()).run(HoodieTableVersion.THREE, null);
        this.metaClient = HoodieTableMetaClient.builder().setConf(this.context.getStorageConf().newInstance()).setBasePath(cfg.getBasePath()).setLayoutVersion(Option.of((Object)new TimelineLayoutVersion(cfg.getTimelineLayoutVersion()))).build();
        this.assertTableVersionOnDataAndMetadataTable(this.metaClient, HoodieTableVersion.THREE);
        HoodieTableConfig tableConfig = this.metaClient.getTableConfig();
        TypedProperties originalProps = cfg.getProps();
        org.junit.jupiter.api.Assertions.assertEquals((Object)tableConfig.getUrlEncodePartitioning(), (Object)cfg.getStringOrDefault(HoodieTableConfig.URL_ENCODE_PARTITIONING));
        org.junit.jupiter.api.Assertions.assertEquals((Object)tableConfig.getHiveStylePartitioningEnable(), (Object)cfg.getStringOrDefault(HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)tableConfig.getKeyGeneratorClassName(), (Object)originalProps.getOrDefault((Object)HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), SimpleKeyGenerator.class.getName()));
    }

    @Test
    public void testUpgradeDowngradeBetweenThreeAndCurrentVersion() throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addNewTableParamsToProps(params);
        HoodieWriteConfig cfg = this.getConfigBuilder().withAutoCommit(false).withRollbackUsingMarkers(false).withProps(params).build();
        SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);
        this.doInsert(client);
        this.assertTableVersionOnDataAndMetadataTable(this.metaClient, HoodieTableVersion.current());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.metaClient.getTableConfig().getProps().containsKey((Object)HoodieTableConfig.TABLE_CHECKSUM.key()));
        String checksum = this.metaClient.getTableConfig().getProps().getString(HoodieTableConfig.TABLE_CHECKSUM.key());
        new UpgradeDowngrade(this.metaClient, cfg, (HoodieEngineContext)this.context, (SupportsUpgradeDowngrade)SparkUpgradeDowngradeHelper.getInstance()).run(HoodieTableVersion.THREE, null);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        this.assertTableVersionOnDataAndMetadataTable(this.metaClient, HoodieTableVersion.THREE);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.metaClient.getTableConfig().getProps().containsKey((Object)HoodieTableConfig.TABLE_CHECKSUM.key()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)checksum, (Object)this.metaClient.getTableConfig().getProps().getString(HoodieTableConfig.TABLE_CHECKSUM.key()));
        this.metaClient.getTableConfig().getProps().remove((Object)HoodieTableConfig.TABLE_CHECKSUM.key());
        new UpgradeDowngrade(this.metaClient, cfg, (HoodieEngineContext)this.context, (SupportsUpgradeDowngrade)SparkUpgradeDowngradeHelper.getInstance()).run(HoodieTableVersion.SIX, null);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        this.assertTableVersionOnDataAndMetadataTable(this.metaClient, HoodieTableVersion.SIX);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.metaClient.getTableConfig().getProps().containsKey((Object)HoodieTableConfig.TABLE_CHECKSUM.key()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)checksum, (Object)this.metaClient.getTableConfig().getProps().getString(HoodieTableConfig.TABLE_CHECKSUM.key()));
    }

    @Test
    public void testUpgradeFourtoFive() throws Exception {
        this.testUpgradeFourToFiveInternal(false, false, false);
    }

    @Test
    public void testUpgradeFourtoFiveWithDefaultPartition() throws Exception {
        this.testUpgradeFourToFiveInternal(true, false, false);
    }

    @Test
    public void testUpgradeFourtoFiveWithDefaultPartitionWithSkipValidation() throws Exception {
        this.testUpgradeFourToFiveInternal(true, true, false);
    }

    @Test
    public void testUpgradeFourtoFiveWithHiveStyleDefaultPartition() throws Exception {
        this.testUpgradeFourToFiveInternal(true, false, true);
    }

    @Test
    public void testUpgradeFourtoFiveWithHiveStyleDefaultPartitionWithSkipValidation() throws Exception {
        this.testUpgradeFourToFiveInternal(true, true, true);
    }

    private void testUpgradeFourToFiveInternal(boolean assertDefaultPartition, boolean skipDefaultPartitionValidation, boolean isHiveStyle) throws Exception {
        String tableName = this.metaClient.getTableConfig().getTableName();
        this.cleanUp();
        this.initSparkContexts();
        this.initPath();
        this.initTestDataGenerator();
        HashMap<String, String> params = new HashMap<String, String>();
        this.addNewTableParamsToProps(params, tableName);
        Properties properties = new Properties();
        params.forEach((k, v) -> properties.setProperty((String)k, (String)v));
        this.initMetaClient(this.getTableType(), properties);
        HoodieWriteConfig cfg = this.getConfigBuilder().withAutoCommit(true).withRollbackUsingMarkers(false).withWriteTableVersion(6).doSkipDefaultPartitionValidation(skipDefaultPartitionValidation).withProps(params).build();
        SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);
        this.doInsert(client);
        if (assertDefaultPartition) {
            if (isHiveStyle) {
                this.doInsertWithDefaultHiveStylePartition(client);
                cfg.setValue(HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), "true");
            } else {
                this.doInsertWithDefaultPartition(client);
            }
        }
        this.downgradeTableConfigsFromFiveToFour(cfg);
        if (assertDefaultPartition && !skipDefaultPartitionValidation) {
            org.junit.jupiter.api.Assertions.assertThrows(HoodieException.class, () -> new UpgradeDowngrade(this.metaClient, cfg, (HoodieEngineContext)this.context, (SupportsUpgradeDowngrade)SparkUpgradeDowngradeHelper.getInstance()).run(HoodieTableVersion.FIVE, null), (String)"Upgrade from 4 to 5 is expected to fail if \"default\" partition is present.");
        } else {
            new UpgradeDowngrade(this.metaClient, cfg, (HoodieEngineContext)this.context, (SupportsUpgradeDowngrade)SparkUpgradeDowngradeHelper.getInstance()).run(HoodieTableVersion.FIVE, null);
            this.metaClient = HoodieTableMetaClient.builder().setConf(this.context.getStorageConf().newInstance()).setBasePath(cfg.getBasePath()).build();
            this.assertTableVersionOnDataAndMetadataTable(this.metaClient, HoodieTableVersion.FIVE);
            this.assertTableProps(cfg);
        }
    }

    private void addNewTableParamsToProps(Map<String, String> params) {
        this.addNewTableParamsToProps(params, this.metaClient.getTableConfig().getTableName());
    }

    private void addNewTableParamsToProps(Map<String, String> params, String tableName) {
        params.put(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "uuid");
        params.put(HoodieTableConfig.RECORDKEY_FIELDS.key(), "uuid");
        params.put(HoodieTableConfig.PARTITION_FIELDS.key(), "partition_path");
        params.put(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "partition_path");
        params.put(HoodieTableConfig.NAME.key(), tableName);
        params.put(HoodieTableConfig.BASE_FILE_FORMAT.key(), ((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).name());
        params.put("hoodie.table.version", "6");
    }

    private void doInsert(SparkRDDWriteClient client) {
        String commit1 = "000";
        client.startCommitWithTime(commit1);
        List records = this.dataGen.generateInserts(commit1, Integer.valueOf(100));
        JavaRDD writeRecords = this.jsc.parallelize(records, 1);
        client.insert(writeRecords, commit1).collect();
    }

    private void doInsertWithDefaultPartition(SparkRDDWriteClient client) {
        this.dataGen = new HoodieTestDataGenerator(new String[]{"default"});
        String commit1 = "005";
        client.startCommitWithTime(commit1);
        List records = this.dataGen.generateInserts(commit1, Integer.valueOf(100));
        JavaRDD writeRecords = this.jsc.parallelize(records, 1);
        client.insert(writeRecords, commit1).collect();
    }

    private void doInsertWithDefaultHiveStylePartition(SparkRDDWriteClient client) {
        this.dataGen = new HoodieTestDataGenerator(new String[]{"partition_path=default"});
        String commit1 = "005";
        client.startCommitWithTime(commit1);
        List records = this.dataGen.generateInserts(commit1, Integer.valueOf(100));
        JavaRDD writeRecords = this.jsc.parallelize(records, 1);
        client.insert(writeRecords, commit1).collect();
    }

    private void downgradeTableConfigsFromTwoToOne(HoodieWriteConfig cfg) throws IOException {
        Properties properties = new Properties((Properties)cfg.getProps());
        properties.remove(HoodieTableConfig.RECORDKEY_FIELDS.key());
        properties.remove(HoodieTableConfig.PARTITION_FIELDS.key());
        properties.remove(HoodieTableConfig.NAME.key());
        properties.remove(HoodieTableConfig.BASE_FILE_FORMAT.key());
        properties.setProperty(HoodieTableConfig.VERSION.key(), "1");
        this.metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)this.getTableType(), (Properties)properties);
        this.metaClient.getTableConfig().setTableVersion(HoodieTableVersion.ONE);
    }

    private void downgradeTableConfigsFromThreeToTwo(HoodieWriteConfig cfg) throws IOException {
        Properties properties = new Properties((Properties)cfg.getProps());
        properties.remove(HoodieTableConfig.URL_ENCODE_PARTITIONING.key());
        properties.remove(HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key());
        properties.remove(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key());
        properties.remove(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key());
        properties.setProperty(HoodieTableConfig.VERSION.key(), "2");
        this.metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)this.getTableType(), (Properties)properties);
        this.metaClient.getTableConfig().setTableVersion(HoodieTableVersion.TWO);
    }

    private void downgradeTableConfigsFromFiveToFour(HoodieWriteConfig cfg) throws IOException {
        Properties properties = new Properties();
        cfg.getProps().forEach((k, v) -> properties.setProperty((String)k, (String)v));
        properties.setProperty(HoodieTableConfig.VERSION.key(), "4");
        this.metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)this.getTableType(), (Properties)properties);
        this.metaClient.getTableConfig().setTableVersion(HoodieTableVersion.FOUR);
        HoodieTableConfig.update((HoodieStorage)this.metaClient.getStorage(), (StoragePath)this.metaClient.getMetaPath(), (Properties)this.metaClient.getTableConfig().getProps());
        StoragePath metadataTablePath = HoodieTableMetadata.getMetadataTableBasePath((StoragePath)this.metaClient.getBasePath());
        if (this.metaClient.getStorage().exists(metadataTablePath)) {
            HoodieTableMetaClient mdtMetaClient = HoodieTableMetaClient.builder().setConf(this.metaClient.getStorageConf().newInstance()).setBasePath(metadataTablePath).build();
            this.metaClient.getTableConfig().setTableVersion(HoodieTableVersion.FOUR);
            HoodieTableConfig.update((HoodieStorage)mdtMetaClient.getStorage(), (StoragePath)mdtMetaClient.getMetaPath(), (Properties)this.metaClient.getTableConfig().getProps());
        }
        this.assertTableVersionOnDataAndMetadataTable(this.metaClient, HoodieTableVersion.FOUR);
    }

    private void assertTableProps(HoodieWriteConfig cfg) {
        HoodieTableConfig tableConfig = this.metaClient.getTableConfig();
        TypedProperties originalProps = cfg.getProps();
        org.junit.jupiter.api.Assertions.assertEquals((Object)tableConfig.getPartitionFieldProp(), (Object)originalProps.getProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)tableConfig.getRecordKeyFieldProp(), (Object)originalProps.getProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)tableConfig.getTableName(), (Object)cfg.getTableName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)tableConfig.getBaseFileFormat().name(), (Object)originalProps.getProperty(HoodieTableConfig.BASE_FILE_FORMAT.key()));
    }

    @Test
    public void testDowngradeSixToFiveShouldDeleteRecordIndexPartition() throws Exception {
        HoodieWriteConfig config = this.getConfigBuilder().withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).withMetadataIndexBloomFilter(true).withEnableRecordIndex(true).build()).build();
        for (MetadataPartitionType partitionType : MetadataPartitionType.getValidValues()) {
            this.metaClient.getTableConfig().setMetadataPartitionState(this.metaClient, partitionType.getPartitionPath(), true);
        }
        this.metaClient.getTableConfig().setMetadataPartitionsInflight(this.metaClient, MetadataPartitionType.getValidValues());
        String metadataTableBasePath = Paths.get(this.basePath, ".hoodie/metadata").toString();
        HoodieTableMetaClient metadataTableMetaClient = HoodieTestUtils.init((String)metadataTableBasePath, (HoodieTableType)HoodieTableType.MERGE_ON_READ);
        HoodieMetadataTestTable.of((HoodieTableMetaClient)metadataTableMetaClient).addCommit("000").withBaseFilesInPartition(MetadataPartitionType.RECORD_INDEX.getPartitionPath(), new int[]{0});
        java.nio.file.Path recordIndexPartitionPath = Paths.get(this.basePath, ".hoodie/metadata", MetadataPartitionType.RECORD_INDEX.getPartitionPath());
        Set allPartitions = MetadataPartitionType.getAllPartitionPaths();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Files.exists(recordIndexPartitionPath, new LinkOption[0]), (String)"record index partition should exist.");
        org.junit.jupiter.api.Assertions.assertEquals((Object)allPartitions, (Object)this.metaClient.getTableConfig().getMetadataPartitions(), (String)(HoodieTableConfig.TABLE_METADATA_PARTITIONS.key() + " should contain all partitions."));
        org.junit.jupiter.api.Assertions.assertEquals((Object)allPartitions, (Object)this.metaClient.getTableConfig().getMetadataPartitionsInflight(), (String)(HoodieTableConfig.TABLE_METADATA_PARTITIONS_INFLIGHT.key() + " should contain all partitions."));
        this.prepForDowngradeFromVersion(HoodieTableVersion.SIX);
        new UpgradeDowngrade(this.metaClient, config, (HoodieEngineContext)this.context, (SupportsUpgradeDowngrade)SparkUpgradeDowngradeHelper.getInstance()).run(HoodieTableVersion.FIVE, null);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Files.exists(recordIndexPartitionPath, new LinkOption[0]), (String)"record index partition should be deleted.");
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)this.metaClient.getTableConfig().getMetadataPartitions(), (String)(HoodieTableConfig.TABLE_METADATA_PARTITIONS.key() + " should contain all partitions except record_index."));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)this.metaClient.getTableConfig().getMetadataPartitionsInflight(), (String)(HoodieTableConfig.TABLE_METADATA_PARTITIONS_INFLIGHT.key() + " should contain all partitions except record_index."));
    }

    @ParameterizedTest(name="[{index}] Test with deletePartialMarkerFiles={0} and TableType = {1} and  enableMetadataTable = {2} and from {3} to {4}")
    @MethodSource(value={"downGradeConfigParams"})
    public void testDowngrade(boolean deletePartialMarkerFiles, HoodieTableType tableType, boolean enableMetadataTable, HoodieTableVersion fromVersion, HoodieTableVersion toVersion) throws IOException {
        MarkerType markerType = fromVersion.versionCode() >= HoodieTableVersion.TWO.versionCode() ? MarkerType.TIMELINE_SERVER_BASED : MarkerType.DIRECT;
        HashMap<String, String> params = new HashMap<String, String>();
        if (fromVersion.versionCode() >= HoodieTableVersion.TWO.versionCode()) {
            this.addNewTableParamsToProps(params, this.metaClient.getTableConfig().getTableName());
        }
        if (tableType == HoodieTableType.MERGE_ON_READ) {
            params.put(HoodieTableConfig.TYPE.key(), HoodieTableType.MERGE_ON_READ.name());
            this.metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)HoodieTableType.MERGE_ON_READ);
        }
        HoodieWriteConfig cfg = this.getConfigBuilder().withAutoCommit(false).withRollbackUsingMarkers(true).withWriteTableVersion(6).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(enableMetadataTable).build()).withMarkersType(markerType.name()).withProps(params).build();
        SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);
        if (fromVersion.versionCode() >= HoodieTableVersion.TWO.versionCode()) {
            HoodieTableConfig tableConfig = this.metaClient.getTableConfig();
            tableConfig.setValue(HoodieTableConfig.NAME, cfg.getTableName());
            tableConfig.setValue(HoodieTableConfig.PARTITION_FIELDS, cfg.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()));
            tableConfig.setValue(HoodieTableConfig.RECORDKEY_FIELDS, cfg.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()));
            tableConfig.setValue(HoodieTableConfig.BASE_FILE_FORMAT, cfg.getString(HoodieTableConfig.BASE_FILE_FORMAT));
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableVersion.SEVEN.greaterThan(fromVersion));
        this.prepForDowngradeFromVersion(HoodieTableVersion.SIX);
        ArrayList<FileSlice> firstPartitionCommit2FileSlices = new ArrayList<FileSlice>();
        ArrayList<FileSlice> secondPartitionCommit2FileSlices = new ArrayList<FileSlice>();
        this.twoUpsertCommitDataWithTwoPartitions(firstPartitionCommit2FileSlices, secondPartitionCommit2FileSlices, cfg, client, false);
        HoodieSparkTable table = this.getHoodieTable(this.metaClient, cfg);
        HoodieInstant commitsInstant = (HoodieInstant)table.getPendingCommitsTimeline().lastInstant().get();
        WriteMarkers writeMarkers = WriteMarkersFactory.get((MarkerType)markerType, (HoodieTable)table, (String)commitsInstant.requestedTime());
        ArrayList markerPaths = new ArrayList(writeMarkers.allMarkerFilePaths());
        if (deletePartialMarkerFiles) {
            String toDeleteMarkerFile = (String)markerPaths.get(0);
            table.getStorage().deleteDirectory(new StoragePath(table.getMetaClient().getTempFolderPath() + "/" + commitsInstant.requestedTime() + "/" + toDeleteMarkerFile));
            markerPaths.remove(toDeleteMarkerFile);
        }
        this.prepForDowngradeFromVersion(fromVersion);
        new UpgradeDowngrade(this.metaClient, cfg, (HoodieEngineContext)this.context, (SupportsUpgradeDowngrade)SparkUpgradeDowngradeHelper.getInstance()).run(toVersion, null);
        if (fromVersion.versionCode() == HoodieTableVersion.TWO.versionCode()) {
            this.assertMarkerFilesForDowngrade((HoodieTable)table, commitsInstant, toVersion == HoodieTableVersion.ONE);
        }
        this.metaClient = HoodieTableMetaClient.builder().setConf(this.context.getStorageConf().newInstance()).setBasePath(cfg.getBasePath()).setLayoutVersion(Option.of((Object)new TimelineLayoutVersion(cfg.getTimelineLayoutVersion()))).build();
        this.assertTableVersionOnDataAndMetadataTable(this.metaClient, toVersion);
    }

    @Test
    void testNeedsUpgrade() {
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)tableConfig.getTableVersion()).thenReturn((Object)HoodieTableVersion.EIGHT);
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)metaClient.getTableConfig()).thenReturn((Object)tableConfig);
        HoodieWriteConfig writeConfig = (HoodieWriteConfig)Mockito.mock(HoodieWriteConfig.class);
        Mockito.when((Object)writeConfig.autoUpgrade()).thenReturn((Object)true);
        boolean shouldDowngrade = new UpgradeDowngrade(metaClient, writeConfig, (HoodieEngineContext)this.context, null).needsUpgrade(HoodieTableVersion.SEVEN);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)shouldDowngrade);
        shouldDowngrade = new UpgradeDowngrade(metaClient, writeConfig, (HoodieEngineContext)this.context, null).needsUpgrade(HoodieTableVersion.SIX);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)shouldDowngrade);
        shouldDowngrade = new UpgradeDowngrade(metaClient, writeConfig, (HoodieEngineContext)this.context, null).needsUpgrade(HoodieTableVersion.EIGHT);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)shouldDowngrade);
        Mockito.when((Object)tableConfig.getTableVersion()).thenReturn((Object)HoodieTableVersion.SIX);
        boolean shouldUpgrade = new UpgradeDowngrade(metaClient, writeConfig, (HoodieEngineContext)this.context, null).needsUpgrade(HoodieTableVersion.SEVEN);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)shouldUpgrade);
        shouldUpgrade = new UpgradeDowngrade(metaClient, writeConfig, (HoodieEngineContext)this.context, null).needsUpgrade(HoodieTableVersion.EIGHT);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)shouldUpgrade);
        Mockito.when((Object)writeConfig.autoUpgrade()).thenReturn((Object)false);
        shouldUpgrade = new UpgradeDowngrade(metaClient, writeConfig, (HoodieEngineContext)this.context, null).needsUpgrade(HoodieTableVersion.EIGHT);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)shouldUpgrade);
    }

    private void assertMarkerFilesForDowngrade(HoodieTable table, HoodieInstant commitInstant, boolean assertExists) throws IOException {
        WriteMarkers writeMarkers = WriteMarkersFactory.get((MarkerType)this.getConfig().getMarkersType(), (HoodieTable)table, (String)commitInstant.requestedTime());
        if (assertExists) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writeMarkers.doesMarkerDirExist());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.getTimelineServerBasedMarkerFileCount(table.getMetaClient().getMarkerFolderPath(commitInstant.requestedTime()), (FileSystem)table.getStorage().getFileSystem()));
        } else {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)writeMarkers.doesMarkerDirExist());
        }
    }

    private long getTimelineServerBasedMarkerFileCount(String markerDir, FileSystem fileSystem) throws IOException {
        FileStatus[] fileStatuses = fileSystem.listStatus(new Path(markerDir));
        Predicate<String> prefixFilter = pathStr -> pathStr.contains("MARKERS");
        return Arrays.stream(fileStatuses).map(fileStatus -> fileStatus.getPath().toString()).filter(prefixFilter).collect(Collectors.toList()).stream().count();
    }

    private void assertMarkerFilesForUpgrade(HoodieTable table, HoodieInstant commitInstant, List<FileSlice> firstPartitionCommit2FileSlices, List<FileSlice> secondPartitionCommit2FileSlices) throws IOException {
        WriteMarkers writeMarkers = WriteMarkersFactory.get((MarkerType)this.getConfig().getMarkersType(), (HoodieTable)table, (String)commitInstant.requestedTime());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)writeMarkers.doesMarkerDirExist());
        Set files = writeMarkers.allMarkerFilePaths();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)files.size());
        ArrayList<String> actualFiles = new ArrayList<String>();
        for (String file : files) {
            String fileName = WriteMarkers.stripMarkerSuffix((String)file);
            actualFiles.add(fileName);
        }
        ArrayList<FileSlice> expectedFileSlices = new ArrayList<FileSlice>();
        expectedFileSlices.addAll(firstPartitionCommit2FileSlices);
        expectedFileSlices.addAll(secondPartitionCommit2FileSlices);
        ArrayList<String> expectedPaths = new ArrayList<String>();
        ArrayList<Pair> expectedLogFilePaths = new ArrayList<Pair>();
        for (FileSlice fileSlice : expectedFileSlices) {
            String partitionPath = fileSlice.getPartitionPath();
            if (table.getMetaClient().getTableType() == HoodieTableType.MERGE_ON_READ) {
                for (HoodieLogFile logFile : fileSlice.getLogFiles().collect(Collectors.toList())) {
                    String logBaseCommitTime = logFile.getDeltaCommitTime();
                    expectedLogFilePaths.add(Pair.of((Object)(partitionPath + "/" + logFile.getFileId()), (Object)logBaseCommitTime));
                }
            }
            if (!fileSlice.getBaseInstantTime().equals(commitInstant.requestedTime())) continue;
            String path = ((HoodieBaseFile)fileSlice.getBaseFile().get()).getPath();
            expectedPaths.add(path.substring(path.indexOf(partitionPath)));
        }
        ArrayList<String> trimmedActualFiles = new ArrayList<String>();
        for (String actualFile : actualFiles) {
            if (table.getMetaClient().getTableType() == HoodieTableType.MERGE_ON_READ) {
                trimmedActualFiles.add(actualFile.substring(0, actualFile.lastIndexOf(46)));
                continue;
            }
            trimmedActualFiles.add(actualFile);
        }
        for (String expected : expectedPaths) {
            if (!trimmedActualFiles.contains(expected)) continue;
            trimmedActualFiles.remove(expected);
        }
        if (expectedLogFilePaths.size() > 0) {
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (String actual : trimmedActualFiles) {
                arrayList.add(Pair.of((Object)actual.substring(0, actual.indexOf(95)), (Object)actual.substring(actual.lastIndexOf(95) + 1)));
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)expectedLogFilePaths.size(), (int)arrayList.size());
            for (Pair entry : expectedLogFilePaths) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)arrayList.contains(entry));
            }
        } else {
            org.junit.jupiter.api.Assertions.assertTrue((trimmedActualFiles.size() == 0 ? 1 : 0) != 0);
        }
    }

    private List<HoodieRecord> triggerCommit(String newCommitTime, HoodieTableType tableType, boolean enableMarkedBasedRollback) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (tableType == HoodieTableType.MERGE_ON_READ) {
            params.put(HoodieTableConfig.TYPE.key(), HoodieTableType.MERGE_ON_READ.name());
        }
        HoodieWriteConfig cfg = this.getConfigBuilder().withAutoCommit(false).withRollbackUsingMarkers(enableMarkedBasedRollback).withProps(params).build();
        SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);
        client.startCommitWithTime(newCommitTime);
        List records = this.dataGen.generateInsertsContainsAllPartitions(newCommitTime, Integer.valueOf(2));
        JavaRDD writeRecords = this.jsc.parallelize(records, 1);
        JavaRDD statuses = client.upsert(writeRecords, newCommitTime);
        Assertions.assertNoWriteErrors((List)statuses.collect());
        client.commit(newCommitTime, (Object)statuses);
        return records;
    }

    private void assertRows(List<HoodieRecord> firstBatch, List<HoodieRecord> secondBatch) {
        String[] fullPartitionPaths = new String[this.dataGen.getPartitionPaths().length];
        for (int i = 0; i < fullPartitionPaths.length; ++i) {
            fullPartitionPaths[i] = String.format("%s/%s/*", this.basePath, this.dataGen.getPartitionPaths()[i]);
        }
        Dataset<Row> rows = HoodieClientTestUtils.read(this.jsc, this.metaClient.getBasePath().toString(), this.sqlContext, this.metaClient.getStorage(), fullPartitionPaths);
        ArrayList<String> expectedRecordKeys = new ArrayList<String>();
        for (HoodieRecord rec : firstBatch) {
            expectedRecordKeys.add(rec.getRecordKey());
        }
        for (HoodieRecord rec : secondBatch) {
            expectedRecordKeys.add(rec.getRecordKey());
        }
        List rowList = rows.collectAsList();
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedRecordKeys.size(), (long)rows.count());
        ArrayList<Object> actualRecordKeys = new ArrayList<Object>();
        for (Row row : rowList) {
            actualRecordKeys.add(row.getAs("_row_key"));
        }
        for (String expectedRecordKey : expectedRecordKeys) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)actualRecordKeys.contains(expectedRecordKey));
        }
    }

    private Pair<List<HoodieRecord>, List<HoodieRecord>> twoUpsertCommitDataWithTwoPartitions(List<FileSlice> firstPartitionCommit2FileSlices, List<FileSlice> secondPartitionCommit2FileSlices, HoodieWriteConfig cfg, SparkRDDWriteClient client, boolean commitSecondUpsert) throws IOException {
        this.dataGen = new HoodieTestDataGenerator(new String[]{"2016/03/15", "2015/03/16"});
        HoodieTestDataGenerator.writePartitionMetadataDeprecated((HoodieStorage)this.metaClient.getStorage(), (String[])new String[]{"2016/03/15", "2015/03/16"}, (String)this.basePath);
        String newCommitTime = "001";
        client.startCommitWithTime(newCommitTime);
        List records = this.dataGen.generateInsertsContainsAllPartitions(newCommitTime, Integer.valueOf(2));
        JavaRDD writeRecords = this.jsc.parallelize(records, 1);
        JavaRDD statuses = client.upsert(writeRecords, newCommitTime);
        Assertions.assertNoWriteErrors((List)statuses.collect());
        client.commit(newCommitTime, (Object)statuses);
        newCommitTime = "002";
        client.startCommitWithTime(newCommitTime);
        List records2 = this.dataGen.generateUpdates(newCommitTime, records);
        statuses = client.upsert(this.jsc.parallelize(records2, 1), newCommitTime);
        Assertions.assertNoWriteErrors((List)statuses.collect());
        if (commitSecondUpsert) {
            client.commit(newCommitTime, (Object)statuses);
        }
        HoodieSparkTable table = this.getHoodieTable(this.metaClient, cfg);
        SyncableFileSystemView fsView = this.getFileSystemViewWithUnCommittedSlices(table.getMetaClient());
        List firstPartitionCommit2FileGroups = fsView.getAllFileGroups("2016/03/15").collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)firstPartitionCommit2FileGroups.size());
        firstPartitionCommit2FileSlices.addAll(((HoodieFileGroup)firstPartitionCommit2FileGroups.get(0)).getAllFileSlices().collect(Collectors.toList()));
        List secondPartitionCommit2FileGroups = fsView.getAllFileGroups("2015/03/16").collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)secondPartitionCommit2FileGroups.size());
        secondPartitionCommit2FileSlices.addAll(((HoodieFileGroup)secondPartitionCommit2FileGroups.get(0)).getAllFileSlices().collect(Collectors.toList()));
        HoodieTableType tableType = this.metaClient.getTableType();
        if (tableType.equals((Object)HoodieTableType.COPY_ON_WRITE)) {
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)firstPartitionCommit2FileSlices.size());
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)secondPartitionCommit2FileSlices.size());
        } else {
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)firstPartitionCommit2FileSlices.size());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)secondPartitionCommit2FileSlices.size());
        }
        return Pair.of((Object)records, (Object)records2);
    }

    private void prepForUpgradeFromZeroToOne(HoodieTable table) throws IOException {
        List instantsToBeParsed = this.metaClient.getActiveTimeline().getCommitsTimeline().getInstantsAsStream().collect(Collectors.toList());
        for (HoodieInstant instant : instantsToBeParsed) {
            WriteMarkers writeMarkers = WriteMarkersFactory.get((MarkerType)table.getConfig().getMarkersType(), (HoodieTable)table, (String)instant.requestedTime());
            Set oldMarkers = writeMarkers.allMarkerFilePaths();
            boolean hasAppendMarker = oldMarkers.stream().anyMatch(marker -> marker.contains(IOType.APPEND.name()) || marker.contains(IOType.CREATE.name()));
            if (!hasAppendMarker) continue;
            writeMarkers.deleteMarkerDir(table.getContext(), 2);
            for (String oldMarker : oldMarkers) {
                String typeStr = oldMarker.substring(oldMarker.lastIndexOf(".") + 1);
                IOType type = IOType.valueOf((String)typeStr);
                String partitionFilePath = WriteMarkers.stripMarkerSuffix((String)oldMarker);
                StoragePath fullFilePath = new StoragePath(this.basePath, partitionFilePath);
                String partitionPath = FSUtils.getRelativePartitionPath((StoragePath)new StoragePath(this.basePath), (StoragePath)fullFilePath.getParent());
                if (FSUtils.isBaseFile((StoragePath)fullFilePath)) {
                    writeMarkers.create(partitionPath, fullFilePath.getName(), type);
                    continue;
                }
                String fileId = FSUtils.getFileIdFromFilePath((StoragePath)fullFilePath);
                String baseInstant = FSUtils.getDeltaCommitTimeFromLogPath((StoragePath)fullFilePath);
                String writeToken = FSUtils.getWriteTokenFromLogPath((StoragePath)fullFilePath);
                writeMarkers.create(partitionPath, FSUtils.makeBaseFileName((String)baseInstant, (String)writeToken, (String)fileId, (String)table.getBaseFileFormat().getFileExtension()), type);
            }
            writeMarkers.allMarkerFilePaths().forEach(markerPath -> org.junit.jupiter.api.Assertions.assertFalse((boolean)markerPath.contains(".log")));
        }
    }

    private void prepForDowngradeFromVersion(HoodieTableVersion fromVersion) throws IOException {
        this.metaClient.getTableConfig().setTableVersion(fromVersion);
        HoodieTableConfig.update((HoodieStorage)this.metaClient.getStorage(), (StoragePath)this.metaClient.getMetaPath(), (Properties)this.metaClient.getTableConfig().getProps());
        this.metaClient.reloadTableConfig();
        StoragePath propertyFile = new StoragePath(this.metaClient.getMetaPath(), "hoodie.properties");
        try (OutputStream os = this.metaClient.getStorage().create(propertyFile);){
            this.metaClient.getTableConfig().getProps().store(os, "");
        }
    }

    private void createResidualFile() throws IOException {
        Path propertyFile = new Path(this.metaClient.getMetaPath().toString(), "hoodie.properties");
        Path updatedPropertyFile = new Path(this.metaClient.getMetaPath().toString(), "hoodie.properties.updated");
        FileSystem fs = (FileSystem)this.metaClient.getStorage().getFileSystem();
        FileUtil.copy((FileSystem)fs, (Path)propertyFile, (FileSystem)fs, (Path)updatedPropertyFile, (boolean)false, (Configuration)((Configuration)this.storageConf.unwrap()));
    }

    private void assertTableVersionOnDataAndMetadataTable(HoodieTableMetaClient metaClient, HoodieTableVersion expectedVersion) throws IOException {
        this.assertTableVersion(metaClient, expectedVersion);
        if (expectedVersion.versionCode() >= HoodieTableVersion.FOUR.versionCode()) {
            StoragePath metadataTablePath = HoodieTableMetadata.getMetadataTableBasePath((StoragePath)metaClient.getBasePath());
            if (metaClient.getStorage().exists(metadataTablePath)) {
                HoodieTableMetaClient mdtMetaClient = HoodieTableMetaClient.builder().setConf(metaClient.getStorageConf().newInstance()).setBasePath(metadataTablePath).build();
                this.assertTableVersion(mdtMetaClient, expectedVersion);
            }
        }
    }

    private void assertTableVersion(HoodieTableMetaClient metaClient, HoodieTableVersion expectedVersion) throws IOException {
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedVersion.versionCode(), (int)metaClient.getTableConfig().getTableVersion().versionCode());
        StoragePath propertyFile = new StoragePath(metaClient.getMetaPath(), "hoodie.properties");
        InputStream inputStream = metaClient.getStorage().open(propertyFile);
        HoodieConfig config = new HoodieConfig();
        config.getProps().load(inputStream);
        inputStream.close();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Integer.toString(expectedVersion.versionCode()), (Object)config.getString(HoodieTableConfig.VERSION));
    }
}

